/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model.tickets;

import com.inet.annotations.InternalApi;
import com.inet.field.SelectOption;
import com.inet.field.fieldtypes.FieldOperator;
import com.inet.field.fieldtypes.FieldType;
import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.field.fieldtypes.FieldTypeSelect;
import com.inet.field.fieldtypes.HasSelectOptions;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationNewReaStep;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.shared.model.Status;
import com.inet.helpdesk.usersandgroups.HDFieldDisplayNameProvider;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import com.inet.usersandgroups.api.BasicFieldValidation;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class TicketFieldResourceGuid
extends TicketField<GUID> {
    public static final String KEY = "resourceid";

    public TicketFieldResourceGuid() {
        super(KEY, null, FieldTypeFactory.custom());
    }

    @Nonnull
    public FieldType<GUID> createFieldType() {
        HasSelectOptions optionsLoader = new HasSelectOptions(){

            public List<SelectOption> getSelectOptions(boolean includeDeleted) {
                UserGroupManager groupManager = UserGroupManager.getInstance();
                Set groupsIncludingDeactivated = includeDeleted ? groupManager.getGroupsIncludingDeactivated(HDUsersAndGroups.RESOURCE) : UserGroupManager.getInstance().getGroups(HDUsersAndGroups.RESOURCE);
                List list = groupsIncludingDeactivated.stream().map(ugi -> {
                    String display = HDUsersAndGroups.getResourceFullDisplayName(ugi);
                    return new SelectOption(ugi.getID().toString(), display);
                }).collect(Collectors.toCollection(ArrayList::new));
                list.add(0, new SelectOption(null, "", ""));
                Collections.sort(list, (op1, op2) -> op1.getLabel().compareTo(op2.getLabel()));
                return list;
            }
        };
        return new FieldTypeSelect<GUID>(this.getKey(), () -> this.getLabel(), optionsLoader){

            @Nullable
            public String getDisplayValue(@Nullable GUID resId) {
                if (resId == null) {
                    return null;
                }
                UserGroupManager groupManager = UserGroupManager.getInstance();
                UserGroupInfo ressourceGroup = groupManager.getGroup(resId);
                return HDUsersAndGroups.getResourceFullDisplayName(ressourceGroup);
            }

            protected SearchDataType getSearchDataType() {
                return SearchDataType.StringMap;
            }

            @Nullable
            public GUID valueOf(@Nullable String value) {
                if (value == null) {
                    return null;
                }
                return GUID.valueOf((String)value);
            }

            public SearchTag createSearchTag(Supplier<String> displayname, @Nonnull FieldTypeFactory fieldTypeFactory) {
                return super.createSearchTag(displayname, fieldTypeFactory);
            }

            public Set<FieldOperator> getSupportedOperators() {
                HashSet<FieldOperator> supportedOperators = new HashSet<FieldOperator>(super.getSupportedOperators());
                supportedOperators.add(FieldOperator.IS_OR_IS_BELOW);
                return supportedOperators;
            }
        };
    }

    public GUID copyValue(GUID value) {
        return value;
    }

    @Override
    public TicketVOSingle getValueSourceForSlaveTicketForEnduser(TicketVOSingle master, TicketVOSingle slave) {
        return master;
    }

    @Override
    public OperationNewReaStep createStringFieldChangeReaStep(GUID oldFieldValue, GUID newFieldValue, MutableReaStepData additionalReaStepData, OperationChangedTicket ticket) {
        if (ticket.getOldTicket().get().isInquiry()) {
            OperationNewReaStep authorizationStep = this.findAuthorizationStep(ticket);
            if (authorizationStep != null) {
                return null;
            }
            return super.createStringFieldChangeReaStep(oldFieldValue, newFieldValue, additionalReaStepData, ticket);
        }
        if (Status.isClosedStatus(ticket.getOldTicket().get().getStatusID())) {
            return super.createStringFieldChangeReaStep(oldFieldValue, newFieldValue, additionalReaStepData, ticket);
        }
        return null;
    }

    @Nullable
    private OperationNewReaStep findAuthorizationStep(OperationChangedTicket ticket) {
        for (OperationNewReaStep step : ticket.getAddedReaSteps()) {
            if (step.getAttributes().get(ReaStepVO.ATTRIBUTE_ACTION_ID) != 5) continue;
            return step;
        }
        return null;
    }

    @Override
    public int getFieldChangeReaStepActionId() {
        return -29;
    }

    @Override
    public String getLabel() {
        return HDFieldDisplayNameProvider.getStaticTicketFieldDisplayName(this.getKey());
    }

    @Override
    public void validateIsValidValue(GUID value) {
        super.validateIsValidValue(value);
        if (value != null) {
            UserGroupInfo group = UserGroupManager.getRecoveryEnabledInstance().getGroup(value);
            BasicFieldValidation.throwIfFieldValueDoesNotExist((Object)group, (Object)value, (String)this.getLabel());
        }
    }
}

