/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config.autotext;

import com.inet.config.ConfigurationManager;
import com.inet.help.api.HelpPageContentProcessor;
import com.inet.helpdesk.config.autotext.data.AutoTextPlaceholder;
import com.inet.helpdesk.config.autotext.data.AutoTextPlaceholderEntry;
import com.inet.helpdesk.config.autotext.handler.CreateOrEditAutoText;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextManager;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.help.HelpPage;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class AutoTextHelpPageContentPatcher
implements HelpPageContentProcessor {
    private static final String AUTO_TEXT_PAGE_KEY = "configuration.autotext.placeholders";

    public static void registerHelp(ServerPluginManager spm) {
        HelpPageContentProcessor.register((HelpPageContentProcessor)new AutoTextHelpPageContentPatcher());
    }

    public void process(@Nonnull String helpKey, @Nonnull Document helpPage, @Nonnull List<HelpPage> pages, @Nonnull Locale locale) {
        if (!AUTO_TEXT_PAGE_KEY.equals(helpKey)) {
            return;
        }
        Element content = (Element)helpPage.getElementsByClass("dokuwiki").get(0);
        if (content == null) {
            return;
        }
        if (ConfigurationManager.isHelpCenterMode()) {
            content.appendChildren(List.of(new Element("p").addClass("text-warning").text(Tickets.MSG.getMsg("autotext.placeholders.notAvailable", new Object[0]))));
            return;
        }
        AutoTextManager atm = (AutoTextManager)ServerPluginManager.getInstance().getSingleInstance(AutoTextManager.class);
        List<AutoTextPlaceholder> placeholderList = CreateOrEditAutoText.getPlaceholderList(atm);
        ArrayList<Element> elementsToAdd = new ArrayList<Element>();
        for (AutoTextPlaceholder autoTextPlaceholder : placeholderList) {
            Element header = new Element("h3");
            header.text(autoTextPlaceholder.getValue());
            elementsToAdd.add(header);
            Element autoTextContent = new Element("div");
            autoTextContent.addClass("level3");
            elementsToAdd.add(autoTextContent);
            int rowNumber = 0;
            Element table = autoTextContent.appendElement("div").addClass("table").appendElement("table").addClass("inline");
            Element headerRow = table.appendElement("thead").appendElement("tr").addClass("row" + rowNumber++);
            headerRow.appendElement("th").addClass("col0").text(Tickets.MSG.getMsg("autotext.placeholders.table.key", new Object[0]));
            headerRow.appendElement("th").addClass("col1").text(Tickets.MSG.getMsg("autotext.placeholders.table.value", new Object[0]));
            Element tableBody = table.appendElement("tbody");
            for (AutoTextPlaceholderEntry entry : autoTextPlaceholder.getEntries()) {
                Element tableRow = tableBody.appendElement("tr").addClass("row" + rowNumber++);
                tableRow.appendElement("td").addClass("col0").appendElement("code").text(String.format("{%s}", entry.getKey()));
                tableRow.appendElement("td").addClass("col1").text(entry.getValue());
            }
        }
        content.appendChildren(elementsToAdd);
    }
}

