/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.bot;

import com.inet.collaboration.bot.BotCommandContext;
import com.inet.collaboration.bot.BotResponseFormatter;
import com.inet.collaboration.bot.MultiCommand;
import com.inet.collaboration.bot.MultiCommandController;
import com.inet.editor.HtmlConverter;
import com.inet.helpdesk.bot.TicketBotUtils;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.plugin.HelpdeskServerPlugin;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.lib.markdown.MarkDown2Html;
import com.inet.search.SearchResult;
import com.inet.search.SearchResultEntry;
import com.inet.search.command.SearchID;
import com.inet.usersandgroups.api.FieldValidationException;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TicketCreationMultiCommand
implements MultiCommand {
    private Map<String, TicketCreationSingleState> states = new HashMap<String, TicketCreationSingleState>();

    public List<String> getSyntaxExamples() {
        return new ArrayList<String>(){
            {
                this.add(HelpdeskServerPlugin.MSG_SERVER.getMsg("ticketcreation.syntax", new Object[0]));
            }
        };
    }

    public String getHelpDescription() {
        return HelpdeskServerPlugin.MSG_SERVER.getMsg("ticketcreation.helpdesc", new Object[0]);
    }

    public String getCommandRegex() {
        return ".*(newticket|neuesticket).*";
    }

    private String getKey(BotCommandContext context) {
        return context.getChannelId() + ";" + context.getUserId();
    }

    public boolean handleNextStep(BotCommandContext context, String text, BotResponseFormatter botResponseFormatter) {
        String key = this.getKey(context);
        TicketCreationSingleState singleData = this.states.get(key);
        if (singleData == null || singleData.finished) {
            singleData = new TicketCreationSingleState();
            this.states.put(key, singleData);
            MultiCommandController.getInstance().registerNewRunningCommand(context, (MultiCommand)this);
        }
        if (text.equalsIgnoreCase("CANCEL") || text.equalsIgnoreCase("ABBRECHEN")) {
            singleData.finished = true;
            MultiCommandController.getInstance().unregisterRunningCommand(context);
            botResponseFormatter.formatResponse(HelpdeskServerPlugin.MSG_SERVER.getMsg("ticketcreation.cancelmsg", new Object[0]));
            return true;
        }
        switch (singleData.step) {
            case USER: {
                if (text.matches(this.getCommandRegex())) {
                    singleData.finished = false;
                    singleData.step = TicketCreationStep.USER;
                    botResponseFormatter.formatResponse(HelpdeskServerPlugin.MSG_SERVER.getMsg("ticketcreation.usermsg", new Object[]{UserManager.getInstance().getCurrentUserAccount().getDisplayName()}));
                    return true;
                }
                this.searchUser(text, botResponseFormatter, singleData);
                return true;
            }
            case USER2: {
                try {
                    UserManager um = UserManager.getInstance();
                    int index = Integer.valueOf(text) - 1;
                    if (index >= singleData.userSearchResults.size() || index < 0) {
                        botResponseFormatter.formatResponse(HelpdeskServerPlugin.MSG_SERVER.getMsg("ticketcreation.whichusermsg", new Object[]{singleData.userSearchResults.size()}));
                    } else {
                        GUID id = (GUID)singleData.userSearchResults.get(index).getId();
                        try {
                            singleData.data.put(Tickets.FIELD_OWNER_GUID, id);
                            botResponseFormatter.formatResponse(HelpdeskServerPlugin.MSG_SERVER.getMsg("ticketcreation.subjectmsg", new Object[]{um.getUserAccount(id).getDisplayName()}));
                            singleData.step = TicketCreationStep.SUBJECT;
                        }
                        catch (FieldValidationException ex) {
                            botResponseFormatter.formatResponse(HelpdeskServerPlugin.MSG_SERVER.getMsg("ticketcreation.fieldvalidationerror", new Object[]{ex.getMessage()}));
                        }
                    }
                }
                catch (NumberFormatException exc) {
                    this.searchUser(text, botResponseFormatter, singleData);
                }
                return true;
            }
            case SUBJECT: {
                try {
                    singleData.data.put(Tickets.FIELD_SUBJECT, text);
                    singleData.step = TicketCreationStep.ANFRAGE_TEXT;
                    botResponseFormatter.formatResponse(HelpdeskServerPlugin.MSG_SERVER.getMsg("ticketcreation.anfragemsg", new Object[]{text}));
                }
                catch (FieldValidationException ex) {
                    botResponseFormatter.formatResponse(HelpdeskServerPlugin.MSG_SERVER.getMsg("ticketcreation.fieldvalidationerror", new Object[]{ex.getMessage()}));
                }
                return true;
            }
            case ANFRAGE_TEXT: {
                singleData.step = TicketCreationStep.NECESSARY_FIELDS;
                singleData.anfrageText = text;
                this.outputTicket(botResponseFormatter, singleData, UserManager.getInstance(), singleData.data.get(Tickets.FIELD_OWNER_GUID));
                return true;
            }
            case NECESSARY_FIELDS: {
                if (text.equalsIgnoreCase("DONE") || text.equalsIgnoreCase("FERTIG")) {
                    try {
                        String html = new MarkDown2Html().blankTarget(true).hardbreak(true).emptyLine(true).convert(singleData.anfrageText);
                        TicketVO ticket = TicketManager.getManipulator().createTicket(ReaStepTextVO.of(html, true), singleData.data, null, null);
                        TicketBotUtils.postTicketToFormatter(ticket, botResponseFormatter);
                        singleData.finished = true;
                        MultiCommandController.getInstance().unregisterRunningCommand(context);
                    }
                    catch (Exception ex) {
                        botResponseFormatter.formatResponse(HelpdeskServerPlugin.MSG_SERVER.getMsg("ticketcreation.erroratcreationmsg", new Object[]{ex.getMessage()}));
                    }
                } else {
                    botResponseFormatter.formatResponse(HelpdeskServerPlugin.MSG_SERVER.getMsg("ticketcreation.donemsg", new Object[0]));
                }
                return true;
            }
        }
        return false;
    }

    private String removeTags(String text) {
        return HtmlConverter.html2text((String)text);
    }

    private void searchUser(String text, BotResponseFormatter botResponseFormatter, TicketCreationSingleState singleData) {
        UserManager instance = UserManager.getInstance();
        if (text.trim().equalsIgnoreCase("/default")) {
            try {
                singleData.data.put(Tickets.FIELD_OWNER_GUID, instance.getCurrentUserAccountID());
                botResponseFormatter.formatResponse(HelpdeskServerPlugin.MSG_SERVER.getMsg("ticketcreation.subjectmsg", new Object[]{instance.getCurrentUserAccount().getDisplayName()}));
                singleData.step = TicketCreationStep.SUBJECT;
            }
            catch (FieldValidationException ex) {
                botResponseFormatter.formatResponse(HelpdeskServerPlugin.MSG_SERVER.getMsg("ticketcreation.fieldvalidationerror", new Object[]{ex.getMessage()}));
            }
            return;
        }
        SearchResult search = instance.search(text, new ArrayList(), new ArrayList(), 5, new SearchID((Object)("" + System.currentTimeMillis())));
        List searchEntries = search.getEntries();
        if (searchEntries.size() > 1) {
            String output = HelpdeskServerPlugin.MSG_SERVER.getMsg("ticketcreation.foundmultipleusersmsg", new Object[0]) + "\n\n";
            int i = 0;
            for (SearchResultEntry e : searchEntries) {
                output = output + ++i + ". ";
                output = output + this.removeTags(e.getFirstResultLine()) + " (" + this.removeTags(e.getSecondResultLine()) + ")\n\n";
            }
            singleData.userSearchResults = searchEntries;
            output = output + HelpdeskServerPlugin.MSG_SERVER.getMsg("ticketcreation.whichusermsg", new Object[]{searchEntries.size()});
            botResponseFormatter.formatResponse(output);
            singleData.step = TicketCreationStep.USER2;
        } else if (searchEntries.size() == 1) {
            GUID id = (GUID)((SearchResultEntry)searchEntries.get(0)).getId();
            try {
                singleData.data.put(Tickets.FIELD_OWNER_GUID, id);
                botResponseFormatter.formatResponse(HelpdeskServerPlugin.MSG_SERVER.getMsg("ticketcreation.subjectmsg", new Object[]{instance.getUserAccount(id).getDisplayName()}));
                singleData.step = TicketCreationStep.SUBJECT;
            }
            catch (FieldValidationException ex) {
                botResponseFormatter.formatResponse(HelpdeskServerPlugin.MSG_SERVER.getMsg("ticketcreation.fieldvalidationerror", new Object[]{ex.getMessage()}));
            }
        } else {
            botResponseFormatter.formatResponse(HelpdeskServerPlugin.MSG_SERVER.getMsg("ticketcreation.nousersfoundmsg", new Object[0]));
        }
    }

    private void outputTicket(BotResponseFormatter botResponseFormatter, TicketCreationSingleState singleData, UserManager instance, GUID ownerId) {
        String ownerLabel = Tickets.FIELD_OWNER_GUID.getLabel(ClientLocale.getThreadLocale());
        String subjectLabel = Tickets.FIELD_SUBJECT.getLabel(ClientLocale.getThreadLocale());
        String ticketText = ownerLabel + ": " + instance.getUserAccount(ownerId).getDisplayName() + "\n" + subjectLabel + ": " + singleData.data.get(Tickets.FIELD_SUBJECT) + "\n" + singleData.anfrageText + "\n---";
        botResponseFormatter.formatResponse(HelpdeskServerPlugin.MSG_SERVER.getMsg("ticketcreation.finalconfirmmsg", new Object[]{ticketText}));
    }

    public boolean isFinished(BotCommandContext context) {
        String key = this.getKey(context);
        TicketCreationSingleState state = this.states.get(key);
        return state == null || state.finished;
    }

    private class TicketCreationSingleState {
        private TicketCreationStep step = TicketCreationStep.USER;
        private MutableTicketData data = new MutableTicketData();
        private String anfrageText;
        private List<SearchResultEntry<GUID>> userSearchResults;
        private boolean finished;

        private TicketCreationSingleState() {
        }
    }

    private static enum TicketCreationStep {
        USER,
        USER2,
        SUBJECT,
        ANFRAGE_TEXT,
        NECESSARY_FIELDS;

    }
}

