/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups;

import com.inet.classloader.I18nMessages;
import com.inet.classloader.translations.TranslationKey;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.shared.model.Field;
import com.inet.helpdesk.usersandgroups.HDFieldLocator;
import com.inet.http.servlet.ClientLocale;
import com.inet.lib.util.Scope;
import com.inet.usersandgroups.api.FieldDisplayNameProvider;
import java.util.Locale;

public class HDFieldDisplayNameProvider {
    public static final String PLUGIN_ID = "helpdesk";
    public static final I18nMessages MSG = new I18nMessages("com.inet.helpdesk.usersandgroups.i18n.LanguageResources", HDFieldDisplayNameProvider.class);

    public static String getStaticDisplayNameForUserField(String fieldKey) {
        return FieldDisplayNameProvider.getDisplayNameFor((I18nMessages)MSG, (String)fieldKey);
    }

    public static String getStaticDisplayNameForUserField(String fieldKey, Locale locale) {
        try (Scope s = ClientLocale.scope((Locale)locale);){
            String string = FieldDisplayNameProvider.getDisplayNameFor((I18nMessages)MSG, (String)fieldKey);
            return string;
        }
    }

    public static TranslationKey getFieldDisplayNameKey(String fieldKey) {
        return new TranslationKey(PLUGIN_ID, MSG.getBundle().getBaseBundleName(), ClientLocale.getThreadLocale().getLanguage(), "field." + fieldKey);
    }

    public static String getUserFieldDisplayDescription(String fieldKey) {
        return MSG.getMsg_(ClientLocale.getThreadLocale(), "field." + fieldKey + ".description", true, new Object[0]);
    }

    public static String getTicketFieldDisplayDescription(String fieldKey) {
        return Tickets.MSG.getMsg_(ClientLocale.getThreadLocale(), "field." + fieldKey + ".description", true, new Object[0]);
    }

    public static String getStaticTicketFieldDisplayName(String fieldKey) {
        return HDFieldDisplayNameProvider.getStaticTicketFieldDisplayName(fieldKey, ClientLocale.getThreadLocale());
    }

    public static String getStaticTicketFieldDisplayName(String fieldKey, Locale locale) {
        try (Scope s = ClientLocale.scope((Locale)locale);){
            String string = FieldDisplayNameProvider.getDisplayNameFor((I18nMessages)Tickets.MSG, (String)fieldKey);
            return string;
        }
    }

    @Deprecated
    public static String getDisplayNameForOldField(Field oldField) {
        Object field = HDFieldLocator.getFieldForOldDbField(oldField);
        if (field != null) {
            return field.getLabel();
        }
        return null;
    }
}

