/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.init;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.fieldsettings.api.AbstractFieldSettingsManager;
import com.inet.fieldsettings.api.model.GenericFieldSetting;
import com.inet.helpdesk.core.data.ConnectionCreationListener;
import com.inet.helpdesk.core.ticketfieldsettings.TicketFieldSettingsManager;
import com.inet.helpdesk.core.ticketmanager.fields.GenericFieldsManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryVO;
import com.inet.helpdesk.core.ticketmanager.fields.classification.ClassificationManager;
import com.inet.helpdesk.core.ticketmanager.fields.classification.ClassificationVO;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilManager;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilVO;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationManager;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationVO;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityManager;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityVO;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserClassManager;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserClassVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.groups.fields.ResourceFieldWorkingHours;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.MutableUserGroupData;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import java.sql.SQLException;
import java.time.DayOfWeek;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.Map;

public class DefaultValueInitializer
implements ConnectionCreationListener {
    @Override
    public void connectionCreated() {
        try {
            UserGroupManager pm;
            GUID defaultRess;
            GenericFieldsManager pm2;
            Integer defaultValue = (Integer)Tickets.FIELD_PRIORITY_ID.getDefaultValue();
            if (defaultValue != null && (pm2 = PriorityManager.getInstance()).get(defaultValue) == null) {
                pm2.add(new PriorityVO(defaultValue, "Default Priority"));
            }
            if ((defaultValue = (Integer)Tickets.FIELD_CATEGORY_ID.getDefaultValue()) != null && (pm2 = CategoryManager.getInstance()).get(defaultValue) == null) {
                ((CategoryManager)pm2).add(new CategoryVO(defaultValue, "Default Category", 0, 0, true, false, null));
            }
            if ((defaultValue = (Integer)Tickets.FIELD_ITIL_ID.getDefaultValue()) != null && (pm2 = ItilManager.getInstance()).get(defaultValue) == null) {
                pm2.add(new ItilVO(defaultValue, "Default ITIL", null, false, false, false, 0, "Created as default value", 0, null, null));
            }
            if ((defaultValue = (Integer)Tickets.FIELD_CLASSIFICATION_ID.getDefaultValue()) != null && (pm2 = ClassificationManager.getInstance()).get(defaultValue) == null) {
                pm2.add(new ClassificationVO(defaultValue, "Default classification", "Created as default value", null));
            }
            if ((defaultValue = (Integer)HDUsersAndGroups.FIELD_LOCATION_ID.getDefaultValue()) != null && (pm2 = LocationManager.getInstance()).get(defaultValue) == null) {
                pm2.add(new LocationVO(defaultValue, "Default location", "Created as default value", null, null, 0, false));
            }
            if ((defaultValue = (Integer)HDUsersAndGroups.FIELD_CLASS_ID.getDefaultValue()) != null && (pm2 = UserClassManager.getInstance()).get(defaultValue) == null) {
                pm2.add(new UserClassVO(defaultValue, "Default userclass", 0, 0, false));
            }
            if ((defaultRess = (GUID)Tickets.FIELD_RESOURCE_GUID.getDefaultValue()) != null && (pm = UserGroupManager.getInstance()).getGroup(defaultRess) == null) {
                MutableUserGroupData groupData = new MutableUserGroupData();
                ResourceFieldWorkingHours.WorkingHours workingHours = new ResourceFieldWorkingHours.WorkingHours(new HashMap<DayOfWeek, ResourceFieldWorkingHours.HourRange>(Map.of(DayOfWeek.MONDAY, new ResourceFieldWorkingHours.HourRange(LocalTime.of(0, 0), LocalTime.of(10, 0)))));
                groupData.put((UserGroupField)HDUsersAndGroups.RES_FIELD_WORKING_HOURS, (Object)workingHours);
                GUID guid = pm.createGroup("Default resource", HDUsersAndGroups.RESOURCE, groupData);
                TicketFieldSettingsManager manager = TicketFieldSettingsManager.getInstance();
                GenericFieldSetting setting = manager.getSetting(Tickets.FIELD_RESOURCE_GUID.getKey());
                Map map = setting.toMap((AbstractFieldSettingsManager)manager);
                map.put("fieldsettingsDefaultValueSelect", new Json().toJson((Object)new LocalizedKey(guid.toString(), "Default resource")));
                manager.updateSetting(Tickets.FIELD_RESOURCE_GUID.getKey(), map);
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }
}

