/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugin.adhoc;

import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.report.DatabaseTables;
import com.inet.report.Datasource;
import com.inet.report.Engine;
import com.inet.report.PropertiesChecker;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;

public class DatasourceUpdater
implements PropertiesChecker {
    private final ConnectionFactory connFactory;

    public DatasourceUpdater(ConnectionFactory connFactory) {
        this.connFactory = connFactory;
    }

    public void checkProperties(Properties arg0, Object arg1) throws ReportException {
    }

    public void checkProperties(Engine eng, Properties props, Object request) throws ReportException {
        Connection conn = null;
        try {
            DatabaseTables tables = eng.getDatabaseTables();
            int count = tables.getDatasourceCount();
            boolean hasOtherDS = false;
            Configuration config = ConfigurationManager.getInstance().getCurrent();
            for (int i = 0; i < count; ++i) {
                Datasource ds = tables.getDatasource(i);
                if ("HelpDesk".equalsIgnoreCase(ds.getDataSourceConfigurationName()) || config.getName().equalsIgnoreCase(ds.getDataSourceConfigurationName())) {
                    if (conn == null) {
                        conn = this.connFactory.getConnection();
                    }
                    ds.setConnection(conn);
                    continue;
                }
                if ("HelpDeskTickets".equalsIgnoreCase(ds.getDataSourceConfigurationName())) {
                    if (conn != null) continue;
                    conn = this.connFactory.getConnection();
                    continue;
                }
                hasOtherDS = true;
            }
            if (conn == null && hasOtherDS) {
                throw new ReportException("Only reports which contain the datasource 'HelpDesk' (or '" + config.getName() + "') can be executed. Additional data sources are allowed.", 0);
            }
        }
        catch (SQLException ex) {
            throw ReportExceptionFactory.createReportExceptionWithCause((Throwable)ex);
        }
    }
}

