/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.utils;

import java.util.List;

public class StringConcatenator {
    public static final String COMMA = ", ";
    public static final String ELLIPSIS = "...";
    public static final String COMMA_WITH_ELLIPSIS = ", ...";

    public static String concatAndShortenIfNeeded(List<String> elements, int maxLength) {
        String result;
        if (maxLength < ELLIPSIS.length()) {
            throw new IllegalArgumentException("maxLength must be greater than " + ELLIPSIS.length());
        }
        StringBuilder buf = new StringBuilder();
        for (int index = 0; index < elements.size(); ++index) {
            boolean hasNext;
            String elem = elements.get(index);
            int length = buf.length();
            int newLength = length + elem.length();
            if (index > 0) {
                newLength += COMMA.length();
            }
            if (newLength > maxLength) {
                buf.append(COMMA_WITH_ELLIPSIS);
                break;
            }
            boolean bl = hasNext = index + 1 < elements.size();
            if (hasNext && newLength + COMMA_WITH_ELLIPSIS.length() > maxLength) {
                buf.append(COMMA_WITH_ELLIPSIS);
                break;
            }
            if (index > 0) {
                buf.append(COMMA);
            }
            buf.append(elem);
        }
        return (result = buf.toString()).equals(COMMA_WITH_ELLIPSIS) ? ELLIPSIS : result;
    }
}

