/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model.tickets.additionalaccess;

import com.inet.helpdesk.core.ticketmanager.PluggableTicketSearchTag;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.additionalaccess.TicketAdditionalAccessValue;
import com.inet.id.GUID;
import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import com.inet.search.tokenizers.CollectionSearchTokenizer;
import com.inet.search.tokenizers.SearchTokenizer;
import com.inet.usersandgroups.api.Hash;
import com.inet.usersandgroups.api.ui.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;

public class AccessSearchTag
extends PluggableTicketSearchTag<Set<GUID>> {
    public static final String KEY_USERS = "additionalAccessUsers";
    public static final String KEY_GROUPS = "additionalAccessGroups";
    private Type type;

    public AccessSearchTag(String key, Type type) {
        super(AccessSearchTag.createSearchTag(key));
        this.type = type;
    }

    private static SearchTag createSearchTag(String key) {
        return new SearchTag(key, SearchDataType.StringMap, false, (SearchTokenizer)new CollectionSearchTokenizer(), 100);
    }

    @Override
    public Set<GUID> getValue(int ticketID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<GUID> getValue(TicketVO ticket) {
        TicketAdditionalAccessValue attribute = ticket.getValue(Tickets.FIELD_ADDITIONAL_ACCESS);
        if (attribute == null) {
            return Collections.emptySet();
        }
        HashSet<GUID> result = new HashSet<GUID>();
        Consumer<Hash> op = hash -> {
            if (hash.getType() == this.type) {
                result.add(hash.getId());
            }
        };
        attribute.getReadAccess().forEach(op);
        attribute.getWriteAccess().forEach(op);
        return result;
    }
}

