/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fielddefinitions;

import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.additionalaccess.TicketAdditionalAccessValue;
import com.inet.helpdesk.core.ticketmanager.ui.model.ByIDSortGroupInformation;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroup;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroupInformation;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinitionHDCore;
import java.net.URL;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TicketFieldDefinitionAdditionalAccess
extends TicketFieldDefinition
implements TicketFieldDefinitionHDCore {
    public TicketFieldDefinitionAdditionalAccess(int prio) {
        super(Tickets.FIELD_ADDITIONAL_ACCESS, true, true, prio);
    }

    @Override
    public String getDisplayValue(@Nonnull TicketVO ticket) {
        int shareCount = this.getShareCount(ticket);
        if (shareCount == 0) {
            return null;
        }
        return String.valueOf(shareCount);
    }

    @Override
    public String getValueAsStringForIcon(@Nonnull TicketVO ticket) {
        return this.getShareCount(ticket) > 0 ? String.valueOf(true) : null;
    }

    @Override
    public URL getIconForValue(String valueAsString, int size) {
        if ("true".equalsIgnoreCase(valueAsString)) {
            return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/column_ticketshare_16.png");
        }
        return null;
    }

    @Override
    public URL getColumnIcon(Integer iconSize) {
        if (iconSize <= 16) {
            return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/column_ticketshare_16.png");
        }
        if (iconSize <= 32) {
            return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/column_ticketshare_16@2x.png");
        }
        return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/column_ticketshare_16@3x.png");
    }

    @Override
    public SortGroupInformation getSortGroupInformation() {
        return new ByIDSortGroupInformation(Tickets.FIELD_ADDITIONAL_ACCESS.getKey(), sortGroupKey -> {
            String displayName = Tickets.MSG.getMsg("field.additionalticketaccess.false", new Object[0]);
            if ("true".equalsIgnoreCase((String)sortGroupKey)) {
                displayName = Tickets.MSG.getMsg("field.additionalticketaccess.true", new Object[0]);
            }
            String iconKey = sortGroupKey;
            return new SortGroup(displayName, "true".equalsIgnoreCase((String)sortGroupKey), iconKey);
        }){

            @Override
            public String getSortGroupKey(TicketVO ticket) {
                return String.valueOf(TicketFieldDefinitionAdditionalAccess.this.getShareCount(ticket) > 0);
            }
        };
    }

    private int getShareCount(@Nonnull TicketVO ticket) {
        TicketAdditionalAccessValue additionalAccess = ticket.getValue(Tickets.FIELD_ADDITIONAL_ACCESS);
        if (additionalAccess == null) {
            return 0;
        }
        return additionalAccess.getReadAccess().size() + additionalAccess.getWriteAccess().size();
    }

    @Override
    @Nonnull
    public Comparator<TicketVO> getComparator() {
        return (a, b) -> Integer.compare(this.getShareCount((TicketVO)a), this.getShareCount((TicketVO)b));
    }

    @Override
    @Nullable
    public FieldSettingsType getDisplayType() {
        return null;
    }
}

