/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config.mailtemplates.handler;

import com.inet.helpdesk.config.mailtemplates.handler.MailTemplateDescription;
import com.inet.helpdesk.core.mailtemplates.MailTemplate;
import com.inet.helpdesk.core.mailtemplates.MailTemplateData;
import com.inet.helpdesk.core.mailtemplates.MailTemplatesManager;
import com.inet.helpdesk.plugin.HelpdeskServerPlugin;
import com.inet.http.ClientMessageException;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class MailTemplatesHelper {
    public static ArrayList<MailTemplateDescription> templateStringToDescription(List<String> templateKeys, String set, String lang) {
        HashMap map = new HashMap();
        templateKeys.forEach(s -> {
            int lastIndexOf = s.lastIndexOf(".");
            if (lastIndexOf <= 0) {
                return;
            }
            String ext = s.substring(lastIndexOf + 1);
            if (!(MailTemplatesManager.ExtType.html.name().equalsIgnoreCase(ext) || MailTemplatesManager.ExtType.txt.name().equalsIgnoreCase(ext) || MailTemplatesManager.ExtType.txtgen.name().equalsIgnoreCase(ext))) {
                return;
            }
            String name = s.substring(0, lastIndexOf);
            MailTemplateDescription mailTemplateDescription = map.computeIfAbsent(name, k -> new MailTemplateDescription(name));
            MailTemplate defaultTemplate = null;
            try {
                defaultTemplate = (MailTemplate)ServerPluginManager.getInstance().getSingleInstanceByName(MailTemplate.class, name, false);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (defaultTemplate != null) {
                mailTemplateDescription.setSubTemplate(defaultTemplate.isSubTemplate());
                mailTemplateDescription.setDescription(defaultTemplate.getDescription());
            } else {
                mailTemplateDescription.setCustom(true);
            }
            if (MailTemplatesManager.ExtType.txt.name().equalsIgnoreCase(ext) || MailTemplatesManager.ExtType.txtgen.name().equalsIgnoreCase(ext)) {
                mailTemplateDescription.setPlaintext(true);
            }
            if (MailTemplatesManager.ExtType.html.name().equalsIgnoreCase(ext)) {
                mailTemplateDescription.setHtml(true);
            }
            mailTemplateDescription.setSet(set);
            mailTemplateDescription.setLang(lang);
        });
        ArrayList<MailTemplateDescription> descriptions = new ArrayList<MailTemplateDescription>(map.values());
        descriptions.sort((a, b) -> {
            if (a.isCustom() != b.isCustom()) {
                return a.isCustom() ? -1 : 1;
            }
            return Comparator.comparing(MailTemplateDescription::getDescription, Comparator.nullsFirst(String.CASE_INSENSITIVE_ORDER)).thenComparing(MailTemplateDescription::getName, Comparator.nullsFirst(String.CASE_INSENSITIVE_ORDER)).compare((MailTemplateDescription)a, (MailTemplateDescription)b);
        });
        return descriptions;
    }

    public static void filterTemplateDescriptions(String searchTerm, ArrayList<MailTemplateDescription> templates) {
        if (StringFunctions.isEmpty((String)searchTerm)) {
            return;
        }
        searchTerm = searchTerm.toLowerCase();
        Iterator<MailTemplateDescription> iterator = templates.iterator();
        while (iterator.hasNext()) {
            MailTemplateData templateData;
            MailTemplateDescription template = iterator.next();
            boolean matches = template.getName().toLowerCase().contains(searchTerm);
            if (!matches && !StringFunctions.isEmpty((String)template.getDescription())) {
                matches = template.getDescription().toLowerCase().contains(searchTerm);
            }
            if (!matches && (templateData = MailTemplatesManager.getTemplate(template.getName(), template.getSet(), template.getLang())) != null) {
                String htmlData;
                String textData = templateData.getTextData();
                if (textData != null) {
                    matches = textData.toLowerCase().contains(searchTerm);
                }
                if (!matches && (htmlData = templateData.getHtmlData()) != null) {
                    String plainText = MailTemplatesManager.convertToPlainText(htmlData);
                    matches = plainText.toLowerCase().contains(searchTerm);
                }
            }
            if (matches) continue;
            iterator.remove();
        }
    }

    public static void checkInvalidName(String name) {
        int length = name.length();
        block3: for (int i = 0; i < length; ++i) {
            char ch = name.charAt(i);
            switch (ch) {
                case ' ': 
                case '(': 
                case ')': 
                case ',': 
                case '-': 
                case '_': {
                    continue block3;
                }
                default: {
                    if (Character.isLetterOrDigit(ch)) continue block3;
                    throw new ClientMessageException(HelpdeskServerPlugin.MSG_CONFIG.getMsg("configpage.configuration.mailtemplates.illegalchar", new Object[]{Character.valueOf(ch)}));
                }
            }
        }
    }

    public static String[] splitText(String text) {
        if (text == null || text.indexOf("\n") == -1) {
            return new String[]{text};
        }
        StringBuffer buf = new StringBuffer(text);
        String[] result = new String[2];
        for (int i = 0; i < buf.length(); ++i) {
            if (buf.charAt(i) != '\n') continue;
            result[0] = buf.substring(0, i).replace('\r', ' ').trim();
            result[1] = buf.substring(i + 1).trim();
            break;
        }
        return result;
    }
}

