/*
 * Decompiled with CFR 0.152.
 */
package srv.automatic.deviceimport;

import com.inet.helpdesk.config.DatabaseConfigInfo;
import com.inet.helpdesk.config.DeviceImportConfigInfo;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.DataImportJob;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.model.MutableAssetData;
import com.inet.id.GUID;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.SuppressFBWarnings;
import srv.automatic.GeraeteImporter;
import srv.automatic.UserImporter;
import srv.automatic.deviceimport.AbstractDeviceImporter;
import srv.automatic.deviceimport.DeviceImportingException;
import srv.automatic.deviceimport.MappingHandler;

public class DbDeviceImporter
extends AbstractDeviceImporter {
    private Connection fremdC = null;

    public DbDeviceImporter(DatabaseConfigInfo dbConn) throws SQLException {
        this.fremdC = UserImporter.getConnection(dbConn);
    }

    @Override
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="Argument strings are quoted")
    public HashMap<String, Integer> replaceOwnKey(HashMap<String, Integer> userHm, String table, String keySpalte, String userIdSpalte, String filter) throws DeviceImportingException {
        Statement st = null;
        ResultSet rs = null;
        try {
            if (table.startsWith("Procedure: ")) {
                String procedureName = table.substring("Procedure: ".length());
                CallableStatement stm = this.fremdC.prepareCall("{call " + procedureName + "}");
                st = stm;
                rs = stm.executeQuery();
            } else {
                st = this.fremdC.createStatement();
                String qS = this.fremdC.getMetaData().getIdentifierQuoteString();
                String statement = "Select " + qS + keySpalte + qS + ", " + qS + userIdSpalte + qS + " From " + qS + table + qS;
                this.logger.debug((Object)("STATEMENT: " + statement));
                rs = st.executeQuery(statement);
            }
            HashMap<String, Integer> newHm = new HashMap<String, Integer>();
            while (rs.next()) {
                String key = rs.getString(keySpalte);
                String userName = rs.getString(userIdSpalte);
                this.logger.debug((Object)("KEY: " + key + " USERNAME: " + userName));
                if (key == null || userName == null || userName.trim().isEmpty()) continue;
                key = key.trim();
                Integer userid = userHm.get(GeraeteImporter.normalizeName(userName));
                if (userid == null) continue;
                this.putKontrolle(newHm, key, userid);
            }
            HashMap<String, Integer> hashMap = newHm;
            return hashMap;
        }
        catch (SQLException exc) {
            this.logger.error((Throwable)exc);
            throw new DeviceImportingException(exc);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable throwable) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    @Override
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="input strings are quoted")
    public List<Map<String, String>> doImport(DataImportJob dataImportJob, HashMap<String, Integer> userHm, DeviceImportConfigInfo importConfig, String name, String filter, int newVersID, int gerTyp, MappingHandler mappingHandler, String nameRef, boolean indirekt, AbstractDeviceImporter.RowAddedListener rowAddedListener) throws Exception {
        Statement st = null;
        ResultSet rs = null;
        try {
            boolean isPreviewMode;
            String qS = this.fremdC.getMetaData().getIdentifierQuoteString();
            String importTabelle = importConfig.getImportSource();
            String identString = importConfig.getUniqueIdent() == null ? "" : importConfig.getUniqueIdent().trim();
            boolean uniqueIdentAvailable = identString.length() > 0;
            ArrayList<String> additionalNames = new ArrayList<String>();
            if (!importConfig.isIgnoreUser()) {
                additionalNames.add(nameRef);
            }
            if (uniqueIdentAvailable) {
                additionalNames.add(identString);
            }
            ArrayList<MappingHandler.MappedColumn> requiredDataColumns = mappingHandler.getListOfColumnsToSelect(new String[0]);
            List<String> selectionColumns = DbDeviceImporter.getSelectionColumns(mappingHandler, additionalNames.toArray(new String[additionalNames.size()]));
            if (importTabelle != null && importTabelle.startsWith("Procedure: ")) {
                String procedureName = importTabelle.substring("Procedure: ".length());
                CallableStatement stm = this.fremdC.prepareCall("{call " + procedureName + "}");
                st = stm;
                rs = stm.executeQuery();
            } else {
                st = this.fremdC.createStatement();
                String selectString = DbDeviceImporter.createSelectString(filter, importTabelle, qS, selectionColumns);
                this.logger.debug((Object)("SELECTSTRING: " + selectString));
                rs = st.executeQuery(selectString);
            }
            ArrayList<SourceData> data = new ArrayList<SourceData>();
            HashMap<String, String> buffer = new HashMap<String, String>();
            boolean bl = isPreviewMode = rowAddedListener != null;
            while (rs.next()) {
                Map<String, String> rowData = this.getRowData(rs, requiredDataColumns, selectionColumns, buffer);
                ++this.available;
                if (rowData.values().stream().allMatch(v -> v == null || v.isEmpty())) {
                    if (!isPreviewMode) {
                        this.logger.error((Object)("import '" + name + "': row contains only null values"));
                    }
                    dataImportJob.incrementErrorsCount();
                    --this.available;
                    continue;
                }
                dataImportJob.incrementDataCount();
                SourceData sd = new SourceData();
                sd.deviceData = rowData;
                String uname = buffer.get(nameRef);
                if (!importConfig.isIgnoreUser() && (uname == null || uname.trim().isEmpty())) {
                    if (!isPreviewMode) {
                        this.logger.error((Object)("import '" + name + "': row has empty user name"));
                    }
                    dataImportJob.incrementMissingReferenceCount();
                    --this.available;
                    continue;
                }
                sd.userid = userHm.get(GeraeteImporter.normalizeName(uname));
                if (uniqueIdentAvailable) {
                    sd.uniqueKey = buffer.get(identString);
                }
                if (this.checkDbData(dataImportJob, this.available, rowData, sd, indirekt, importConfig.isIgnoreUser(), name, isPreviewMode)) {
                    data.add(sd);
                }
                if (isPreviewMode) {
                    if (!rowAddedListener.finishedWithRowCount(data.size())) continue;
                    break;
                }
                if (data.size() != 50) continue;
                this.executeDoImport(dataImportJob, name, data, importConfig.getGerTyp(), uniqueIdentAvailable, newVersID, importConfig.isIgnoreUser());
                data.clear();
            }
            if (isPreviewMode) {
                ArrayList<Map<String, String>> exampleBuffer = new ArrayList<Map<String, String>>();
                for (SourceData sd : data) {
                    exampleBuffer.add(sd.deviceData);
                }
                List<Map<String, String>> list = this.createEntrys(exampleBuffer, requiredDataColumns);
                return list;
            }
            this.executeDoImport(dataImportJob, name, data, importConfig.getGerTyp(), uniqueIdentAvailable, newVersID, importConfig.isIgnoreUser());
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
            throw e;
        }
        finally {
            try {
                rs.close();
            }
            catch (Throwable throwable) {}
            try {
                st.close();
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="internally created statement")
    private void executeDoImport(DataImportJob dataImportJob, String name, ArrayList<SourceData> data, int gerType, boolean vergleichen, int newVersID, boolean ignoreUserAndLocation) throws Exception {
        if (data.isEmpty()) {
            return;
        }
        if (vergleichen) {
            try (UserAccountScope scope = UserAccountScope.createPrivileged();){
                AssetManager manager = AssetManager.getInstance();
                IndexSearchEngine searchEngine = manager.getSearchEngine();
                for (SourceData entry : data) {
                    Map<String, String> deviceData = entry.deviceData;
                    AndSearchExpression and = new AndSearchExpression();
                    and.add((SearchExpression)new SearchCondition(AssetFields.FIELD_IMPORT_NAME.getKey(), SearchCondition.SearchTermOperator.Equals, (Object)name));
                    and.add((SearchExpression)new SearchCondition(AssetFields.FIELD_IMPORTED_FROM_COLUMN.getKey(), SearchCondition.SearchTermOperator.Equals, (Object)entry.uniqueKey));
                    SearchCommand command = new SearchCommand(new SearchExpression[]{and});
                    Set results = searchEngine.simpleSearch(command);
                    Integer userid = entry.userid;
                    if (userid == null && !ignoreUserAndLocation) {
                        HDLogger.error("import '" + name + "': userid null for entry with unique id: " + entry.uniqueKey);
                        dataImportJob.incrementErrorsCount();
                        continue;
                    }
                    String locationString = deviceData.get(AssetFields.FIELD_LOCATION.getKey());
                    if (results.isEmpty()) {
                        try {
                            MutableAssetData dataToSet = this.createAssetDataFromData(name, gerType, deviceData, entry.uniqueKey, userid, newVersID);
                            if (dataToSet.getIncludedFields().size() > 1) {
                                manager.createAsset(dataToSet, Collections.emptyList(), true);
                            }
                            dataImportJob.incrementAddedCount();
                            ++this.newImports;
                        }
                        catch (Exception exc) {
                            HDLogger.error(exc);
                            dataImportJob.incrementErrorsCount();
                        }
                        continue;
                    }
                    if (results.size() == 1) {
                        GUID g = (GUID)results.stream().findFirst().get();
                        try {
                            MutableAssetData dataToSet = this.createAssetDataFromData(name, gerType, deviceData, entry.uniqueKey, userid, newVersID);
                            if (manager.getAsset(g).isArchived()) {
                                manager.unarchiveAsset(g);
                            }
                            manager.updateAsset(g, dataToSet, Collections.emptyList(), true);
                            dataImportJob.incrementUpdatedCount();
                            ++this.updates;
                        }
                        catch (Exception exc) {
                            HDLogger.error(exc);
                            dataImportJob.incrementErrorsCount();
                        }
                        continue;
                    }
                    HDLogger.error("more than one device found for unique id: " + entry.uniqueKey);
                }
            }
        }
    }

    private Map<String, String> getRowData(ResultSet rs, ArrayList<MappingHandler.MappedColumn> requiredDataColumns, List<String> selectionColumns, HashMap<String, String> buffer) throws SQLException {
        HashMap<String, String> rowData = new HashMap<String, String>();
        for (String column : selectionColumns) {
            String value;
            int index = rs.findColumn(column);
            Object obj = rs.getObject(index);
            if (obj instanceof Date) {
                Date date = (Date)obj;
                value = String.valueOf(date.getTime());
            } else {
                value = obj == null ? "" : obj.toString().trim();
            }
            buffer.put(column, value);
            for (MappingHandler.MappedColumn requiredDataColumn : requiredDataColumns) {
                String sourceColumnName = requiredDataColumn.getSourceColumnName();
                if (sourceColumnName == null || !sourceColumnName.equals(column)) continue;
                String assetKeyName = requiredDataColumn.getInternalColumnName();
                if (value != null && value.length() > requiredDataColumn.getMaxValueLength()) {
                    value = value.substring(0, requiredDataColumn.getMaxValueLength());
                }
                rowData.put(assetKeyName, value);
            }
        }
        return rowData;
    }

    private static List<String> getSelectionColumns(MappingHandler mappingHandler, String[] addNames) {
        ArrayList<MappingHandler.MappedColumn> toSelect = mappingHandler.getListOfColumnsToSelect(addNames);
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < toSelect.size(); ++i) {
            String colName = ((MappingHandler.MappedColumn)toSelect.get(i)).getSourceColumnName();
            if (colName == null || names.contains(colName) || "".equals(colName)) continue;
            names.add(colName);
        }
        return names;
    }

    private static String createSelectString(String filter, String importTabelle, String qS, List<String> toSelect) {
        String selectString = "Select " + qS + toSelect.get(0) + qS;
        for (int i = 1; i < toSelect.size(); ++i) {
            selectString = selectString + ", " + qS + toSelect.get(i) + qS;
        }
        selectString = selectString + " From " + qS + importTabelle + qS;
        if (filter.length() > 0) {
            selectString = selectString + " Where " + filter;
        }
        return selectString;
    }

    @Override
    public void cleanup() {
        try {
            this.fremdC.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.fremdC = null;
    }

    private boolean checkDbData(DataImportJob dataImportJob, int debugCounter, Map<String, String> rowData, SourceData sd, boolean uniqueTest, boolean ignoreUser, String importName, boolean isPreviewMode) {
        Integer userid = sd.userid;
        if (userid == null && !ignoreUser) {
            if (!isPreviewMode) {
                this.logger.error((Object)("import '" + importName + "': Row " + debugCounter + " no Userid!"));
            }
            dataImportJob.incrementMissingReferenceCount();
            return false;
        }
        if (uniqueTest && (sd.uniqueKey == null || sd.uniqueKey.isEmpty())) {
            if (!isPreviewMode) {
                this.logger.warn((Object)("import '" + importName + "': Row " + debugCounter + " no reference: " + sd.uniqueKey));
            }
            dataImportJob.incrementDuplicatesCount();
            return false;
        }
        String name = rowData.get(AssetFields.FIELD_NAME.getKey());
        if (name == null || name.isEmpty()) {
            if (!isPreviewMode) {
                this.logger.error((Object)("import '" + importName + "': Row " + debugCounter + " no Name"));
            }
            dataImportJob.incrementErrorsCount();
            return false;
        }
        return true;
    }

    private class SourceData {
        private Integer userid;
        private String uniqueKey;
        private Map<String, String> deviceData;

        private SourceData() {
        }
    }
}

