/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.groups.fields;

import com.inet.annotations.JsonData;
import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.helpdesk.usersandgroups.HDFieldDisplayNameProvider;
import com.inet.usersandgroups.api.BasicFieldValidation;
import com.inet.usersandgroups.api.UserGroupField;
import java.time.DayOfWeek;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ResourceFieldWorkingHours
extends UserGroupField<WorkingHours> {
    public static final String KEY = "resourceworkinghours";
    public static final WorkingHours DEFAULT_WORKING_HOURS = ResourceFieldWorkingHours.createDefaultWorkingHours();

    public ResourceFieldWorkingHours() {
        super(KEY, (Object)WorkingHours.createEmpty(), FieldTypeFactory.auto().withoutSearchTag());
    }

    private static WorkingHours createDefaultWorkingHours() {
        HourRange range = new HourRange(LocalTime.of(8, 0), LocalTime.of(17, 0));
        HashMap<DayOfWeek, HourRange> map = new HashMap<DayOfWeek, HourRange>();
        map.put(DayOfWeek.MONDAY, range);
        map.put(DayOfWeek.TUESDAY, range);
        map.put(DayOfWeek.WEDNESDAY, range);
        map.put(DayOfWeek.THURSDAY, range);
        map.put(DayOfWeek.FRIDAY, range);
        return new WorkingHours(map);
    }

    public void validate(WorkingHours value) {
        super.validate((Object)value);
        BasicFieldValidation.throwIfNull((Object)value);
        Map<DayOfWeek, HourRange> hourRanges = value.getHourRanges();
        Collection<HourRange> values = hourRanges.values();
        for (HourRange hourRange : values) {
            if (hourRange == null || hourRange.getStart() == null && hourRange.getEnd() == null) continue;
            if (!(hourRange.getStart() != null && hourRange.getEnd() != null || hourRange.getStart() == null && hourRange.getEnd() == null)) {
                throw new IllegalArgumentException(HDFieldDisplayNameProvider.MSG.getMsg("usersandgroupsmanager.fieldPanelDefinition.group.resource.workinghours.error.twovalues", new Object[0]));
            }
            if (!hourRange.getStart().isAfter(hourRange.getEnd())) continue;
            throw new IllegalArgumentException(HDFieldDisplayNameProvider.MSG.getMsg("usersandgroupsmanager.fieldPanelDefinition.group.resource.workinghours.error.endbeforestart", new Object[0]));
        }
    }

    public WorkingHours copyValue(WorkingHours workingHours) {
        return new WorkingHours(workingHours.getHourRanges());
    }

    @JsonData
    public static class WorkingHours {
        private Map<DayOfWeek, HourRange> hourRanges;

        private WorkingHours() {
            this.hourRanges = Collections.emptyMap();
        }

        public WorkingHours(Map<DayOfWeek, HourRange> hourRanges) {
            if (hourRanges == null) {
                throw new IllegalArgumentException("map must not be null");
            }
            if (hourRanges.containsKey(null)) {
                throw new IllegalArgumentException("map must not contain null as key");
            }
            if (hourRanges.containsValue(null)) {
                throw new IllegalArgumentException("map must not contain null as value");
            }
            this.hourRanges = Collections.unmodifiableMap(new HashMap<DayOfWeek, HourRange>(hourRanges));
        }

        public static WorkingHours createEmpty() {
            return new WorkingHours(Collections.emptyMap());
        }

        public HourRange getHourRange(DayOfWeek day) {
            return this.hourRanges.get(day);
        }

        public Map<DayOfWeek, HourRange> getHourRanges() {
            return this.hourRanges;
        }

        public boolean areLessThanOneHourPerWeek() {
            int totalWorkingSeconds = 0;
            for (HourRange hourRange : this.hourRanges.values()) {
                totalWorkingSeconds = (int)((long)totalWorkingSeconds + ChronoUnit.SECONDS.between(hourRange.getStart(), hourRange.getEnd()));
            }
            return (long)totalWorkingSeconds < TimeUnit.HOURS.toSeconds(1L);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.hourRanges == null ? 0 : this.hourRanges.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WorkingHours other = (WorkingHours)obj;
            return !(this.hourRanges == null ? other.hourRanges != null : !this.hourRanges.equals(other.hourRanges));
        }
    }

    @JsonData
    public static class HourRange {
        private Date start;
        private Date end;

        public HourRange(LocalTime start, LocalTime end) {
            this.start = new Date(1970, 1, 1, start.getHour(), start.getMinute(), start.getSecond());
            this.end = new Date(1970, 1, 1, end.getHour(), end.getMinute(), end.getSecond());
        }

        public HourRange() {
        }

        public LocalTime getStart() {
            if (this.start == null) {
                return null;
            }
            return LocalTime.of(this.start.getHours(), this.start.getMinutes(), this.start.getSeconds());
        }

        public LocalTime getEnd() {
            if (this.end == null) {
                return null;
            }
            return LocalTime.of(this.end.getHours(), this.end.getMinutes(), this.end.getSeconds());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.end.getHours();
            result = 31 * result + this.end.getMinutes();
            result = 31 * result + this.end.getSeconds();
            result = 31 * result + this.start.getHours();
            result = 31 * result + this.start.getMinutes();
            result = 31 * result + this.start.getSeconds();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HourRange other = (HourRange)obj;
            if (!other.getEnd().equals(this.getEnd())) {
                return false;
            }
            return other.getStart().equals(this.getStart());
        }
    }
}

