/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.groups;

import com.inet.error.PersistenceException;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionCreationListener;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.usersandgroups.HDFieldDisplayNameProvider;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.groups.HelpDeskUserGroupSearchDataCache;
import com.inet.helpdesk.usersandgroups.groups.IHelpDeskUserGroupManager;
import com.inet.helpdesk.usersandgroups.groups.fields.ResourceFieldWorkingHours;
import com.inet.helpdesk.usersandgroups.groups.model.HelpDeskWrappedUserGroupInfo;
import com.inet.helpdesk.usersandgroups.groups.persistence.HelpDeskUserGroupPersistence;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.SearchResult;
import com.inet.search.SearchTag;
import com.inet.search.command.SearchExpression;
import com.inet.search.command.SearchID;
import com.inet.search.command.TokenMatcher;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.FieldValidationException;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.BaseUserGroupManager;
import com.inet.usersandgroups.api.groups.GroupType;
import com.inet.usersandgroups.api.groups.GroupTypeDef;
import com.inet.usersandgroups.api.groups.MembershipType;
import com.inet.usersandgroups.api.groups.MutableUserGroupData;
import com.inet.usersandgroups.api.groups.PredefinedUserGroup;
import com.inet.usersandgroups.api.groups.UserGroupEventListener;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.groups.search.UserGroupSearchDataCache;
import com.inet.usersandgroups.api.groups.search.UserGroupSearchEngine;
import com.inet.usersandgroups.api.user.AuthGroupMembersProvider;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import srv.HdLicenseObserver;

public class HelpDeskUserGroupManager
extends UserGroupManager
implements ConnectionCreationListener,
IHelpDeskUserGroupManager {
    private final UserGroupSearchEngine searchEngine;
    private final AuthGroupMembersProvider authGroupMembersProvider;
    private BaseUserGroupManager manager;
    private HelpDeskUserGroupPersistence persistence;
    private boolean connectionEstablished = false;

    public HelpDeskUserGroupManager(UserGroupSearchEngine searchEngine, AuthGroupMembersProvider authGroupMembersProvider) {
        if (searchEngine == null) {
            throw new IllegalArgumentException("search engine must not be null");
        }
        if (authGroupMembersProvider == null) {
            throw new IllegalArgumentException("provider of auth group members must not be null");
        }
        this.searchEngine = searchEngine;
        this.authGroupMembersProvider = authGroupMembersProvider;
    }

    public void init(List<GroupTypeDef> groupTypes, List<UserGroupField<Object>> groupFields, List<PredefinedUserGroup> predefinedGroups) throws IOException {
        if (this.manager != null) {
            throw new IllegalStateException("manager is already initialized");
        }
        this.persistence = new HelpDeskUserGroupPersistence();
        if (this.connectionEstablished) {
            this.persistence.connectionCreated((ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class));
        }
        this.manager = new BaseUserGroupManager(this.persistence, this.searchEngine, this.authGroupMembersProvider){

            protected UserGroupSearchDataCache createSearchDataCache(Map<GUID, UserGroupInfo> groupInfoCache, List<UserGroupField<Object>> userGroupFields) {
                return new HelpDeskUserGroupSearchDataCache(groupInfoCache, userGroupFields);
            }
        };
        this.manager.init(groupTypes, groupFields, predefinedGroups);
    }

    @Override
    public void connectionCreated() {
        this.connectionEstablished = true;
        if (this.persistence != null) {
            this.persistence.connectionCreated((ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class));
        }
    }

    public GUID createGroup(String groupName, GroupType groupType, MutableUserGroupData groupData) {
        return this.createGroup(null, groupName, groupType, groupData);
    }

    public GUID createGroup(@Nullable GUID parentID, String groupName, GroupType groupType, MutableUserGroupData groupData) {
        boolean isResource = HDUsersAndGroups.RESOURCE.equals((Object)groupType);
        if (isResource && groupData != null) {
            boolean isSubRes;
            this.throwIfWeeklyWorkingHoursAreNullOrLessThanOneHour((ResourceFieldWorkingHours.WorkingHours)groupData.get((UserGroupField)HDUsersAndGroups.RES_FIELD_WORKING_HOURS));
            if (groupData.containsField((UserGroupField)HDUsersAndGroups.RES_FIELD_ID)) {
                String format = "Resource group with name \"%s\" and type \"%s\" could not be created because field \"%s\" is already defined";
                String msg = String.format(format, groupName, groupType.getName(), HDUsersAndGroups.RES_FIELD_ID.getKey());
                throw new IllegalArgumentException(msg);
            }
            Integer parentResID = (Integer)groupData.get((UserGroupField)HDUsersAndGroups.RES_FIELD_PARENT_ID);
            boolean bl = isSubRes = parentResID != null && !parentResID.equals(HDUsersAndGroups.RES_FIELD_PARENT_ID.getDefaultValue());
            if (parentID != null && !isSubRes) {
                parentResID = this.persistence.findResourceByGroupIdOrThrow(parentID);
                groupData = groupData.copy();
                groupData.put((UserGroupField)HDUsersAndGroups.RES_FIELD_PARENT_ID, (Object)parentResID);
            }
        }
        GUID groupID = this.manager.createGroup(parentID, groupName, groupType, groupData);
        HdLicenseObserver.resetLicenseCount();
        return groupID;
    }

    private void throwIfWeeklyWorkingHoursAreNullOrLessThanOneHour(ResourceFieldWorkingHours.WorkingHours workingHours) {
        if (workingHours == null) {
            throw new FieldValidationException(HDFieldDisplayNameProvider.MSG.getMsg("usersandgroupsmanager.fieldPanelDefinition.group.resource.workinghours.emptyHint", new Object[0]));
        }
        if (workingHours.areLessThanOneHourPerWeek()) {
            throw new FieldValidationException(HDFieldDisplayNameProvider.MSG.getMsg("usersandgroupsmanager.fieldPanelDefinition.group.resource.workinghours.error.lessthanonehour", new Object[0]));
        }
    }

    @Override
    public GUID createGroupForExistingResource(int resID, boolean deactivated, @Nullable GUID parentGroupID) {
        String groupName = "resource";
        MutableUserGroupData groupData = new MutableUserGroupData();
        groupData.put((UserGroupField)HDUsersAndGroups.RES_FIELD_ID, (Object)resID);
        GUID groupID = this.manager.createGroup(parentGroupID, groupName, HDUsersAndGroups.RESOURCE, groupData);
        if (deactivated) {
            this.manager.deactivateGroup(groupID, false);
        }
        HdLicenseObserver.resetLicenseCount();
        return groupID;
    }

    public void setParentGroup(GUID groupID, GUID parentID) {
        this.manager.setParentGroup(groupID, parentID);
    }

    public void deleteGroup(GUID groupID) {
        UserGroupInfo group = this.getGroup(groupID);
        if (group != null && HDUsersAndGroups.RESOURCE.equals((Object)group.getType())) {
            throw new IllegalArgumentException("Groups representing resources can not be deleted. GroupID = \"" + groupID.toString() + "\".");
        }
        this.manager.deleteGroup(groupID);
        HdLicenseObserver.resetLicenseCount();
    }

    public void deactivateGroup(GUID groupID, boolean removeMembershipData) {
        this.manager.deactivateGroup(groupID, removeMembershipData);
        HdLicenseObserver.resetLicenseCount();
    }

    public void renameGroup(GUID groupID, String newGroupName) {
        this.manager.renameGroup(groupID, newGroupName);
    }

    public void addUserToGroup(GUID userAccountID, GUID groupID, MembershipType ... membershipTypes) {
        this.manager.addUserToGroup(userAccountID, groupID, membershipTypes);
        HdLicenseObserver.resetLicenseCount();
    }

    public void removeUserFromGroup(GUID userAccountID, GUID groupID, MembershipType ... membershipTypes) {
        this.manager.removeUserFromGroup(userAccountID, groupID, membershipTypes);
        HdLicenseObserver.resetLicenseCount();
    }

    public void updateGroupData(GUID groupID, MutableUserGroupData groupData) {
        if (groupData != null && groupData.containsField((UserGroupField)HDUsersAndGroups.RES_FIELD_WORKING_HOURS)) {
            ResourceFieldWorkingHours.WorkingHours workingHours = (ResourceFieldWorkingHours.WorkingHours)groupData.get((UserGroupField)HDUsersAndGroups.RES_FIELD_WORKING_HOURS);
            this.throwIfWeeklyWorkingHoursAreNullOrLessThanOneHour(workingHours);
        }
        this.manager.updateGroupData(groupID, groupData);
    }

    public void updateGroupMembers(GUID groupID, Map<GUID, Set<MembershipType>> membersToAdd, Map<GUID, Set<MembershipType>> membersToRemove) {
        this.manager.updateGroupMembers(groupID, membersToAdd, membersToRemove);
        HdLicenseObserver.resetLicenseCount();
    }

    public void updateUserGroupMembership(GUID userAccountID, Map<GUID, Set<MembershipType>> groupsToAddUserTo, Map<GUID, Set<MembershipType>> groupsToRemoveUserFrom) {
        this.manager.updateUserGroupMembership(userAccountID, groupsToAddUserTo, groupsToRemoveUserFrom);
        HdLicenseObserver.resetLicenseCount();
    }

    public void updateGroupPermissions(GUID groupID, Set<Permission> permissionsToAdd, Set<Permission> permissionsToRemove) {
        this.manager.updateGroupPermissions(groupID, permissionsToAdd, permissionsToRemove);
        HdLicenseObserver.resetLicenseCount();
    }

    public void removeUserFromAllGroups(GUID userAccountID) {
        this.manager.removeUserFromAllGroups(userAccountID);
        HdLicenseObserver.resetLicenseCount();
    }

    public Map<String, String> getAllGroupDisplayNames() {
        return this.manager.getAllGroupDisplayNames();
    }

    public Set<UserGroupInfo> getAllGroups() {
        return this.wrapAllIfRequired(this.manager.getAllGroups());
    }

    public Set<UserGroupInfo> getAllGroupsIncludingDeactivated() {
        return this.wrapAllIfRequired(this.manager.getAllGroupsIncludingDeactivated());
    }

    public Set<UserGroupInfo> getGroups(GroupType groupType) {
        return this.wrapAllIfRequired(this.manager.getGroups(groupType));
    }

    public Set<UserGroupInfo> getGroupsIncludingDeactivated(GroupType groupType) {
        return this.wrapAllIfRequired(this.manager.getGroupsIncludingDeactivated(groupType));
    }

    public Set<UserGroupInfo> getGroupsForUser(GUID userAccountID, boolean includeDeactivated, boolean includeInheritedMembership) {
        Set groups = this.manager.getGroupsForUser(userAccountID, includeDeactivated, includeInheritedMembership);
        if (HDUsersAndGroups.isSupporter(userAccountID, groups)) {
            groups.add(this.getGroup(HDUsersAndGroups.GROUPID_SUPPORTERS));
        } else if (this.manager.getGroup(HDUsersAndGroups.GROUPID_ENDUSER) == null) {
            HDLogger.warn("Group 'enduser' does not exist");
        } else {
            UserAccount userAccount = UserManager.getInstance().getUserAccount(userAccountID);
            if (userAccount != null && userAccount.getAccountType() != UserAccountType.Temp) {
                groups.add(this.getGroup(HDUsersAndGroups.GROUPID_ENDUSER));
            }
        }
        return groups;
    }

    public UserGroupInfo getGroup(GUID groupID) {
        return this.wrapUserGroupIfRequired(this.manager.getGroup(groupID));
    }

    private Set<UserGroupInfo> wrapAllIfRequired(Set<UserGroupInfo> groups) {
        Optional<UserGroupInfo> enduser;
        Optional<UserGroupInfo> supporter = groups.stream().filter(ugroup -> ugroup.getID().equals((Object)HDUsersAndGroups.GROUPID_SUPPORTERS)).findAny();
        if (supporter.isPresent()) {
            groups.remove(supporter.get());
            groups.add(this.wrapUserGroupIfRequired(supporter.get()));
        }
        if ((enduser = groups.stream().filter(ugroup -> ugroup.getID().equals((Object)HDUsersAndGroups.GROUPID_ENDUSER)).findAny()).isPresent()) {
            groups.remove(enduser.get());
            groups.add(this.wrapUserGroupIfRequired(enduser.get()));
        }
        return groups;
    }

    private UserGroupInfo wrapUserGroupIfRequired(UserGroupInfo group) {
        if (group == null) {
            return null;
        }
        if (group.getID().equals((Object)HDUsersAndGroups.GROUPID_SUPPORTERS)) {
            return HelpDeskWrappedUserGroupInfo.createForSupporterGroup(group);
        }
        if (group.getID().equals((Object)HDUsersAndGroups.GROUPID_ENDUSER)) {
            return HelpDeskWrappedUserGroupInfo.createForEnduserGroup(group);
        }
        return group;
    }

    public UserGroupInfo getGroup(String groupName, GroupType groupType) {
        return this.wrapUserGroupIfRequired(this.manager.getGroup(groupName, groupType));
    }

    public void registerListener(UserGroupEventListener listener) {
        this.manager.registerListener(listener);
    }

    public void unregisterListener(UserGroupEventListener listener) {
        this.manager.unregisterListener(listener);
    }

    public List<UserGroupField<?>> getAllFields() {
        return this.manager.getAllFields();
    }

    public UserGroupField<Object> getField(String fieldKey) {
        return this.manager.getField(fieldKey);
    }

    public SearchResult<GUID> search(String phrase, List<SearchExpression> additionalExpressions, List<SearchExpression> boostingExpressions, int maxResults, SearchID searchID) {
        return this.manager.search(phrase, additionalExpressions, boostingExpressions, maxResults, searchID);
    }

    public SearchResult<GUID> search(String phrase, List<SearchExpression> additionalExpressions, List<SearchExpression> boostingExpressions, int maxResults, SearchID searchID, @Nonnull Set<SearchTag> searchTags, @Nullable List<TokenMatcher<GUID>> tokenMatcher) {
        return this.manager.search(phrase, additionalExpressions, boostingExpressions, maxResults, searchID, searchTags, tokenMatcher);
    }

    public IndexSearchEngine<GUID> getSearchEngine() {
        return this.manager.getSearchEngine();
    }

    @Override
    public UserGroupInfo getUserGroupInfoForResourceId(int resourceId) {
        Set<UserGroupInfo> resourceGroups = this.getGroupsIncludingDeactivated(HDUsersAndGroups.RESOURCE);
        for (UserGroupInfo userGroupInfo : resourceGroups) {
            Integer groupResourceId = (Integer)userGroupInfo.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_ID);
            if (groupResourceId == null || groupResourceId != resourceId) continue;
            return userGroupInfo;
        }
        return null;
    }

    @Override
    public void deactivateResourceAndMoveTickets(GUID resGroupToDeactivateID, GUID ticketTargetResGroupID) {
        Function<GUID, UserGroupInfo> getResGroupOrThrow = groupID -> {
            UserGroupInfo group = this.getGroup((GUID)groupID);
            if (group == null) {
                throw new IllegalArgumentException(UsersAndGroups.MSG.getMsg("error.groupDoesNotExist", new Object[]{groupID}));
            }
            if (!HDUsersAndGroups.RESOURCE.equals((Object)group.getType())) {
                throw new IllegalArgumentException(String.format("Group with ID \"%s\" is not of a type resource.", groupID));
            }
            return group;
        };
        UserAccount responsibleUser = UserManager.getInstance().getCurrentUserAccount();
        if (responsibleUser == null) {
            throw new IllegalStateException("required logged-in user");
        }
        int ticketSourceResource = (Integer)getResGroupOrThrow.apply(resGroupToDeactivateID).getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_ID);
        int ticketTargetResource = (Integer)getResGroupOrThrow.apply(ticketTargetResGroupID).getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_ID);
        try {
            this.persistence.moveTicketsFromResourceAndItsSubResources(ticketSourceResource, ticketTargetResource, responsibleUser);
            this.deactivateGroup(resGroupToDeactivateID, true);
        }
        catch (Exception ex) {
            HDLogger.error(ex);
            if (ex instanceof PersistenceException) {
                throw (PersistenceException)((Object)ex);
            }
            throw new PersistenceException((Throwable)ex);
        }
    }
}

