/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups;

import java.sql.ResultSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class ResultSetBasedIterator<DATA_UNIT>
implements Iterator<DATA_UNIT> {
    private final ResultSet resultSet;
    private final Function<ResultSet, DATA_UNIT> readFromRS;
    private final Runnable execOnFinish;
    private State state = State.UNKNOWN;
    private DATA_UNIT next;

    public ResultSetBasedIterator(@Nonnull ResultSet resultSet, @Nonnull Function<ResultSet, DATA_UNIT> readFromRS, @Nonnull Runnable execOnFinish) {
        this.resultSet = resultSet;
        this.readFromRS = readFromRS;
        this.execOnFinish = execOnFinish;
    }

    @Override
    public boolean hasNext() {
        this.prepareNextIfNeeded();
        return this.state == State.HAS_NEXT;
    }

    @Override
    public DATA_UNIT next() {
        this.prepareNextIfNeeded();
        if (this.state == State.HAS_NEXT) {
            this.state = State.UNKNOWN;
            return this.next;
        }
        throw new NoSuchElementException();
    }

    private void prepareNextIfNeeded() {
        if (this.state != State.UNKNOWN) {
            return;
        }
        Object dataUnit = null;
        try {
            dataUnit = this.readFromRS.apply(this.resultSet);
            if (dataUnit == null) {
                this.execOnFinish.run();
            }
            this.next = dataUnit;
            this.state = this.next != null ? State.HAS_NEXT : State.HAS_NOT_NEXT;
        }
        catch (Throwable throwable) {
            if (dataUnit == null) {
                this.execOnFinish.run();
            }
            this.next = dataUnit;
            this.state = this.next != null ? State.HAS_NEXT : State.HAS_NOT_NEXT;
            throw throwable;
        }
    }

    private static enum State {
        HAS_NEXT,
        HAS_NOT_NEXT,
        UNKNOWN;

    }
}

