/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager;

import com.inet.config.ConfigValue;
import com.inet.editor.HtmlConverter;
import com.inet.error.BaseErrorCode;
import com.inet.error.ErrorCode;
import com.inet.error.PersistenceException;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.data.TicketDataConnector;
import com.inet.helpdesk.core.error.HDErrors;
import com.inet.helpdesk.core.error.HelpDeskErrorCodes;
import com.inet.helpdesk.core.mail.extension.SendMailExtension;
import com.inet.helpdesk.core.mail.extension.SendMailExtensionContext;
import com.inet.helpdesk.core.model.ticket.BillingInformation;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketActionChecker;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketPermissionChecker;
import com.inet.helpdesk.core.ticketmanager.extension.CreateTicketExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.extension.EmailReceivedArgument;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.extension.TicketSubOperations;
import com.inet.helpdesk.core.ticketmanager.extension.UpdateTicketDataExtension;
import com.inet.helpdesk.core.ticketmanager.fields.DefaultValuesManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilManager;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilVO;
import com.inet.helpdesk.core.ticketmanager.model.ActionCheckError;
import com.inet.helpdesk.core.ticketmanager.model.BundleStepsFilter;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepAttributes;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepText;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketAttributes;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketPermissionContext;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.ProcessingTime;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationNewReaStep;
import com.inet.helpdesk.core.ticketmanager.model.operation.TicketOperationModel;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.WithAdditionalReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeUnread;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.data.ServerDataUtil;
import com.inet.helpdesk.i18n.LocalizationImpl;
import com.inet.helpdesk.mail.reader.TMReceivedMailDataArgument;
import com.inet.helpdesk.shared.model.Status;
import com.inet.helpdesk.ticketmanager.TicketReaderImpl;
import com.inet.helpdesk.ticketmanager.access.TicketActionCheckerImpl;
import com.inet.helpdesk.ticketmanager.access.TicketActionValidator;
import com.inet.helpdesk.ticketmanager.dao.TicketReadDAO;
import com.inet.helpdesk.ticketmanager.dao.TicketReadDAOCacheCleaner;
import com.inet.helpdesk.ticketmanager.dao.TicketWriteDAO;
import com.inet.helpdesk.ticketmanager.extensions.CreateTicketFromMailExtension;
import com.inet.helpdesk.ticketmanager.extensions.UnbundleTicketActionExtensionFactory;
import com.inet.helpdesk.ticketmanager.internal.MandatoryFieldsManagerImpl;
import com.inet.helpdesk.ticketmanager.internal.TicketPreconditionChecks;
import com.inet.helpdesk.ticketmanager.search.TicketSearchDataCache;
import com.inet.helpdesk.ticketmanager.trigger.StatusAndItilChangeTrigger;
import com.inet.helpdesk.ticketmanager.trigger.TicketCreationJavaScriptTrigger;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.groups.IHelpDeskUserGroupManager;
import com.inet.helpdesk.usersandgroups.user.HelpDeskUserManager;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.AccessDeniedException;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import srv.mail.AutoMailSender;
import srv.mail.Mail;

public class TicketManipulatorInternal {
    private final TicketReadDAO readDAO;
    private final TicketSubOperations operations;
    private TicketPermissionChecker permissionChecker;
    private TicketActionCheckerImpl actionChecker;
    private static final ConfigValue<Boolean> RES_MAIL_NO_STATUS_CHANGED = new ConfigValue(HDConfigKeys.RES_MAIL_NO_STATUS_CHANGED);

    public TicketManipulatorInternal(TicketReadDAO readDAO, TicketWriteDAO writeDAO, TicketReaderImpl reader, TicketSearchDataCache searchDataCache, TicketActionCheckerImpl actionChecker, TicketPermissionChecker ticketPermissionChecker) {
        if (readDAO == null) {
            throw new IllegalArgumentException("readDAO must not be null");
        }
        if (actionChecker == null) {
            throw new IllegalArgumentException("actionChecker must not be null");
        }
        if (ticketPermissionChecker == null) {
            throw new IllegalArgumentException("ticketPermissionChecker must not be null");
        }
        if (writeDAO == null) {
            throw new IllegalArgumentException("writeDAO must not be null");
        }
        if (reader == null) {
            throw new IllegalArgumentException("reader must not be null");
        }
        if (searchDataCache == null) {
            throw new IllegalArgumentException("searchDataCache must not be null");
        }
        this.operations = new TicketInnerOperationsImpl(writeDAO, reader, searchDataCache);
        this.readDAO = readDAO;
        this.actionChecker = actionChecker;
        this.permissionChecker = ticketPermissionChecker;
    }

    public OperationChangedTicket createTicket(boolean userIsDispatcher, @Nullable String emailEingang, MutableTicketData newTicketData, ReaStepTextVO ticketText, @Nullable ExtensionArguments extensionArgs, TicketOperationModel model) {
        MutableTicketData ticketData = newTicketData.copy();
        if (extensionArgs == null) {
            extensionArgs = ExtensionArguments.create();
        }
        UserAccount currentUser = TicketManipulatorInternal.getCurrentUserAccountOrThrowISE();
        UserAccount ticketOwner = this.createTicket_determineTicketOwner(userIsDispatcher, ticketData, currentUser);
        ((DefaultValuesManager)ServerPluginManager.getInstance().getSingleInstance(DefaultValuesManager.class)).setDefaultValuesForNewTicket(ticketText, ticketData, ticketOwner);
        boolean shouldDispatch = this.createTicket_checkMustBeDispatched(ticketData, userIsDispatcher, extensionArgs.get(ExtensionArguments.EXTARG_DISPATCH_NOW));
        shouldDispatch = this.createTicket_runJavaScriptTrigger(shouldDispatch, ticketText, extensionArgs, ticketData, ticketOwner);
        this.createTicket_checkInputValues(userIsDispatcher, shouldDispatch, ticketData, ticketText, extensionArgs);
        long timestamp = System.currentTimeMillis();
        MutableTicketAttributes ticketAttributes = this.createTicket_createAttributes(userIsDispatcher, emailEingang, currentUser, 0, timestamp);
        OperationChangedTicket newTicket = model.createNewTicket(ticketData, ticketAttributes);
        OperationNewReaStep inquiryStep = this.createTicket_addInquiryStep(ticketText, currentUser, timestamp, newTicket);
        this.setTicketUnreadIfNewStepRequiresIt(newTicket, inquiryStep);
        if (shouldDispatch) {
            this.createTicket_authorize(timestamp, newTicket, ExtensionArguments.generateForSubOperation(extensionArgs), extensionArgs.get(ExtensionArguments.EXTARG_DISPATCH_NOW));
        }
        this.createTicket_createExtensionAndRunBeforeCreate(extensionArgs, newTicket, inquiryStep, newTicketData);
        if (!shouldDispatch && newTicket.getAttributeValue(Tickets.ATTRIBUTE_DISPATCHING_REA_STEP_ID) == null) {
            this.sendAutoMailsIfNeededAfterTicketStatusChange(newTicket, currentUser, extensionArgs, 4, false, Status.isClosedOrDeletedStatus(newTicket.getAttributeValue(Tickets.ATTRIBUTE_STATUS_ID)));
        }
        return newTicket;
    }

    @Nullable
    private UserAccount createTicket_determineTicketOwner(boolean userIsDispatcher, MutableTicketData ticketData, UserAccount currentUser) {
        GUID ownerID = ticketData.get(Tickets.FIELD_OWNER_GUID);
        if (!userIsDispatcher && !HDUsersAndGroups.isSupporter(currentUser)) {
            if (ownerID == null) {
                ticketData.put(Tickets.FIELD_OWNER_GUID, currentUser.getID());
                return currentUser;
            }
            if (!currentUser.getID().equals((Object)ownerID)) {
                throw new IllegalArgumentException(Tickets.MSG.getMsg("error.cannotCreateForOtherUser", new Object[0]));
            }
        }
        if (ownerID == null) {
            ticketData.put(Tickets.FIELD_OWNER_GUID, null);
            return null;
        }
        UserAccount ticketOwner = UserManager.getInstance().getUserAccount(ownerID);
        return ticketOwner;
    }

    private void createTicket_createExtensionAndRunBeforeCreate(@Nonnull ExtensionArguments extensionArgs, OperationChangedTicket ticket, OperationNewReaStep anfrageStep, MutableTicketData ticketFields) {
        List extensionFactories = ServerPluginManager.getInstance().get(CreateTicketExtensionFactory.class);
        extensionFactories.stream().sorted((f1, f2) -> Integer.compare(f1.getExecutionPriority(), f2.getExecutionPriority())).map(f -> f.createIfApplicable(ticket, extensionArgs, ticketFields)).filter(Objects::nonNull).forEach(ext -> ext.beforeCreate(ticket, anfrageStep, this.operations));
    }

    private void createTicket_authorize(long timestamp, OperationChangedTicket newTicket, ExtensionArguments extArgs, @Nullable ExtensionArguments.DispatchNow dispatchNow) {
        MutableReaStepData authStepData = new MutableReaStepData();
        authStepData.put(ReaStepVO.FIELD_PROCESSING_TIME, ProcessingTime.of(timestamp));
        if (dispatchNow != ExtensionArguments.DispatchNow.ALWAYS) {
            try (UserAccountScope priv = UserAccountScope.createPrivileged();){
                this.operations.applyAction(newTicket, authStepData, ReaStepTextVO.empty(), (ActionVO)ActionManager.getInstance().get(5), extArgs);
            }
        } else {
            this.operations.applyAction(newTicket, authStepData, ReaStepTextVO.empty(), (ActionVO)ActionManager.getInstance().get(5), extArgs);
        }
    }

    private OperationNewReaStep createTicket_addInquiryStep(ReaStepTextVO ticketText, UserAccount currentUser, long timestamp, OperationChangedTicket newTicket) {
        MutableReaStepAttributes inquiryStepAttributes = new MutableReaStepAttributes();
        inquiryStepAttributes.put(ReaStepVO.ATTRIBUTE_ACTION_ID, 4);
        MutableReaStepData inquiryStepData = new MutableReaStepData();
        inquiryStepData.put(ReaStepVO.FIELD_PROCESSING_TIME, ProcessingTime.of(timestamp));
        MutableReaStepText stepText = this.compactTextIfHtml(ticketText);
        OperationNewReaStep inquiryStep = newTicket.addReaStep(inquiryStepAttributes, inquiryStepData, stepText);
        newTicket.getNewTicketAttributes().put(Tickets.ATTRIBUTE_INITIAL_REA_STEP_ID, inquiryStep.getReaStepId());
        newTicket.getNewTicketAttributes().put(Tickets.ATTRIBUTE_TICKET_GUID, GUID.generateNew());
        return inquiryStep;
    }

    private MutableTicketAttributes createTicket_createAttributes(boolean userIsDispatcher, String emailEingang, UserAccount currentUser, int status, long timestamp) {
        MutableTicketAttributes ticketAttributes = new MutableTicketAttributes();
        ticketAttributes.put(Tickets.ATTRIBUTE_STATUS_ID, status);
        ticketAttributes.put(Tickets.ATTRIBUTE_EMAIL_EINGANG, emailEingang);
        ticketAttributes.put(Tickets.ATTRIBUTE_INQUIRY_DATE, timestamp);
        ticketAttributes.put(Tickets.ATTRIBUTE_LAST_EDITOR_GUID, userIsDispatcher ? currentUser.getID() : null);
        ticketAttributes.put(Tickets.ATTRIBUTE_LAST_CHANGED, timestamp);
        return ticketAttributes;
    }

    private boolean createTicket_runJavaScriptTrigger(boolean shouldDispatch, ReaStepTextVO ticketText, ExtensionArguments extensionArgs, MutableTicketData ticketData, @Nullable UserAccount ticketOwner) {
        Boolean execJavaScriptTrigger = extensionArgs.get(ExtensionArguments.EXTARG_NEW_USER_TICKET_JS_TRIGGER);
        if (Boolean.TRUE.equals(execJavaScriptTrigger) && TicketCreationJavaScriptTrigger.isConfigured()) {
            try {
                ConnectionFactory conFactory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
                shouldDispatch = new TicketCreationJavaScriptTrigger(conFactory).apply(ticketOwner, extensionArgs, ticketData, ticketText.getText());
                String subject = TicketManipulatorInternal.createSubjectIfMissing(ticketData.get(Tickets.FIELD_SUBJECT), ticketText.getText(), ticketText.hasHtmlContent());
                ticketData.put(Tickets.FIELD_SUBJECT, subject);
            }
            catch (ServerDataException ex) {
                throw PersistenceException.createWithCode((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
            }
        }
        return shouldDispatch;
    }

    private void createTicket_checkInputValues(boolean userIsDispatcher, boolean shouldDispatch, MutableTicketData ticketData, ReaStepTextVO ticketText, ExtensionArguments extensionArgs) {
        boolean isNoSupporter;
        boolean isFromEmail = extensionArgs.get(ExtensionArguments.EXTARG_EMAIL_DATA) != null;
        boolean bl = isNoSupporter = !HDUsersAndGroups.isSupporter(TicketManipulatorInternal.getCurrentUserAccountOrThrowISE());
        if ((ticketText == null || ticketText.isEmpty()) && StringFunctions.isEmpty((String)ticketData.get(Tickets.FIELD_SUBJECT))) {
            throw new IllegalArgumentException(Tickets.MSG.getMsg("error.missingSubjectOrTicketText", new Object[0]));
        }
        this.checkITILRestrictionOnTicketCreation(ticketData);
        ArrayList<TicketField> requiredFields = new ArrayList<TicketField>();
        if (!isFromEmail) {
            if (!userIsDispatcher && isNoSupporter) {
                MandatoryFieldsManagerImpl.getInstance().checkMandatoryUserValuesOnTicketCreation(ticketData, extensionArgs);
                requiredFields.add(Tickets.FIELD_OWNER_GUID);
            } else if (!HDUsersAndGroups.isPrivilegedUser(TicketManipulatorInternal.getCurrentUserAccountOrThrowISE().getID()) && shouldDispatch && (userIsDispatcher || !isNoSupporter)) {
                MandatoryFieldsManagerImpl.getInstance().checkMandatoryDispatcherValuesOnTicketCreation(ticketData, extensionArgs);
            }
        }
        if (shouldDispatch) {
            requiredFields.add(Tickets.FIELD_RESOURCE_GUID);
        }
        HDLogger.debug("MANIPULATOR TICKET OWNER: " + String.valueOf(ticketData.get(Tickets.FIELD_OWNER_GUID)));
        for (TicketField ticketField : requiredFields) {
            if (ticketData.hasValue(ticketField)) continue;
            throw new IllegalArgumentException(Tickets.MSG.getMsg("error.missingFieldValue", new Object[]{ticketField.getLabel()}));
        }
    }

    private void checkITILRestrictionOnTicketCreation(MutableTicketData ticketData) {
        if (ticketData.hasValue(Tickets.FIELD_ITIL_ID)) {
            Integer itil = ticketData.get(Tickets.FIELD_ITIL_ID);
            ItilManager instance = ItilManager.getInstance();
            if (!(itil == null || Tickets.FIELD_ITIL_ID.getDefaultValue() != null && ((Integer)Tickets.FIELD_ITIL_ID.getDefaultValue()).intValue() == itil.intValue() || instance.isUsableByCurrentUser(itil))) {
                ItilVO i = (ItilVO)instance.get(itil);
                String itilDisplay = i == null ? "???" : i.getDisplayValue();
                throw new IllegalArgumentException(Tickets.MSG.getMsg("actionChecker.itilIsRestricted", new Object[]{itilDisplay}));
            }
        }
    }

    private boolean createTicket_checkMustBeDispatched(MutableTicketData ticketData, boolean userisDispatcher, ExtensionArguments.DispatchNow dispatchNow) {
        if (!this.actionChecker.checkCurrentUserHasPermissionToExecuteAction(5) && dispatchNow == ExtensionArguments.DispatchNow.ALWAYS) {
            throw new AccessDeniedException(Tickets.MSG.getMsg("actionchecker.userHasNoPermissionForAction", new Object[]{TicketManipulatorInternal.getAction(5).getDisplayValue()}), (ErrorCode)BaseErrorCode.AccessDeniedOrFileNotExists);
        }
        boolean shouldDispatch = false;
        boolean haveResource = ticketData.hasValue(Tickets.FIELD_RESOURCE_GUID);
        shouldDispatch = dispatchNow == ExtensionArguments.DispatchNow.ALWAYS ? true : (dispatchNow == ExtensionArguments.DispatchNow.NOT ? false : (dispatchNow == ExtensionArguments.DispatchNow.IF_RESOURCE_AVAILABLE ? haveResource : (userisDispatcher ? false : (HDUsersAndGroups.isSupporter(TicketManipulatorInternal.getCurrentUserAccountOrThrowISE()) ? haveResource && this.actionChecker.checkCurrentUserHasPermissionToExecuteAction(5) : haveResource))));
        return shouldDispatch;
    }

    @Nonnull
    public static String createSubjectIfMissing(String subject, String inquiryText, boolean htmlContent) {
        if ((subject == null || subject.isEmpty()) && inquiryText != null && inquiryText.length() > 0) {
            String plainText = htmlContent ? HtmlConverter.html2text((String)inquiryText) : inquiryText;
            int pointIndex = plainText.indexOf(46);
            int breakIndex = plainText.indexOf(10);
            subject = pointIndex >= 5 ? plainText.substring(0, pointIndex) : (breakIndex >= 5 ? plainText.substring(0, breakIndex) : (plainText.length() > 255 ? plainText.substring(0, 255) : plainText));
            subject = subject.replace("\r", "").replace("\n", " ").replace("\t", " ");
            subject = subject.substring(0, Math.min(50, subject.length()));
        }
        return subject != null ? subject : "";
    }

    private void sendAutoMailsIfNeededAfterTicketStatusChange(OperationChangedTicket ticket, @Nullable UserAccount lastEditor, ExtensionArguments extensionArgs, int actionID, boolean actionIsOpenToCloseTransition, boolean actionResultsInClosedOrDeletedTicket) {
        TicketVO ticketData;
        Boolean suppressIsAutomails = extensionArgs.get(ExtensionArguments.EXTARG_NEW_USER_TICKET_JS_SET_SUPPRESS_AUTOMAILS);
        if (suppressIsAutomails != null && suppressIsAutomails.booleanValue()) {
            return;
        }
        TicketDataConnector.MailNotification mailNotification = this.getAutoMailSettings(extensionArgs);
        String producerEmail = AutoMailSender.getEmailFrom(lastEditor);
        int mailType = -5 == actionID ? ((ticketData = (TicketVO)ticket.getOldTicket().orElse(null)) == null || ticketData.isSlaveInBundle() ? 0 : 8) : AutoMailSender.getMailType(mailNotification, actionID, actionIsOpenToCloseTransition, actionResultsInClosedOrDeletedTicket);
        ticket.getAfterWriteOperations().add(() -> {
            AutoMailSender.sendAutoMailAndNotifyResourceIfNeeded(ticket.getTicketId(), mailType, lastEditor);
            this.sendForSlaveTicketsIfNeeded(ticket.getTicketId(), mailType, producerEmail);
        });
    }

    private void sendForSlaveTicketsIfNeeded(int masterTicketID, int mailType, @Nullable String producerEmail) {
        if (mailType == 4 || mailType == 16) {
            List<TicketVOSingle> slaveTickets = this.readDAO.getTicketsInBundle(masterTicketID, false);
            for (TicketVOSingle slave : slaveTickets) {
                AutoMailSender.sendIfNeeded(slave.getID(), mailType, producerEmail);
            }
        }
    }

    private MutableReaStepText compactTextIfHtml(ReaStepTextVO ticketText) {
        MutableReaStepText stepText = MutableReaStepText.of(ticketText);
        if (stepText.isHtml()) {
            stepText.setText(HtmlConverter.getCompactHtmlText((String)stepText.getText(), null));
        }
        return stepText;
    }

    public void bundleTickets(OperationChangedTicket masterTicket, List<Integer> slaveTicketIDArg, TicketPermissionContext ticketPermissionInfo, TicketOperationModel model) {
        List<Integer> slaveTicketIDs = slaveTicketIDArg.stream().distinct().collect(Collectors.toList());
        ArrayList<TicketVOSingle> slaveTicketVOs = new ArrayList<TicketVOSingle>(slaveTicketIDs.size());
        HashMap<Integer, List<Integer>> slaveToBundledTicketsMap = new HashMap<Integer, List<Integer>>();
        Iterator iterator = slaveTicketIDs.iterator();
        while (iterator.hasNext()) {
            int slaveID = (Integer)iterator.next();
            TicketVOSingle slaveTicket = this.readDAO.getTicket(slaveID);
            slaveTicketVOs.add(slaveTicket);
            if (!slaveTicket.isMasterInBundle()) continue;
            List bundledTicketIDs = this.readDAO.getTicketsInBundle(slaveID, false).stream().map(TicketVO::getID).collect(Collectors.toList());
            slaveToBundledTicketsMap.put(slaveID, bundledTicketIDs);
        }
        ActionVO action = (ActionVO)ActionManager.getInstance().get(-1);
        ExtensionArguments.BundleTicketActionExtensionData extData = new ExtensionArguments.BundleTicketActionExtensionData(slaveTicketIDs, slaveToBundledTicketsMap);
        ExtensionArguments extensionArgs = ExtensionArguments.create();
        extensionArgs.put(ExtensionArguments.EXTARG_BUNDLE_TICKETS, extData);
        this.applyAction(ticketPermissionInfo, masterTicket, new MutableReaStepData(), ReaStepTextVO.empty(), action, extensionArgs);
    }

    public void unbundleTickets(OperationChangedTicket masterTicket, List<Integer> slaveIDsToUnbundle, TicketPermissionContext ticketPermissionInfo, TicketOperationModel model) {
        int masterTicketID = masterTicket.getOldTicket().get().getID();
        if (slaveIDsToUnbundle == null) {
            throw new IllegalArgumentException("list of ticket IDs must not be null");
        }
        if (slaveIDsToUnbundle.contains(null)) {
            throw new IllegalArgumentException("list of ticket IDs must not contain null");
        }
        if (slaveIDsToUnbundle.isEmpty()) {
            throw new IllegalArgumentException("list of ticket IDs must not be empty");
        }
        if (slaveIDsToUnbundle.contains(masterTicketID)) {
            Optional<Integer> firstTicketOutsideBundle;
            slaveTicketIDs = this.readDAO.getTicketsInBundle(masterTicketID, false).stream().map(TicketVO::getID).collect(Collectors.toList());
            if (slaveIDsToUnbundle.size() > 1 && (firstTicketOutsideBundle = slaveIDsToUnbundle.stream().filter(arg_0 -> TicketManipulatorInternal.lambda$unbundleTickets$4(masterTicketID, (List)slaveTicketIDs, arg_0)).findFirst()).isPresent()) {
                throw new IllegalArgumentException(String.format("ticket designated to be unbundled does not belong to specified bundle, ticketID=\"%d\", bundleID=\"%d\".", (int)firstTicketOutsideBundle.get(), masterTicketID));
            }
            slaveIDsToUnbundle = slaveTicketIDs;
        } else {
            slaveIDsToUnbundle = slaveIDsToUnbundle.stream().distinct().collect(Collectors.toList());
            slaveTicketIDs = slaveIDsToUnbundle.iterator();
            while (slaveTicketIDs.hasNext()) {
                int slaveID = (Integer)slaveTicketIDs.next();
                TicketVOSingle slaveTicket = this.readDAO.getTicket(slaveID);
                if (slaveTicket == null) {
                    throw new IllegalArgumentException(String.format("ticket designated to be unbundled does not exist, ticketID=\"%d\".", slaveID));
                }
                if (masterTicketID == slaveTicket.getBundleID()) continue;
                throw new IllegalArgumentException(String.format("ticket designated to be unbundled does not belong to specified bundle, ticketID=\"%d\", bundleID=\"%d\".", slaveID, masterTicketID));
            }
        }
        List<Integer> slaveIDsToUnbundleFinal = slaveIDsToUnbundle;
        ActionVO action = (ActionVO)ActionManager.getInstance().get(-13);
        boolean updateLastEditor = true;
        UnbundleTicketActionExtensionFactory.UnbundleTicketActionExtensionData extData = new UnbundleTicketActionExtensionFactory.UnbundleTicketActionExtensionData(slaveIDsToUnbundleFinal, updateLastEditor);
        ExtensionArguments extensionArgs = ExtensionArguments.create();
        extensionArgs.put(UnbundleTicketActionExtensionFactory.EXTARG_UNBUNDLE_TICKETS, extData);
        this.applyAction(ticketPermissionInfo, masterTicket, new MutableReaStepData(), ReaStepTextVO.empty(), action, extensionArgs);
    }

    public void closeTicket(TicketPermissionContext permissionContext, OperationChangedTicket ticket, ReaStepTextVO text, @Nullable ExtensionArguments extensionArgs, TicketOperationModel model) {
        this.applyAction(permissionContext, ticket, new MutableReaStepData(), text, (ActionVO)ActionManager.getInstance().get(2), extensionArgs);
    }

    private MutableReaStepData generateDataForNewReaStep(int ticketID, ActionVO action, int effortInMinutes, Date dueDate, String description) {
        MutableReaStepData reaStepData = new MutableReaStepData();
        ProcessingTime processingTime = ProcessingTime.ofEffort(effortInMinutes);
        reaStepData.put(ReaStepVO.FIELD_PROCESSING_TIME, processingTime);
        reaStepData.put(ReaStepVO.FIELD_DESC, ReaStepVO.FIELD_DESC.getValidOrDefaultValue(description, null));
        return reaStepData;
    }

    private void applyAnswer(ActionVO actionVO, OperationChangedTicket ticket, MutableReaStepData reaStepData, ReaStepTextVO text, ExtensionArguments extArgs, TicketPermissionContext ticketPermissionInfo, TicketOperationModel model) {
        ReaStepTextVO stepText;
        MutableReaStepData additionalReaStepData;
        ActionVO vo;
        ActionCheckError actionCheckError;
        int ticketID = ticket.getTicketId();
        ExtensionArguments.AdditionalEmailAction applyAnswerData = extArgs.get(ExtensionArguments.EXTARG_APPLY_ANSWER);
        ExtensionArguments.AdditionalEmailAction additionalAction = applyAnswerData;
        if (additionalAction == null) {
            additionalAction = ExtensionArguments.AdditionalEmailAction.SEND_ONLY;
        } else if (additionalAction != ExtensionArguments.AdditionalEmailAction.SEND_ONLY && (actionCheckError = this.actionChecker.checkAction(TicketManipulatorInternal.getAction(2), ticket.getTicketId())) != null) {
            throw HDErrors.createExceptionForCode(actionCheckError);
        }
        OperationNewReaStep reaStep = this.applyAction(ticketPermissionInfo, ticket, reaStepData, text, actionVO, extArgs);
        ticket.getAfterWriteOperations().add(() -> {
            Integer refStep;
            ReaStepVO refReaStep;
            String textForMail = reaStep.getText().getText();
            Vector<Object> attachments = new Vector<Object>();
            Vector<Object> fileNames = new Vector<Object>();
            SendMailExtension ext = (SendMailExtension)ServerPluginManager.getInstance().getOptionalInstance(SendMailExtension.class);
            if (ext != null) {
                SendMailExtensionContext context = new SendMailExtensionContext(ReaStepTextVO.of(textForMail, reaStep.getText().isHtml()));
                ext.doExtendMailMessage(context, ticketID, reaStep.getReaStepId());
                textForMail = context.getMailContextText();
                for (SendMailExtension.AttachmentInfo info : context.getAttachmentsForMail()) {
                    attachments.add(info.getFilePath());
                    fileNames.add(info.getFileName());
                }
            }
            String subject = Objects.toString(reaStepData.get(ReaStepVO.FIELD_DESC), "");
            String receiversTo = Objects.toString(reaStepData.get(ReaStepVO.FIELD_EMAIL_AN), "");
            String receiversCc = Objects.toString(reaStepData.get(ReaStepVO.FIELD_EMAIL_CC), "");
            String receiversBcc = Objects.toString(reaStepData.get(ReaStepVO.FIELD_EMAIL_BCC), "");
            String senderAddress = reaStepData.get(ReaStepVO.FIELD_EMAIL_IN);
            String senderAlias = null;
            if (((Boolean)HDConfigKeys.MAIL_SENDER_ADD_ALIAS.getCurrent()).booleanValue()) {
                senderAlias = this.getSenderAlias(senderAddress);
            }
            Integer refReaStepId = null;
            if (extArgs.containsExtArg(ExtensionArguments.EXTARG_APPLY_ANSWER_REFERENCED_STEP) && (refReaStep = this.readDAO.getReaStep(refStep = extArgs.get(ExtensionArguments.EXTARG_APPLY_ANSWER_REFERENCED_STEP))) != null) {
                refReaStepId = refReaStep.getID();
            }
            Mail.send(ticketID, reaStep.getReaStepId(), textForMail, text.hasHtmlContent(), subject, receiversTo, receiversCc, receiversBcc, senderAddress, senderAlias, attachments, fileNames, refReaStepId);
        });
        if (additionalAction == ExtensionArguments.AdditionalEmailAction.SEND_AND_CLOSE) {
            vo = (ActionVO)ActionManager.getInstance().get(2);
            additionalReaStepData = this.generateDataForNewReaStep(ticketID, vo, 0, null, "");
            stepText = ReaStepTextVO.empty();
            if (Status.isDeletedStatus(vo.getStatusID())) {
                stepText = ReaStepTextVO.of(Tickets.MSG.getMsg(Tickets.serverLocale(), "error.ticketWasDeleted", new Object[]{vo.getDisplayValue()}), false);
            }
            this.applyAction(ticketPermissionInfo, ticket, additionalReaStepData, stepText, vo, ExtensionArguments.generateForSubOperation(extArgs));
        }
        if (additionalAction == ExtensionArguments.AdditionalEmailAction.SEND_AND_CLOSE_AFTER_X_DAYS && Status.isOpenStatus(ticket.getAttributeValue(Tickets.ATTRIBUTE_STATUS_ID))) {
            vo = (ActionVO)ActionManager.getInstance().get(-32);
            additionalReaStepData = this.generateDataForNewReaStep(ticketID, vo, 0, null, "");
            stepText = ReaStepTextVO.empty();
            this.applyAction(ticketPermissionInfo, ticket, additionalReaStepData, stepText, vo, null);
        }
    }

    private String getSenderAlias(String senderAddress) {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        String displayname = currentUserAccount.getDisplayName();
        if (displayname != null && !displayname.equals(senderAddress)) {
            String[] mails;
            String email = (String)currentUserAccount.getValue((UserField)UsersAndGroups.FIELD_EMAIL);
            if (email == null) {
                return displayname;
            }
            for (String mailAddr : mails = email.split(";")) {
                if (!displayname.equalsIgnoreCase(mailAddr)) continue;
                return null;
            }
            return displayname;
        }
        return null;
    }

    public void applyAction_withChecks(OperationChangedTicket ticket, ActionVO action, MutableReaStepData reaStepData, ReaStepTextVO text, ExtensionArguments extensionArgs) {
        this.applyAction_withChecks(ticket, action, reaStepData, text, extensionArgs, false);
    }

    public void applyAction_withChecks(OperationChangedTicket ticket, ActionVO action, MutableReaStepData reaStepData, ReaStepTextVO text, ExtensionArguments extensionArgs, boolean acceptIndirectActions) {
        TicketPermissionContext ticketPermissionInfo;
        int ticketID = ticket.getTicketId();
        TicketVO ticketSnapshotVO = ticket.createIntermediateTicketVO();
        ActionCheckError errormsg = this.actionChecker.checkAction(action, ticketSnapshotVO, ticketPermissionInfo = this.permissionChecker.getTicketPermissionInfo(ticketSnapshotVO));
        if (!(errormsg == null || acceptIndirectActions && this.actionChecker.checkActionIndirectlyAllowed(action, ticketSnapshotVO, ticketPermissionInfo))) {
            throw HDErrors.createExceptionForCode(errormsg);
        }
        TicketActionValidator.validate(ticket, action, reaStepData, text, extensionArgs, ticketPermissionInfo);
        this.throwIfActionHasSeparateDedicatedMethod(action);
        int statusID = action.getStatusID();
        if (Status.isClosedStatus(statusID)) {
            if (!ticketPermissionInfo.hasSupporterWriteAccessToTicket() && (text == null || text.isEmpty())) {
                throw new IllegalArgumentException(Tickets.MSG.getMsg("error.actionRequiresText", new Object[0]));
            }
            TicketPreconditionChecks.throwIfSupporterTriesToCloseOrDeleteSlaveTicket(ticketPermissionInfo, ticketSnapshotVO, action);
        }
        if (Status.isDeletedStatus(statusID)) {
            TicketPreconditionChecks.throwIfSupporterTriesToCloseOrDeleteSlaveTicket(ticketPermissionInfo, ticketSnapshotVO, action);
        }
        if (action.getId() == -12) {
            this.applyActionReactivateIfClosed(action, ticket, text, reaStepData, extensionArgs, ticketPermissionInfo);
            return;
        }
        if (action.getId() == -7 || 211 == action.getStatusID()) {
            this.applyAnswer(action, ticket, reaStepData, text, extensionArgs, ticketPermissionInfo, ticket.getParentModel());
            return;
        }
        if (action.getId() == -9 || action.getId() == -11) {
            EmailReceivedArgument data;
            EmailReceivedArgument emailReceivedArgument = data = extensionArgs != null ? extensionArgs.get(ExtensionArguments.EXTARG_EMAIL_DATA) : null;
            if (data != null) {
                this.emailReceived(ticket, extensionArgs, action);
                return;
            }
            if (action.getId() == -11) {
                this.applyActionReactivateIfClosed(action, ticket, text, reaStepData, extensionArgs, ticketPermissionInfo);
                return;
            }
            throw new IllegalArgumentException("Must pass in Argument EmailReader_HDProcessing.EXTARG_EMAIL_DATA!");
        }
        if (action.getId() == -22) {
            ExtensionArguments.EditReastepTextActionExtensionData changeReaStepData = extensionArgs.get(ExtensionArguments.EXTARG_CHANGED_REA_STEP);
            ReaStepVO reaStep = this.readDAO.getReaStep(changeReaStepData.getChangedReaStepID());
            if (reaStep.getBunID() != ticketID && reaStep.getOrgBunID() != ticketID) {
                throw new IllegalArgumentException(String.format("The given reaStep %d does not belong to given ticket %d", changeReaStepData.getChangedReaStepID(), ticketID));
            }
            this.updateReaStepText(ticketPermissionInfo, extensionArgs, ticket);
            return;
        }
        this.applyAction(ticketPermissionInfo, ticket, reaStepData, text, action, extensionArgs);
    }

    public OperationNewReaStep applyAction(TicketPermissionContext ticketPermissionInfo, OperationChangedTicket ticket, MutableReaStepData reaStepData, ReaStepTextVO text, ActionVO action, @Nullable ExtensionArguments extensionArgs) {
        TicketActionExtensionFactory.ActionTransformation transform = this.transformActionAndArgumentsIfApplicable(ticket, action, extensionArgs);
        ApplyActionData operationData = new ApplyActionData();
        operationData.action = transform.getAction();
        operationData.extensionArgs = transform.getArguments();
        if (operationData.extensionArgs == null) {
            operationData.extensionArgs = ExtensionArguments.create();
        }
        operationData.currentUser = TicketManipulatorInternal.getCurrentUserAccountOrThrowISE();
        operationData.ticket = ticket;
        if ((ticketPermissionInfo.hasResourceAccessToTicket() || ticketPermissionInfo.hasDispatcherAccessToTicket()) && operationData.action.getId() != -12) {
            operationData.lastEditor = operationData.currentUser;
        }
        ticket.getNewTicketAttributes().put(Tickets.ATTRIBUTE_LAST_CHANGED, System.currentTimeMillis());
        OperationNewReaStep step = ticket.addReaStep(operationData.action.getId(), reaStepData, this.compactTextIfHtml(text));
        if (extensionArgs != null && extensionArgs.containsExtArg(ExtensionArguments.EXTARG_TICKET_DATA)) {
            MutableTicketData data = extensionArgs.get(ExtensionArguments.EXTARG_TICKET_DATA);
            this.updateTicketData(ticket, data);
            MutableReaStepData additionalReaStepData = WithAdditionalReaStepData.getAdditionalReaStepData();
            if (additionalReaStepData == null || !additionalReaStepData.containsField(ReaStepVO.FIELD_GROUP_REASTEP)) {
                try (WithAdditionalReaStepData d = WithAdditionalReaStepData.create(ReaStepVO.FIELD_GROUP_REASTEP, step.getReaStepId());){
                    ticket.createFieldChangeReaStepsIfNeeded(null);
                }
                step.getFields().put(ReaStepVO.FIELD_GROUP_REASTEP, step.getReaStepId());
            } else {
                ticket.createFieldChangeReaStepsIfNeeded(null);
            }
        }
        this.applyActionIntern(operationData, ticket, step, ticket.getParentModel());
        return step;
    }

    private void applyActionIntern(ApplyActionData operationData, OperationChangedTicket ticket, OperationNewReaStep reaStep, TicketOperationModel model) {
        this.applyAction_setDefaultProcessingTime(operationData, reaStep);
        this.applyAction_createReaStepAttributesWithAutomaticValues(operationData, reaStep);
        this.applyAction_updateStatusAndLastEditor(operationData, ticket);
        this.applyAction_updateTicketSumTimeIfNeeded(ticket, reaStep);
        if (5 == operationData.action.getId()) {
            ticket.getNewTicketAttributes().put(Tickets.ATTRIBUTE_DISPATCHING_REA_STEP_ID, reaStep.getReaStepId());
        }
        this.setTicketUnreadIfNewStepRequiresIt(ticket, reaStep);
        this.applyAction_callExtensions(operationData, reaStep, model);
        if (!operationData.ticket.isNew()) {
            this.applyAction_performAdditionalOperationsIfBundled(operationData, ticket, model, reaStep);
        }
        boolean actionIsOpenToClosedTransition = Status.isOpenStatus(ticket.isNew() ? 0 : ticket.getOldTicket().get().getStatusID()) && Status.isClosedStatus(operationData.status) && Status.isClosedOrDeletedStatus(operationData.action.getStatusID());
        this.sendAutoMailsIfNeededAfterTicketStatusChange(ticket, operationData.lastEditor, operationData.extensionArgs, operationData.action.getId(), actionIsOpenToClosedTransition, Status.isClosedOrDeletedStatus(ticket.getAttributeValue(Tickets.ATTRIBUTE_STATUS_ID)));
        ticket.getAfterWriteOperations().add(() -> StatusAndItilChangeTrigger.executeStatusTriggerIfActionDidNotChangeStatus(ticket.getOldTicket().orElseGet(() -> null), this.readDAO.getTicket(ticket.getTicketId()), operationData.action.getStatusID()));
    }

    private void applyAction_updateStatusAndLastEditor(ApplyActionData operationData, OperationChangedTicket ticket) {
        if (operationData.lastEditor != null && !UserManager.PRIVILEGED_ACCOUNT_ID.equals((Object)operationData.lastEditor.getID())) {
            ticket.getNewTicketAttributes().put(Tickets.ATTRIBUTE_LAST_EDITOR_GUID, operationData.lastEditor.getID());
        }
        ticket.getNewTicketAttributes().put(Tickets.ATTRIBUTE_STATUS_ID, operationData.status);
    }

    private void applyAction_performAdditionalOperationsIfBundled(ApplyActionData operationData, OperationChangedTicket ticket, TicketOperationModel model, OperationNewReaStep reaStep) {
        TicketVO ticketVO = ticket.getOldTicket().get();
        if (ticketVO.isMasterInBundle()) {
            boolean actionReactivatesBundle;
            boolean actionClosesOrDeletesBundle = Status.isOpenStatus(ticketVO.getStatusID()) && Status.isClosedOrDeletedStatus(operationData.status);
            boolean bl = actionReactivatesBundle = Status.isClosedOrDeletedStatus(ticketVO.getStatusID()) && Status.isOpenStatus(operationData.status);
            if (actionClosesOrDeletesBundle || actionReactivatesBundle) {
                this.readDAO.getTicketsInBundle(ticketVO.getID(), false).forEach(slave -> {
                    OperationChangedTicket slaveTicket = model.changeExistingTicket(slave.getID());
                    slaveTicket.getNewTicketAttributes().put(Tickets.ATTRIBUTE_STATUS_ID, operationData.status);
                    slaveTicket.getNewTicketAttributes().put(Tickets.ATTRIBUTE_CLOSE_DATE, actionClosesOrDeletesBundle ? Long.valueOf(System.currentTimeMillis()) : null);
                });
            }
            if ((operationData.action.getSpecial() & 0x80) > 0) {
                List<TicketVOSingle> ticketsInBundle = this.readDAO.getTicketsInBundle(ticketVO.getID(), false);
                for (TicketVOSingle slave2 : ticketsInBundle) {
                    OperationChangedTicket changedTicket = model.changeExistingTicket(slave2.getID());
                    Set<Integer> oldVal = changedTicket.getAttributeValue(Tickets.ATTRIBUTE_UNREAD_ENDUSER);
                    HashSet<Integer> newVal = new HashSet<Integer>(oldVal);
                    newVal.add(reaStep.getReaStepId());
                    changedTicket.getNewTicketAttributes().put(Tickets.ATTRIBUTE_UNREAD_ENDUSER, newVal);
                }
            }
        }
        if (ticketVO.isSlaveInBundle()) {
            int masterTicketID = ticketVO.getBundleID();
            OperationChangedTicket masterTicket = model.changeExistingTicket(masterTicketID);
            if (operationData.lastEditor != null && !UserManager.PRIVILEGED_ACCOUNT_ID.equals((Object)operationData.lastEditor.getID())) {
                masterTicket.getNewTicketAttributes().put(Tickets.ATTRIBUTE_LAST_EDITOR_GUID, operationData.lastEditor.getID());
            }
            masterTicket.getNewTicketAttributes().put(Tickets.ATTRIBUTE_LAST_CHANGED, ticket.getAttributeValue(Tickets.ATTRIBUTE_LAST_CHANGED));
            if (operationData.action.getId() == -12 || operationData.action.getId() == -9) {
                masterTicket.getNewTicketAttributes().put(Tickets.ATTRIBUTE_STATUS_ID, operationData.status);
            }
        }
    }

    private void applyAction_updateTicketSumTimeIfNeeded(OperationChangedTicket ticket, OperationNewReaStep reaStep) {
        ProcessingTime processingTime = reaStep.getFields().get(ReaStepVO.FIELD_PROCESSING_TIME);
        if (processingTime.getEffortInMin() > 0L) {
            this.updateTicketSumTime(ticket, processingTime.getEffortInMin());
        }
    }

    public void updateTicketSumTime(OperationChangedTicket ticket, long sumTimeDiffinMin) {
        AtomicLong summe = new AtomicLong(sumTimeDiffinMin);
        OperationChangedTicket ticketToUpdate = ticket;
        if (!ticket.isNew()) {
            if (ticket.getOldTicket().get().isSlaveInBundle()) {
                ticketToUpdate = ticket.getParentModel().changeExistingTicket(ticket.getOldTicket().get().getBundleID());
            }
            TicketManager.extending().getTicketInnerOperations().getReaStepsForTicket(ticketToUpdate.getTicketId(), BundleStepsFilter.WITH_BUNDLE_STEPS).forEach(ticketStep -> {
                if (ticketStep.getStartDate() > 0L && ticketStep.getEndDate() > 0L) {
                    summe.addAndGet((ticketStep.getEndDate() - ticketStep.getStartDate()) / 60000L);
                }
            });
        }
        ticketToUpdate.getNewTicketAttributes().put(Tickets.ATTRIBUTE_SUM_TIME, summe.intValue());
    }

    private void applyAction_callExtensions(ApplyActionData operationData, OperationNewReaStep reaStep, TicketOperationModel model) {
        List extensionFactories = ServerPluginManager.getInstance().get(TicketActionExtensionFactory.class);
        extensionFactories.stream().sorted((f1, f2) -> Integer.compare(f1.getExecutionPriority(), f2.getExecutionPriority())).map(f -> f.createIfApplicable(operationData.ticket, operationData.action, operationData.extensionArgs, reaStep.getFields())).filter(Objects::nonNull).forEach(ext -> ext.extendTicketAction(operationData.action, operationData.ticket, reaStep, this.operations));
    }

    private void applyAction_createReaStepAttributesWithAutomaticValues(ApplyActionData operationData, OperationNewReaStep reaStep) {
        BillingInformation billingInfo;
        reaStep.getAttributes().put(ReaStepVO.ATTRIBUTE_ACTION_ID, operationData.action.getId());
        if (!operationData.ticket.isNew() && !operationData.ticket.getOldTicket().get().isInquiry() && (billingInfo = ServerDataUtil.getBilling(operationData.action.getId(), operationData.currentUser)) != null && operationData.ticket.getOldTicket().get().getResourceID() != null) {
            GUID resID = operationData.ticket.getOldTicket().get().getResourceID();
            UserGroupInfo resource = UserGroupManager.getInstance().getGroup(resID);
            if (resource == null) {
                HDLogger.error("Resource does not exist :" + String.valueOf(resID) + ". No lumpSum and hourlyRate set in reaStep.");
            } else if (resource.isActive()) {
                Double pauschale = billingInfo.getLumpSum() != null ? Double.valueOf(billingInfo.getLumpSum().doubleValue()) : null;
                reaStep.getAttributes().put(ReaStepVO.ATTRIBUTE_LUMP_SUM, ReaStepVO.ATTRIBUTE_LUMP_SUM.getValidOrDefaultValue(pauschale, null));
                long effortInMin = reaStep.getFields().get(ReaStepVO.FIELD_PROCESSING_TIME).getEffortInMin();
                if (pauschale != null || effortInMin > 0L) {
                    reaStep.getAttributes().put(ReaStepVO.ATTRIBUTE_RES_ID, (Integer)resource.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_ID));
                }
                if (effortInMin > 0L && billingInfo.isHourlyRated()) {
                    double hourlyRate = (Double)resource.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_HOURLY_RATE);
                    reaStep.getAttributes().put(ReaStepVO.ATTRIBUTE_HOURLY_RATE, hourlyRate);
                }
            }
        }
    }

    private void applyAction_setDefaultProcessingTime(ApplyActionData operationData, OperationNewReaStep reaStep) {
        Integer oldStatus = operationData.ticket.getAttributeValue(Tickets.ATTRIBUTE_STATUS_ID);
        int n = operationData.status = oldStatus == null ? 0 : oldStatus;
        if (operationData.action.getStatusID() >= 0) {
            operationData.status = operationData.action.getStatusID();
        }
        if (reaStep.getFields().get(ReaStepVO.FIELD_PROCESSING_TIME) == null) {
            ProcessingTime processingTime = ProcessingTime.ofEffort(0);
            reaStep.getFields().put(ReaStepVO.FIELD_PROCESSING_TIME, processingTime);
        }
    }

    @Nonnull
    private TicketActionExtensionFactory.ActionTransformation transformActionAndArgumentsIfApplicable(OperationChangedTicket ticket, ActionVO action, @Nullable ExtensionArguments extensionArgs) {
        extensionArgs = extensionArgs == null ? ExtensionArguments.create() : ExtensionArguments.copyOf(extensionArgs);
        for (TicketActionExtensionFactory factory : ServerPluginManager.getInstance().get(TicketActionExtensionFactory.class)) {
            TicketActionExtensionFactory.ActionTransformation transformation = factory.transformActionRequest(ticket, action, extensionArgs);
            if (transformation == null) continue;
            action = transformation.getAction();
            extensionArgs = transformation.getArguments();
        }
        return TicketActionExtensionFactory.ActionTransformation.of(action, extensionArgs);
    }

    private TicketDataConnector.MailNotification getAutoMailSettings(@Nullable ExtensionArguments extArgs) {
        TicketDataConnector.MailNotification autoMailArg;
        if (extArgs != null && (autoMailArg = extArgs.get(ExtensionArguments.EXTARG_AUTO_MAIL)) != null && autoMailArg instanceof TicketDataConnector.MailNotification) {
            return autoMailArg;
        }
        return TicketDataConnector.MailNotification.SERVERSETTING;
    }

    private void throwIfActionHasSeparateDedicatedMethod(ActionVO action) {
        List<Integer> idsOfActionsWithDedicatedSeparateMethods = Arrays.asList(-1, -13, 4);
        if (idsOfActionsWithDedicatedSeparateMethods.contains(action.getId())) {
            throw new IllegalArgumentException(String.format("Action with ID=\"%d\" should be applied using separate dedicated method.", action.getId()));
        }
    }

    private static ActionVO getAction(int aktID) {
        return (ActionVO)ActionManager.getInstance().get(aktID);
    }

    public void updateReaStepText(TicketPermissionContext ticketPermissionInfo, ExtensionArguments args, OperationChangedTicket operationTicket) {
        ExtensionArguments.EditReastepTextActionExtensionData editReastepTextActionExtensionData = args.get(ExtensionArguments.EXTARG_CHANGED_REA_STEP);
        ReaStepTextVO originalText = this.readDAO.getReaStepText(editReastepTextActionExtensionData.getChangedReaStepID());
        ReaStepTextVO changeReaStepContent = editReastepTextActionExtensionData.getChangeReaStepContent();
        Object originalTextToCompare = null;
        if (originalText != null) {
            originalTextToCompare = originalText.getText().trim();
            if (originalText.hasHtmlContent()) {
                originalTextToCompare = HtmlConverter.html2inlinedHtml((String)originalTextToCompare);
            }
            originalTextToCompare = (originalText.hasHtmlContent() ? "text/html:" : "text/plain:") + (String)originalTextToCompare;
        }
        Object changeReaStepTextToCompare = null;
        if (changeReaStepContent != null) {
            changeReaStepTextToCompare = changeReaStepContent.getText().trim();
            if (changeReaStepContent.hasHtmlContent()) {
                changeReaStepTextToCompare = HtmlConverter.html2inlinedHtml((String)changeReaStepTextToCompare);
            }
            changeReaStepTextToCompare = (changeReaStepContent.hasHtmlContent() ? "text/html:" : "text/plain:") + (String)changeReaStepTextToCompare;
        }
        if (Objects.equals(originalTextToCompare, changeReaStepTextToCompare)) {
            HDLogger.debug("[UpdateReaStepText] no change was made");
            return;
        }
        MutableReaStepData reaStepData = new MutableReaStepData();
        ActionVO action = (ActionVO)ActionManager.getInstance().get(-22);
        ReaStepVO reaStep = this.readDAO.getReaStep(editReastepTextActionExtensionData.getChangedReaStepID());
        String modifiedStepName = "";
        ActionVO actionVO = (ActionVO)ActionManager.getInstance().get(reaStep.getActionID());
        modifiedStepName = actionVO != null ? actionVO.getDisplayValue() : HelpDeskUserManager.MSG.getMsg("helpdesk.server.reastep.text.previousstate.unknown", new Object[0]);
        Format format = LocalizationImpl.getStaticInstance().getFormatInstance(9);
        String modifiedStepTimestamp = format.format(new Date(reaStep.getStartDate()));
        String changesText = HelpDeskUserManager.MSG.getMsg("helpdesk.server.reastep.text.change", new Object[]{modifiedStepName, modifiedStepTimestamp});
        reaStepData.put(ReaStepVO.FIELD_DESC, changesText);
        reaStepData.put(ReaStepVO.FIELD_PARENT_REASTEP, editReastepTextActionExtensionData.getChangedReaStepID());
        OperationChangedTicket targetTicket = reaStep.getBunID() != reaStep.getOrgBunID() ? operationTicket.getParentModel().changeExistingTicket(reaStep.getOrgBunID()) : operationTicket;
        this.applyAction(ticketPermissionInfo, targetTicket, reaStepData, ReaStepTextVO.empty(), action, args);
    }

    public void updateTicketData_withChecks(OperationChangedTicket ticket, MutableTicketData data) {
        ActionCheckError error = this.actionChecker.checkAktionUpdateTicketData(ticket.createIntermediateTicketVO(), data);
        if (error != null) {
            throw HDErrors.createExceptionForCode(error);
        }
        TicketVO ticketVO = ticket.getOldTicket().orElse(ticket.createIntermediateTicketVO());
        if (ticketVO.isOpenAndDispatched() && !TicketActionChecker.ticketDataOnlyContainsTicketLinkings(data)) {
            MutableTicketData combined = data.copy();
            for (TicketField<Object> f : ticketVO.getIncludedFields()) {
                if (combined.containsKey(f)) continue;
                combined.put(f, ticketVO.getValue(f));
            }
            MandatoryFieldsManagerImpl.getInstance().checkMandatoryFieldsForUpdateTicketData(ticketVO, combined, ExtensionArguments.create());
        }
        this.updateTicketData(ticket, data);
    }

    public void updateTicketData(OperationChangedTicket ticket, @Nonnull MutableTicketData ticketData) {
        TicketVO ticketBefore;
        GUID currentUserID;
        if (ticketData == null) {
            throw new IllegalArgumentException("Ticket data must not be null.");
        }
        if (ticketData.isEmpty()) {
            return;
        }
        ticketData = ticketData.copy();
        MutableTicketAttributes attributes = new MutableTicketAttributes();
        long newLastChanged = System.currentTimeMillis();
        attributes.put(Tickets.ATTRIBUTE_LAST_CHANGED, newLastChanged);
        boolean changeOnlyAnnotation = ticketData.getIncludedFields().equals(Collections.singleton(Tickets.FIELD_ANNOTATION));
        if (!(changeOnlyAnnotation || TicketActionChecker.ticketDataOnlyContainsTicketLinkings(ticketData) || UserManager.PRIVILEGED_ACCOUNT_ID.equals((Object)(currentUserID = TicketManipulatorInternal.getCurrentUserAccountOrThrowISE().getID())) || !this.permissionChecker.getTicketPermissionInfo(ticket.getTicketId()).hasResourceAccessToTicket() && !this.permissionChecker.getTicketPermissionInfo(ticket.getTicketId()).hasDispatcherAccessToTicket())) {
            attributes.put(Tickets.ATTRIBUTE_LAST_EDITOR_GUID, currentUserID);
        }
        if ((ticketBefore = ticket.createIntermediateTicketVO()).isDispatched() && ticketData.containsKey(Tickets.FIELD_RESOURCE_GUID)) {
            GUID resID = ticketData.get(Tickets.FIELD_RESOURCE_GUID);
            if (resID == null) {
                throw new IllegalArgumentException("Resource cannot be set to null");
            }
            ticketData.remove(Tickets.FIELD_RESOURCE_GUID);
            if (!Objects.equals(ticketBefore.getResourceID(), resID)) {
                ActionVO escalateAction = (ActionVO)ActionManager.getInstance().get(8);
                ExtensionArguments extArgs = ExtensionArguments.create();
                extArgs.put(ExtensionArguments.EXTARG_RESOURCE_ACTION_EXTENSION_DATA, ExtensionArguments.ResourceActionExtensionData.forEscalationOfActiveTicket(resID, true));
                extArgs.put(ExtensionArguments.EXTARG_IMPLICIT_AUTO_ACTION, Boolean.TRUE);
                MutableReaStepData reaStepData = new MutableReaStepData();
                this.operations.applyAction(ticket, reaStepData, ReaStepTextVO.empty(), escalateAction, extArgs);
            }
        }
        ticket.getNewTicketAttributes().putAll(attributes);
        ticket.getNewTicketData().putAll(ticketData);
        MutableTicketData finalTicketData = ticketData;
        ServerPluginManager.getInstance().get(UpdateTicketDataExtension.class).stream().sorted((f1, f2) -> Integer.compare(f1.getExecutionPriority(), f2.getExecutionPriority())).forEach(ext -> ext.beforeWriteTicketData(ticket, this.operations, finalTicketData));
    }

    public static UserAccount getCurrentUserAccountOrThrowISE() throws IllegalStateException {
        UserAccount account = UserManager.getInstance().getCurrentUserAccount();
        if (account == null) {
            throw new IllegalStateException("No user is logged in.");
        }
        return account;
    }

    public TicketSubOperations getSubOperations() {
        return this.operations;
    }

    public void applyActionReactivateIfClosed(ActionVO action, OperationChangedTicket ticket, ReaStepTextVO text, MutableReaStepData reaStepData, ExtensionArguments extensionArgs, TicketPermissionContext ticketPermissionContext) {
        this.reopenTicketIfClosed(ticket, reaStepData, extensionArgs, ticketPermissionContext);
        this.applyAction(ticketPermissionContext, ticket, reaStepData, text, action, extensionArgs);
    }

    private void reopenTicketIfClosed(OperationChangedTicket ticket, MutableReaStepData reaStepData, ExtensionArguments extensionArgs, TicketPermissionContext ticketPermissionContext) {
        if (Status.isClosedOrDeletedStatus(ticket.getOldTicket().get().getStatusID())) {
            MutableReaStepData reactivationData = new MutableReaStepData();
            if (reaStepData.containsField(ReaStepVO.FIELD_PROCESSING_TIME)) {
                reactivationData.put(ReaStepVO.FIELD_PROCESSING_TIME, ProcessingTime.of(reaStepData.get(ReaStepVO.FIELD_PROCESSING_TIME).getEnd()));
            }
            ExtensionArguments argsForReactivation = extensionArgs == null ? ExtensionArguments.create() : ExtensionArguments.generateForSubOperation(extensionArgs);
            argsForReactivation.put(ExtensionArguments.EXTARG_AUTO_MAIL, TicketDataConnector.MailNotification.NEVER);
            this.applyAction(ticketPermissionContext, ticket, reactivationData, ReaStepTextVO.empty(), (ActionVO)ActionManager.getInstance().get(-2), argsForReactivation);
        }
    }

    private void emailReceived(OperationChangedTicket ticket, ExtensionArguments args, ActionVO action) {
        TMReceivedMailDataArgument data = (TMReceivedMailDataArgument)args.get(ExtensionArguments.EXTARG_EMAIL_DATA);
        TicketVO ticketVo = ticket.createIntermediateTicketVO();
        GUID userID = data.getSenderAccount() == null ? UserManager.PRIVILEGED_ACCOUNT_ID : data.getSenderAccount().getID();
        try (UserAccountScope scope = UserAccountScope.create((GUID)userID);){
            TicketPermissionContext ticketPermissionInfo = this.permissionChecker.getTicketPermissionInfo(ticket.getTicketId());
            if (!data.getResponseType().isSuppressTicketActions()) {
                this.reopenTicketIfClosed(ticket, new MutableReaStepData(), args, ticketPermissionInfo);
            }
            this._applyEmpfangenAction(ticket, args, ticketPermissionInfo, data, action);
            if (data.getResponseType().isSuppressTicketActions()) {
                ticket.getNewTicketAttributes().put(Tickets.ATTRIBUTE_LAST_CHANGED, System.currentTimeMillis());
            } else {
                this._applyAutorisierenEscalateAndUpdateTicketData(ticket, args, ticketPermissionInfo, data, ticketVo);
                if (ticket.getOldTicket().get().isDispatched() && ((Boolean)RES_MAIL_NO_STATUS_CHANGED.get()).booleanValue() && this.isMemberOfResource(HDUsersAndGroups.getResourceId(ticket.getFieldValue(Tickets.FIELD_RESOURCE_GUID)), data.getSenderMail())) {
                    ticket.getNewTicketAttributes().remove(Tickets.ATTRIBUTE_STATUS_ID);
                    ticket.getNewTicketAttributes().remove(Tickets.ATTRIBUTE_CLOSE_DATE);
                    ticket.getNewTicketAttributes().remove(Tickets.ATTRIBUTE_WIEDERVORLAGEDATE);
                } else {
                    CreateTicketFromMailExtension.applyPossibleStatusSetByMailTrigger(ticket, args, data, this.operations);
                }
                if (data.getWiedervorlageDateChangedByTrigger() != 0L) {
                    ticket.getNewTicketAttributes().put(Tickets.ATTRIBUTE_WIEDERVORLAGEDATE, data.getWiedervorlageDateChangedByTrigger());
                }
            }
        }
    }

    private boolean isMemberOfResource(int resourceID, String emailAdr) {
        IHelpDeskUserGroupManager manager = (IHelpDeskUserGroupManager)UserGroupManager.getInstance();
        UserGroupInfo resource = manager.getUserGroupInfoForResourceId(resourceID);
        Set memberIDs = resource.getMemberIDs();
        UserManager userManager = UserManager.getInstance();
        for (GUID id : memberIDs) {
            String email;
            UserAccount account = userManager.getUserAccount(id);
            if (account == null || !(email = (String)account.getValue((UserField)UsersAndGroups.FIELD_EMAIL)).equalsIgnoreCase(emailAdr) && email.indexOf(emailAdr) < 0) continue;
            return true;
        }
        return false;
    }

    private void asSystem(Runnable task) {
        try (UserAccountScope scope = UserAccountScope.createPrivileged();){
            task.run();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void _applyAutorisierenEscalateAndUpdateTicketData(OperationChangedTicket ticket, ExtensionArguments args, TicketPermissionContext ticketPermissionInfo, TMReceivedMailDataArgument data, TicketVO ticketVo) {
        MutableTicketData changedTicketFields = data.getChangedTicketFields();
        if (changedTicketFields.containsKey(Tickets.FIELD_RESOURCE_GUID)) {
            if (!changedTicketFields.get(Tickets.FIELD_RESOURCE_GUID).equals((Object)ticket.getOldTicket().get().getResourceID())) {
                if (ticketVo.isInquiry()) {
                    this.updateTicketData(ticket, changedTicketFields);
                    this.asSystem(() -> {
                        ExtensionArguments extensionArgs = ExtensionArguments.generateForSubOperation(args);
                        extensionArgs.put(ExtensionArguments.EXTARG_AUTO_MAIL, TicketDataConnector.MailNotification.NEVER);
                        this.applyAction(ticketPermissionInfo, ticket, new MutableReaStepData(), ReaStepTextVO.empty(), TicketManipulatorInternal.getAction(5), extensionArgs);
                    });
                } else {
                    changedTicketFields = changedTicketFields.copy();
                    GUID resource = changedTicketFields.get(Tickets.FIELD_RESOURCE_GUID);
                    changedTicketFields.remove(Tickets.FIELD_RESOURCE_GUID);
                    this.updateTicketData(ticket, changedTicketFields);
                    this.asSystem(() -> {
                        ExtensionArguments extensionArgs = ExtensionArguments.generateForSubOperation(args);
                        extensionArgs.put(ExtensionArguments.EXTARG_AUTO_MAIL, TicketDataConnector.MailNotification.NEVER);
                        extensionArgs.put(ExtensionArguments.EXTARG_RESOURCE_ACTION_EXTENSION_DATA, ExtensionArguments.ResourceActionExtensionData.forEscalationOfActiveTicket(resource, false));
                        this.applyAction(ticketPermissionInfo, ticket, new MutableReaStepData(), ReaStepTextVO.empty(), TicketManipulatorInternal.getAction(8), extensionArgs);
                    });
                }
            }
        } else {
            this.updateTicketData(ticket, changedTicketFields);
        }
    }

    private void _applyEmpfangenAction(OperationChangedTicket ticket, ExtensionArguments args, TicketPermissionContext ticketPermissionInfo, TMReceivedMailDataArgument data, ActionVO action) {
        if (action.getId() == -9) {
            action = TicketManipulatorInternal.getAction(this.getEmpfangenActionForEmailFromSender(data.getSenderMail()));
        }
        MutableReaStepData reaStepData = new MutableReaStepData();
        reaStepData.put(ReaStepVO.FIELD_PROCESSING_TIME, ProcessingTime.of(data.getReceivedDate()));
        reaStepData.put(ReaStepVO.FIELD_USER_DISPLAY_NAME, data.getSenderName());
        reaStepData.put(ReaStepVO.FIELD_EMAIL_IN, data.getSenderMail());
        reaStepData.putValidOrDefaultValue(ReaStepVO.FIELD_EMAIL_AN, data.getReceiverMail());
        reaStepData.putValidOrDefaultValue(ReaStepVO.FIELD_EMAIL_CC, data.getReceiverCCMail());
        reaStepData.put(ReaStepVO.FIELD_DESC, data.getReaStepDescriptionString());
        reaStepData.put(ReaStepVO.FIELD_EMAIL_MESSAGE_ID, data.getMessageId());
        reaStepData.put(ReaStepVO.FIELD_EMAIL_REFERENCE, data.getReferenceId());
        ReaStepTextVO text = data.getContentText().toVO();
        if (data.getResponseType().isSuppressTicketActions()) {
            ticket.addReaStep(action.getId(), reaStepData, MutableReaStepText.of(text));
        } else {
            this.applyAction(ticketPermissionInfo, ticket, reaStepData, text, action, args);
        }
    }

    private int getEmpfangenActionForEmailFromSender(String senderAddress) {
        return -9;
    }

    public void setTicketToRead(OperationChangedTicket operationTicket, TicketPermissionContext permissionInfo) {
        if (permissionInfo.hasEnduserAccessToTicket()) {
            operationTicket.getNewTicketAttributes().put(Tickets.ATTRIBUTE_UNREAD_ENDUSER, Set.of());
        } else if (permissionInfo.hasSupporterWriteAccessToTicket()) {
            operationTicket.getNewTicketAttributes().put(Tickets.ATTRIBUTE_UNREAD_SUPPORTER, Set.of());
            this.changeTicketStatusToGelesenIfRequired(operationTicket);
        } else {
            throw HDErrors.createExceptionForCode(ActionCheckError.createForAccessDenied("You do not have the permission to edit the ticket."));
        }
    }

    public void setTicketToUnread(OperationChangedTicket operationTicket, TicketPermissionContext permissionInfo) {
        if (!permissionInfo.hasEnduserAccessToTicket() && !permissionInfo.hasSupporterWriteAccessToTicket()) {
            throw HDErrors.createExceptionForCode(ActionCheckError.createForAccessDenied("You do not have the permission to edit the ticket."));
        }
        this.markReaStepAsUnread(operationTicket, operationTicket.getAttributeValue(Tickets.ATTRIBUTE_INITIAL_REA_STEP_ID));
    }

    private void setTicketUnreadIfNewStepRequiresIt(OperationChangedTicket ticket, OperationNewReaStep newStep) {
        ActionVO action = (ActionVO)ActionManager.getInstance().get(newStep.getAttributes().get(ReaStepVO.ATTRIBUTE_ACTION_ID));
        if (action.isSetUnreadForEnduser()) {
            this.setStepUnread(true, newStep.getReaStepId(), ticket);
        }
        if (action.isSetUnreadForSupporter()) {
            this.setStepUnread(false, newStep.getReaStepId(), ticket);
        }
    }

    private void setStepUnread(boolean enduserElseSupporter, int reaStep, OperationChangedTicket operationTicket) {
        Set<Integer> old = operationTicket.getAttributeValue(enduserElseSupporter ? Tickets.ATTRIBUTE_UNREAD_ENDUSER : Tickets.ATTRIBUTE_UNREAD_SUPPORTER);
        HashSet<Integer> updated = old == null ? new HashSet<Integer>() : new HashSet<Integer>(old);
        updated.add(reaStep);
        operationTicket.getNewTicketAttributes().put(enduserElseSupporter ? Tickets.ATTRIBUTE_UNREAD_ENDUSER : Tickets.ATTRIBUTE_UNREAD_SUPPORTER, updated);
    }

    private boolean changeTicketStatusToGelesenIfRequired(@Nonnull OperationChangedTicket ticket) {
        int targetStatus = 103;
        List<Integer> requiredStatusesToMatchBeforeChange = Arrays.asList(100, 101);
        if (requiredStatusesToMatchBeforeChange.contains(ticket.getOldTicket().get().getStatusID())) {
            ticket.getNewTicketAttributes().put(Tickets.ATTRIBUTE_STATUS_ID, targetStatus);
            return true;
        }
        return false;
    }

    public void markReaStepAsRead(OperationChangedTicket changedTicket, int reaStepId) {
        TicketAttributeUnread att;
        if (!this.permissionChecker.checkCurrentUserCanWriteTicket(changedTicket.getTicketId())) {
            return;
        }
        TicketPermissionContext permissionInfo = this.permissionChecker.getTicketPermissionInfo(changedTicket.getTicketId());
        if (permissionInfo.hasSupporterWriteAccessToTicket()) {
            att = Tickets.ATTRIBUTE_UNREAD_SUPPORTER;
        } else if (permissionInfo.hasEnduserAccessToTicket()) {
            att = Tickets.ATTRIBUTE_UNREAD_ENDUSER;
        } else {
            return;
        }
        Set<Integer> attributeValue = changedTicket.getAttributeValue(att);
        HashSet<Integer> newVal = new HashSet<Integer>(attributeValue);
        newVal.removeIf(step -> step <= reaStepId);
        changedTicket.getNewTicketAttributes().put(att, newVal);
        if (newVal.isEmpty() && permissionInfo.hasSupporterWriteAccessToTicket()) {
            this.changeTicketStatusToGelesenIfRequired(changedTicket);
        }
    }

    public void markReaStepAsUnread(OperationChangedTicket changedTicket, int reaStepId) {
        TicketAttributeUnread att;
        if (!this.permissionChecker.checkCurrentUserCanWriteTicket(changedTicket.getTicketId())) {
            return;
        }
        TicketPermissionContext permissionInfo = this.permissionChecker.getTicketPermissionInfo(changedTicket.getTicketId());
        if (permissionInfo.hasSupporterWriteAccessToTicket()) {
            att = Tickets.ATTRIBUTE_UNREAD_SUPPORTER;
        } else if (permissionInfo.hasEnduserAccessToTicket()) {
            att = Tickets.ATTRIBUTE_UNREAD_ENDUSER;
        } else {
            return;
        }
        Set<Integer> attributeValue = changedTicket.getAttributeValue(att);
        HashSet<Integer> newVal = new HashSet<Integer>(attributeValue);
        List<ReaStepVO> reaStepsForTicket = TicketManager.getReader().getReaStepsForTicket(changedTicket.getTicketId(), BundleStepsFilter.WITH_BUNDLE_STEPS);
        for (ReaStepVO step : reaStepsForTicket) {
            if (step.getID() < reaStepId) continue;
            newVal.add(step.getID());
        }
        changedTicket.getNewTicketAttributes().put(att, newVal);
    }

    private static /* synthetic */ boolean lambda$unbundleTickets$4(int masterTicketID, List slaveTicketIDs, Integer id) {
        return id != masterTicketID && !slaveTicketIDs.contains(id);
    }

    public class TicketInnerOperationsImpl
    implements TicketSubOperations {
        private final TicketWriteDAO writeDAO;
        private final TicketReaderImpl reader;
        private final TicketSearchDataCache searchDataCache;

        public TicketInnerOperationsImpl(TicketWriteDAO writeDAO, TicketReaderImpl reader, TicketSearchDataCache searchDataCache) {
            this.writeDAO = writeDAO;
            this.reader = reader;
            this.searchDataCache = searchDataCache;
        }

        public void updateAttachmentFlagForTicket(int ticketID) {
            this.writeDAO.updateAttachmentFlagForTicketAndClearCache(ticketID);
        }

        @Override
        public List<ReaStepVO> getReaStepsForTicket(int ticketId, BundleStepsFilter stepsFilter) {
            TicketPermissionContext supporterAccess = TicketManipulatorInternal.this.permissionChecker.getTicketPermissionInfo(ticketId);
            return this.reader.getReaStepsForTicket(ticketId, supporterAccess, stepsFilter);
        }

        public void onUnbundleClearBundleVisibleForTicket(int ticketId) {
            this.writeDAO.onUnbundleClearBundleVisibleForTicket(ticketId);
        }

        @Override
        public OperationNewReaStep applyAction(OperationChangedTicket ticket, MutableReaStepData reaStepData, ReaStepTextVO reaStepText, ActionVO action, ExtensionArguments extensionArgs) {
            TicketPermissionContext ticketPermissionInfo = this.getTicketPermissionContextFor(ticket);
            return TicketManipulatorInternal.this.applyAction(ticketPermissionInfo, ticket, reaStepData, reaStepText, action, extensionArgs);
        }

        @Override
        public void applyActionWithChecks(OperationChangedTicket ticket, MutableReaStepData reaStepData, ReaStepTextVO reaStepText, ActionVO action, ExtensionArguments extensionArgs, boolean acceptIndirectActions) {
            TicketManipulatorInternal.this.applyAction_withChecks(ticket, action, reaStepData, reaStepText, extensionArgs, acceptIndirectActions);
        }

        @Override
        public void applyActionEditReaStepText(OperationChangedTicket ticket, ExtensionArguments extensionArgs) {
            TicketPermissionContext ticketPermissionInfo = this.getTicketPermissionContextFor(ticket);
            TicketManipulatorInternal.this.updateReaStepText(ticketPermissionInfo, extensionArgs, ticket);
        }

        private TicketPermissionContext getTicketPermissionContextFor(OperationChangedTicket ticket) {
            TicketPermissionContext ticketPermissionInfo = ticket.isNew() ? TicketManager.getTicketPermissionChecker().getTicketPermissionInfo(ticket.createIntermediateTicketVO()) : TicketManager.getTicketPermissionChecker().getTicketPermissionInfo(ticket.getTicketId());
            return ticketPermissionInfo;
        }

        public void clearCachedBundleTickets(int bunId) {
            ((TicketReadDAOCacheCleaner)((Object)TicketManipulatorInternal.this.readDAO)).clearListOfTicketsInBundle(bunId);
        }

        @Override
        public void updateDeadlineExFlagInDatabase(int ticketID, boolean value) {
            this.writeDAO.updateDeadlineExFlag(ticketID, value);
        }

        @Override
        public void indexTicketTagDeadlineFailed(int ticketID) {
            this.searchDataCache.indexTicketTagDeadlineFailed(ticketID);
        }

        @Override
        public void updateTicketDataWithChecks(OperationChangedTicket ticket, MutableTicketData data) {
            TicketManipulatorInternal.this.updateTicketData_withChecks(ticket, data);
        }

        @Override
        public void updateTicketData(OperationChangedTicket ticket, MutableTicketData data) {
            TicketManipulatorInternal.this.updateTicketData(ticket, data);
        }

        @Override
        public OperationChangedTicket createTicket(MutableTicketData newTicketData, ReaStepTextVO ticketText, @Nullable ExtensionArguments extensionArgs, TicketOperationModel model) {
            boolean userIsDispatcher = TicketManipulatorInternal.this.permissionChecker.isDispatcher();
            return TicketManipulatorInternal.this.createTicket(userIsDispatcher, null, newTicketData, ticketText, extensionArgs, model);
        }
    }

    public class ApplyActionData {
        public UserAccount currentUser;
        @Nullable
        public ExtensionArguments extensionArgs;
        public ActionVO action;
        public int status;
        MutableReaStepText mutableText;
        public OperationChangedTicket ticket;
        UserAccount lastEditor;
    }
}

