/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugin.adhoc;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.id.GUID;
import com.inet.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HDDatabaseStore {
    public static final String TABLE_NAME = "tbl_adhoc_userstore";
    public static final String COL_IDENTIFIER = "identifier";
    public static final String COL_NAME = "name";
    private static final Logger LOG = HDLogger.LOG;
    private static final Pattern USER_FILE_PATTERN = Pattern.compile("^\"(.*?)\";\"(.*)\"$");
    private final GUID userID;
    private final ConnectionFactory connectionFactory;

    public HDDatabaseStore(ConnectionFactory connectionFactory, GUID userID) {
        LOG.debug((Object)"new HDDatabaseStore");
        this.connectionFactory = connectionFactory;
        this.userID = userID;
    }

    public static String[] getUserAndStoreName(String currentName) {
        Matcher m = USER_FILE_PATTERN.matcher(currentName);
        if (m.matches()) {
            return new String[]{m.group(1), m.group(2)};
        }
        return new String[]{currentName};
    }

    public static String createJoinedName(String username, String filename) {
        return "\"" + username + "\";\"" + filename + "\"";
    }

    private static enum StoreTags {
        pages,
        page,
        pageType;

    }
}

