/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.ui.model;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroup;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroupInformation;
import com.inet.http.servlet.ClientLocale;
import com.inet.http.servlet.ClientTimezone;
import com.inet.lib.util.StringFunctions;
import com.inet.thread.timer.DefaultTimer;
import com.inet.thread.timer.DefaultTimerTask;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

@InternalApi
public class ByDateRangeSortGroupInformation
extends SortGroupInformation {
    private static final Map<String, List<DateRange>> DATE_RANGES = new ConcurrentHashMap<String, List<DateRange>>();
    private String columnKey;

    public ByDateRangeSortGroupInformation(String columnKey) {
        this.columnKey = columnKey;
    }

    protected Long getTimeStamp(TicketVO ticket) {
        return (Long)ticket.getForKey(this.columnKey);
    }

    @Override
    public boolean supportsSortGroups() {
        return true;
    }

    @Override
    public String getSortGroupKey(@Nonnull TicketVO ticket) {
        if (ticket == null) {
            return "";
        }
        Long forKey = this.getTimeStamp(ticket);
        if (forKey != null) {
            long timestamp = forKey;
            List<DateRange> dateRanges = this.getDateRanges();
            for (DateRange range : dateRanges) {
                if (!range.matches(timestamp)) continue;
                return String.valueOf(range.getStartTime());
            }
        }
        return "";
    }

    private List<DateRange> getDateRanges() {
        TimeZone timezone = ClientTimezone.getTimeZone();
        List<DateRange> dateRanges = DATE_RANGES.get(timezone.getID());
        if (dateRanges == null) {
            dateRanges = this.createDateRanges(timezone);
            DATE_RANGES.put(timezone.getID(), dateRanges);
        }
        return dateRanges;
    }

    private List<DateRange> createDateRanges(TimeZone timezone) {
        ArrayList<DateRange> dateRanges = new ArrayList<DateRange>();
        ZoneId zoneId = ZoneId.of(timezone.getID());
        ZonedDateTime zdt = this.now(zoneId).atTime(LocalTime.MIDNIGHT).atZone(zoneId);
        long todayStart = zdt.toEpochSecond() * 1000L;
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(timezone);
        calendar.setTimeInMillis(todayStart);
        dateRanges.add(new DateRange(todayStart, () -> Tickets.MSG.getMsg("value.daterange.today", new Object[0])));
        calendar.add(5, -1);
        dateRanges.add(new DateRange(calendar.getTimeInMillis(), () -> Tickets.MSG.getMsg("value.daterange.yesterday", new Object[0])));
        for (int i = 2; i <= 6; ++i) {
            calendar.add(5, -1);
            long weekdayStart = calendar.getTimeInMillis();
            dateRanges.add(new DateRange(weekdayStart, ByDateRangeSortGroupInformation.getDisplayNameFactory("EEEE", timezone, weekdayStart)));
        }
        calendar.setTimeInMillis(todayStart);
        int todaysWeekDay = calendar.get(7) - 1;
        calendar.add(5, -todaysWeekDay - 7);
        dateRanges.add(new DateRange(calendar.getTimeInMillis(), () -> Tickets.MSG.getMsg("value.daterange.lastweek", new Object[0])));
        calendar.setTimeInMillis(todayStart);
        calendar.set(5, 1);
        long thisMonth = calendar.getTimeInMillis();
        dateRanges.add(new DateRange(thisMonth, ByDateRangeSortGroupInformation.getDisplayNameFactory("MMMMM", timezone, thisMonth)));
        calendar.add(2, -1);
        long lastMonth = calendar.getTimeInMillis();
        dateRanges.add(new DateRange(lastMonth, ByDateRangeSortGroupInformation.getDisplayNameFactory("MMMMM", timezone, lastMonth)));
        calendar.setTimeInMillis(todayStart);
        calendar.set(5, 1);
        calendar.set(2, 0);
        long thisYear = calendar.getTimeInMillis();
        dateRanges.add(new DateRange(thisYear, ByDateRangeSortGroupInformation.getDisplayNameFactory("yyyy", timezone, thisYear)));
        calendar.add(1, -1);
        long lastYear = calendar.getTimeInMillis();
        dateRanges.add(new DateRange(lastYear, ByDateRangeSortGroupInformation.getDisplayNameFactory("yyyy", timezone, lastYear)));
        dateRanges.add(new DateRange(0L, () -> Tickets.MSG.getMsg("value.daterange.older", new Object[0])));
        return dateRanges;
    }

    LocalDate now(ZoneId zoneId) {
        return LocalDate.now(zoneId);
    }

    @Nonnull
    private static Supplier<String> getDisplayNameFactory(@Nonnull String pattern, @Nonnull TimeZone timezone, long start) {
        return () -> {
            SimpleDateFormat dateFormat = new SimpleDateFormat(pattern, ClientLocale.getThreadLocale());
            dateFormat.setTimeZone(timezone);
            return dateFormat.format(new Date(start));
        };
    }

    @Override
    public SortGroup getSortGroupForKey(String sortGroupKey) {
        if (!StringFunctions.isEmpty((String)sortGroupKey)) {
            long timestamp = Long.parseLong(sortGroupKey);
            List<DateRange> dateRanges = this.getDateRanges();
            for (DateRange range : dateRanges) {
                if (range.getStartTime() != timestamp) continue;
                return new SortGroup(range.getDisplayName());
            }
        }
        return new SortGroup(Tickets.MSG.getMsg("value.unset", new Object[0]));
    }

    static {
        long now = System.currentTimeMillis();
        long oneHour = 3600000L;
        long diffToEndOfDay = oneHour - now % oneHour;
        DefaultTimer.getInstance().scheduleAtFixedRate(new DefaultTimerTask(){

            public void runImpl() throws Throwable {
                DATE_RANGES.clear();
            }
        }, diffToEndOfDay, oneHour);
    }

    private static class DateRange {
        private long start;
        private Supplier<String> displayNameFactory;

        public DateRange(long start, Supplier<String> displayNameFactory) {
            this.start = start;
            this.displayNameFactory = displayNameFactory;
        }

        public boolean matches(long timestamp) {
            return timestamp >= this.start;
        }

        public long getStartTime() {
            return this.start;
        }

        public String getDisplayName() {
            return this.displayNameFactory.get();
        }
    }
}

