/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model.tickets;

import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.usersandgroups.HDFieldDisplayNameProvider;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.BasicFieldValidation;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;

public class TicketFieldOwnerGuid
extends TicketField<GUID> {
    public static final String KEY = "ownerid";

    public TicketFieldOwnerGuid() {
        super(KEY, null, FieldTypeFactory.auto());
    }

    public GUID copyValue(GUID value) {
        return value;
    }

    @Override
    public TicketVOSingle getValueSourceForSlaveTicketForEnduser(TicketVOSingle master, TicketVOSingle slave) {
        return slave;
    }

    @Override
    public String valueToString(GUID fieldValue) {
        UserAccount userAccount = UserManager.getInstance().getUserAccount(fieldValue);
        if (userAccount == null) {
            return null;
        }
        return userAccount.getDisplayName();
    }

    @Override
    public int getFieldChangeReaStepActionId() {
        return -10;
    }

    @Override
    public String getLabel() {
        return HDFieldDisplayNameProvider.getStaticTicketFieldDisplayName(this.getKey());
    }

    @Override
    public void validateIsValidValue(GUID value) {
        super.validateIsValidValue(value);
        if (value != null) {
            BasicFieldValidation.throwIfFieldValueDoesNotExist((Object)UserManager.getInstance().getUserAccount(value), (Object)value, (String)this.getLabel());
        }
    }
}

