/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model;

import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;

public class MutableReaStepText {
    private String text;
    boolean htmlContent;

    private MutableReaStepText(String text, boolean htmlContent) {
        this.text = text == null ? "" : text;
        this.htmlContent = htmlContent;
    }

    public String getText() {
        return this.text;
    }

    public boolean hasHtmlContent() {
        return this.htmlContent;
    }

    public static MutableReaStepText of(String text, boolean htmlContent) {
        return new MutableReaStepText(text, htmlContent);
    }

    public static MutableReaStepText of(ReaStepTextVO vo) {
        if (vo == null) {
            return MutableReaStepText.of(null, false);
        }
        return new MutableReaStepText(vo.getText(), vo.hasHtmlContent());
    }

    public ReaStepTextVO toVO() {
        return ReaStepTextVO.of(this.text, this.htmlContent);
    }

    public boolean isHtml() {
        return this.htmlContent;
    }

    public void setIsHtml(boolean htmlContent) {
        this.htmlContent = htmlContent;
    }

    public void setText(String text) {
        this.text = text == null ? "" : text;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.htmlContent ? 1231 : 1237);
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MutableReaStepText other = (MutableReaStepText)obj;
        if (this.htmlContent != other.htmlContent) {
            return false;
        }
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }

    public static MutableReaStepText empty() {
        return MutableReaStepText.of("", false);
    }
}

