/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.dbconnection;

import com.inet.classloader.LoaderUtils;
import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.annotation.SuppressFBWarnings;

public class DBConnection
implements Cloneable {
    private String jdbcUrl;
    private String jdbcUser;
    private String jdbcPassword;
    private String jdbcDriverClass;
    private Connection connection;
    private Statement statement;
    private String databaseName;
    private String accountUser;
    private String accountPassword;
    private static Logger logger = LogManager.getLogger((String)"DB Updater");

    public DBConnection() {
    }

    public DBConnection(Connection openConnection) {
        this.connection = openConnection;
    }

    public String getAccountUser() {
        return this.accountUser;
    }

    public void setAccountUser(String accountUser) {
        this.accountUser = accountUser;
    }

    public String getAccountPassword() {
        return this.accountPassword;
    }

    public void setAccountPassword(String accountPassword) {
        this.accountPassword = accountPassword;
    }

    public String getJdbcDriverClass() {
        return this.jdbcDriverClass;
    }

    public void setJdbcDriverClass(String jdbcDriverClass) {
        this.jdbcDriverClass = jdbcDriverClass;
    }

    public String getJdbcPassword() {
        return this.jdbcPassword;
    }

    public void setJdbcPassword(String jdbcPassword) {
        this.jdbcPassword = jdbcPassword;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public String getJdbcUser() {
        return this.jdbcUser;
    }

    public void setJdbcUser(String jdbcUser) {
        this.jdbcUser = jdbcUser;
    }

    public Connection openConnection(DatabaseInfos dbinfo) {
        boolean connect = false;
        try {
            connect = this.connection == null || this.connection.isClosed();
        }
        catch (SQLException e1) {
            connect = true;
        }
        if (connect) {
            if (this.jdbcDriverClass != null) {
                try {
                    Class driverClass = LoaderUtils.classForName((String)this.jdbcDriverClass, (Object)this);
                    DriverManager.registerDriver((Driver)driverClass.newInstance());
                }
                catch (Throwable th) {
                    logger.error(th);
                }
            }
            try {
                LoaderUtils.classForName((String)"sun.jdbc.odbc.JdbcOdbcDriver", (Object)this);
            }
            catch (Throwable th) {
                // empty catch block
            }
            logger.debug((Object)("try to open the connection to " + this.jdbcUrl + " with user " + this.jdbcUser));
            try {
                this.connection = DriverManager.getConnection(this.jdbcUrl, this.jdbcUser, this.jdbcPassword);
                logger.info((Object)"Connection established.");
                try {
                    DatabaseMetaData metaData = this.connection.getMetaData();
                    logger.info((Object)("DatabaseProductName:      " + metaData.getDatabaseProductName()));
                    logger.info((Object)("DatabaseProductVersion:   " + metaData.getDatabaseProductVersion()));
                    logger.info((Object)("DriverName:               " + metaData.getDriverName()));
                    logger.info((Object)("DriverVersion:            " + metaData.getDriverVersion()));
                }
                catch (Throwable t) {
                    logger.error(t);
                }
            }
            catch (SQLException e) {
                logger.warn((Object)"Connection not possible");
                logger.warn((Object)e);
                return null;
            }
        }
        if (dbinfo != null && this.databaseName != null) {
            try {
                dbinfo.activateDatabase(dbinfo.getDBConnection(), this.connection, this.databaseName);
            }
            catch (SQLException e) {
                logger.debug((Object)e);
            }
        }
        return this.connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void closeConnection() {
        block5: {
            try {
                if (this.statement != null) {
                    this.statement.close();
                    this.statement = null;
                }
                if (this.connection == null || this.connection.isClosed()) break block5;
                try {
                    logger.debug((Object)("Closing connection to " + new URL(this.jdbcUrl).getHost()));
                }
                catch (Exception e) {
                    logger.debug((Object)("Closing connection to " + this.jdbcUrl));
                }
                this.connection.close();
                this.connection = null;
            }
            catch (SQLException e) {
                logger.error((Throwable)e);
            }
        }
    }

    public void close(Statement statement) {
        if (statement == null) {
            statement = this.statement;
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (statement == this.statement) {
            this.statement = null;
        }
    }

    public Statement createStatement() {
        if (this.statement != null) {
            try {
                this.statement.getWarnings();
            }
            catch (SQLException e) {
                this.statement = null;
            }
        }
        if (this.statement == null && this.connection != null) {
            try {
                this.statement = this.connection.createStatement();
            }
            catch (SQLException e) {
                logger.error((Throwable)e);
            }
        }
        return this.statement;
    }

    public Statement createUpdatableStatement() {
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.statement = null;
        }
        if (this.statement == null && this.connection != null) {
            try {
                this.statement = this.connection.createStatement(1003, 1008);
            }
            catch (SQLException e) {
                logger.error((Throwable)e);
                logger.error((Object)("Message: " + e.getMessage()));
            }
        }
        return this.statement;
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="internal api")
    public ResultSet executeQuery(String sql) throws SQLException {
        logger.debug((Object)sql);
        try {
            return this.createStatement().executeQuery(sql);
        }
        catch (SQLException e) {
            logger.error((Object)("Exception executing: " + sql + ": " + e.getMessage()));
            throw e;
        }
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="internal api")
    public boolean execute(String sql) throws SQLException {
        logger.debug((Object)sql);
        try {
            boolean result = this.createStatement().execute(sql);
            return result;
        }
        catch (SQLException e) {
            logger.error((Object)("Exception executing: " + sql + ": " + e.getMessage()));
            throw e;
        }
    }

    public int executeUpdate(String sql) throws SQLException {
        return this.executeUpdate(sql, sql);
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="internal api")
    public int executeUpdate(String sql, String logStatement) throws SQLException {
        logger.debug((Object)logStatement);
        try {
            return this.createStatement().executeUpdate(sql);
        }
        catch (SQLException e) {
            logger.error((Object)("Exception executing: " + logStatement + ": " + e.getMessage()));
            throw e;
        }
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="internal api")
    public PreparedStatement prepareStatement(String sql) {
        try {
            if (this.connection != null) {
                return this.connection.prepareStatement(sql);
            }
        }
        catch (SQLException e) {
            logger.error((Throwable)e);
        }
        return null;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        if (this.connection != null) {
            logger.warn((Object)"Changing the database while a connection is active is discouraged");
        }
        this.databaseName = databaseName;
    }

    public Object clone() throws CloneNotSupportedException {
        DBConnection obj = (DBConnection)super.clone();
        obj.setDatabaseName(this.databaseName);
        obj.setJdbcDriverClass(this.jdbcDriverClass);
        obj.setJdbcPassword(this.jdbcPassword);
        obj.setJdbcUrl(this.jdbcUrl);
        obj.setJdbcUser(this.jdbcUser);
        obj.connection = null;
        return obj;
    }
}

