/*
 * Decompiled with CFR 0.152.
 */
package srv.pool;

import com.inet.helpdesk.core.HDLogger;
import com.inet.thread.SessionLocal;
import java.util.Vector;

public class ThreadPool {
    private String name;
    private int maxThreadCount;
    private int currentThreadCount = 0;
    private int idleWorkerThreadCount = 0;
    public Vector<Runnable> runnables = new Vector();

    public ThreadPool(String _name, int n) {
        this.maxThreadCount = n;
        this.name = _name;
    }

    public int getWorkingThreadCount() {
        return this.currentThreadCount - this.idleWorkerThreadCount;
    }

    public int getWorkerThreadCount() {
        return this.currentThreadCount;
    }

    public int getMaxThreadCount() {
        return this.maxThreadCount;
    }

    public int getWaitingThreadCount() {
        return this.runnables.size();
    }

    public synchronized void start(Runnable r) {
        this.runnables.addElement(r);
        if (this.idleWorkerThreadCount < this.runnables.size() && (this.currentThreadCount < this.maxThreadCount || this.maxThreadCount == 0)) {
            WorkerThread t = new WorkerThread(this.name);
            t.setContextClassLoader(ClassLoader.getSystemClassLoader());
            t.start();
            ++this.currentThreadCount;
        }
        this.notify();
    }

    private synchronized Runnable getNextThread() {
        ++this.idleWorkerThreadCount;
        while (this.runnables.size() == 0) {
            try {
                this.wait();
            }
            catch (Exception e) {}
        }
        Runnable r = this.runnables.firstElement();
        this.runnables.removeElementAt(0);
        --this.idleWorkerThreadCount;
        return r;
    }

    class WorkerThread
    extends Thread {
        WorkerThread(String name) {
            super(name);
        }

        @Override
        public void run() {
            try {
                try {
                    while (true) {
                        ThreadPool.this.getNextThread().run();
                        SessionLocal.allRemoveThreadFromSession();
                    }
                }
                catch (Error e) {
                    HDLogger.debug("ThreadPool Fehler: " + String.valueOf(e));
                    throw e;
                }
                catch (Exception e) {
                    HDLogger.debug("ThreadPool Exception: " + String.valueOf(e));
                    HDLogger.error(e);
                    --ThreadPool.this.currentThreadCount;
                }
            }
            catch (Throwable throwable) {
                --ThreadPool.this.currentThreadCount;
                throw throwable;
            }
        }
    }
}

