/*
 * Decompiled with CFR 0.152.
 */
package srv.automatic;

import com.inet.classloader.I18nMessages;
import com.inet.config.ConfigValue;
import com.inet.helpdesk.config.DatabaseConfigInfo;
import com.inet.helpdesk.config.DatabaseConfigInfoList;
import com.inet.helpdesk.config.DeviceImportConfigInfo;
import com.inet.helpdesk.config.DeviceImportConfigInfoMap;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.config.LdapConnectionInfo;
import com.inet.helpdesk.config.LdapConnectionInfoMap;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.data.DataImportConnector;
import com.inet.helpdesk.core.data.DataImportJob;
import com.inet.helpdesk.core.data.ImportedDeviceDeletionListener;
import com.inet.helpdesk.core.utils.SubListTaskExecutor;
import com.inet.helpdesk.plugins.inventory.server.api.AssetManager;
import com.inet.helpdesk.plugins.inventory.server.api.model.AssetFields;
import com.inet.helpdesk.plugins.inventory.server.api.search.SearchTagArchived;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.OrSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.user.LoginSettings;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.SuppressFBWarnings;
import srv.automatic.deviceimport.AbstractDeviceImporter;
import srv.automatic.deviceimport.DbDeviceImporter;
import srv.automatic.deviceimport.LdapDeviceImporter;
import srv.automatic.deviceimport.MappingHandler;

public class GeraeteImporter {
    private static final ConfigValue<DeviceImportConfigInfoMap> DEVICE_IMPORT_CONFIGS = new ConfigValue(HDConfigKeys.DEVICE_IMPORT_CONFIGS);
    private static final ConfigValue<LdapConnectionInfoMap> LDAP_CONNECTION_INFOS = new ConfigValue(HDConfigKeys.LDAP_CONNECTION_INFOS);
    private static final ConfigValue<DatabaseConfigInfoList> DB_INFOS = new ConfigValue(HDConfigKeys.DB_CONFIGS);
    private static boolean killed = false;
    private final Logger logger;
    private static final Object MONITOR_OBJECT = new Object();
    private static final I18nMessages MSG = new I18nMessages("com.inet.helpdesk.data.i18n.LanguageResources", GeraeteImporter.class);

    public GeraeteImporter(DeviceImportConfigInfo importConfig, String name, Invoker invoker, DataImportJob dataImportJob) {
        this();
        this.runImport(importConfig, name, invoker, dataImportJob);
    }

    public GeraeteImporter(DeviceImportConfigInfo importConfig, String name, DataImportJob dataImportJob) {
        this.logger = LogManager.getLogger((String)"Data Import");
        this.runImport(importConfig, name, new ImportInvoker(), dataImportJob);
    }

    public GeraeteImporter() {
        killed = false;
        this.logger = LogManager.getLogger((String)"Data Import");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runImport(DeviceImportConfigInfo importConfig, String name, Invoker invoker, DataImportJob dataImportJob) {
        String connectionName = importConfig.getConnectionName();
        boolean isLdap = importConfig.isLdap();
        AbstractDeviceImporter importer = null;
        try {
            long startZeit = System.currentTimeMillis();
            dataImportJob.setStartTime(startZeit);
            String filter = "";
            if (isLdap) {
                LdapConnectionInfoMap ldapConns = (LdapConnectionInfoMap)LDAP_CONNECTION_INFOS.get();
                LdapConnectionInfo ldapConn = ldapConns.get(connectionName);
                if (ldapConn == null) {
                    throw new IllegalArgumentException(MSG.getMsg("dataImport.deviceImport.noSuchConnection", new Object[]{connectionName}));
                }
                filter = ldapConn.getSearchContext();
                importer = new LdapDeviceImporter(ldapConn);
            } else {
                DatabaseConfigInfoList list = (DatabaseConfigInfoList)DB_INFOS.get();
                DatabaseConfigInfo dbConn = list.get(connectionName);
                if (dbConn == null) {
                    throw new IllegalArgumentException(MSG.getMsg("dataImport.deviceImport.noSuchConnection", new Object[]{connectionName}));
                }
                importer = new DbDeviceImporter(dbConn);
            }
            filter = filter.trim();
            boolean indirekt = importConfig.isIndirekt() && !importConfig.isIgnoreUser();
            int gerTyp = importConfig.getGerTyp();
            HashMap<String, Integer> userHm = this.getAllValidUsers();
            if (indirekt) {
                userHm = importer.replaceOwnKey(userHm, importConfig.getIndirectUserReferenceObject(), importConfig.getIndirectUserKeyReference(), importConfig.getIndirectUsernameReference(), filter);
            }
            if (userHm.size() > 0) {
                this.logger.debug((Object)"Users found!");
                AssetManager manager = AssetManager.getInstance();
                IndexSearchEngine searchEngine = manager.getSearchEngine();
                AndSearchExpression and = new AndSearchExpression();
                and.add((SearchExpression)new SearchCondition(AssetFields.FIELD_IMPORT_NAME.getKey(), SearchCondition.SearchTermOperator.Equals, (Object)name));
                and.add((SearchExpression)new SearchCondition("archived", SearchCondition.SearchTermOperator.Equals, (Object)SearchTagArchived.FALSE));
                SearchCommand command = new SearchCommand(new SearchExpression[]{and});
                Set devicesWithImportName = searchEngine.simpleSearch(command);
                int newVersID = 0;
                Iterator it = searchEngine.createValuesIterator(AssetFields.FIELD_IMPORTED.getSearchTag(), false, null, id -> devicesWithImportName.contains(id));
                if (it.hasNext()) {
                    Integer key = (Integer)it.next();
                    newVersID = key + 1;
                }
                MappingHandler mph = new MappingHandler(importConfig.getUserSelectedMapping());
                String userRef = importConfig.getSelektionUserMain();
                if (importConfig.isIgnoreUser()) {
                    userRef = null;
                }
                invoker.run(importer, dataImportJob, userHm, importConfig, name, filter, newVersID, gerTyp, mph, userRef, indirekt);
                if (invoker.isSample()) {
                    return;
                }
                if (importConfig.isDelete()) {
                    this.logger.debug((Object)"Delete Statement");
                    List<GUID> deviceIds = this.readIdsOfDevicesFromImportBeforeVersion(name, newVersID);
                    try (UserAccountScope scope = UserAccountScope.createPrivileged();){
                        this.deleteDevices(deviceIds);
                        List<Integer> deleted = deviceIds.stream().map(g -> manager.getAsset(g).getIntID()).collect(Collectors.toList());
                        for (ImportedDeviceDeletionListener listener : ServerPluginManager.getInstance().get(ImportedDeviceDeletionListener.class)) {
                            listener.devicesDeleted(deleted);
                        }
                        dataImportJob.setEntriesDeleted(deviceIds.size());
                    }
                }
            }
            long endZeit = System.currentTimeMillis();
            long dauer = endZeit - startZeit;
            Object msg = importer.getResultStatisticMessage(dataImportJob);
            msg = (String)msg + "  Dauer: " + dauer + "ms";
            this.logger.info(msg);
        }
        catch (Exception error) {
            this.logger.error((Throwable)error);
            String message = error.getMessage();
            if (message == null) {
                message = MSG.getMsg("dataImport.serverError", new Object[0]);
            }
            dataImportJob.setError(message);
        }
        finally {
            dataImportJob.setEndTime(System.currentTimeMillis());
            if (importer != null) {
                importer.cleanup();
            }
        }
    }

    private List<GUID> readIdsOfDevicesFromImportBeforeVersion(String importName, int versionID) throws SQLException {
        AssetManager manager = AssetManager.getInstance();
        IndexSearchEngine searchEngine = manager.getSearchEngine();
        AndSearchExpression and = new AndSearchExpression();
        OrSearchExpression or = new OrSearchExpression();
        or.add((Object)new SearchCondition(AssetFields.FIELD_IMPORTED.getKey(), SearchCondition.SearchTermOperator.LT, (Object)versionID));
        or.add((Object)new SearchCondition(AssetFields.FIELD_IMPORTED.getKey(), SearchCondition.SearchTermOperator.Equals, null));
        and.add((SearchExpression)or);
        and.add((SearchExpression)new SearchCondition(AssetFields.FIELD_IMPORT_NAME.getKey(), SearchCondition.SearchTermOperator.Equals, (Object)importName));
        and.add((SearchExpression)new SearchCondition("archived", SearchCondition.SearchTermOperator.Equals, (Object)SearchTagArchived.FALSE));
        SearchCommand command = new SearchCommand(new SearchExpression[]{and});
        Set results = searchEngine.simpleSearch(command);
        return new ArrayList<GUID>(results);
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="SQL parameter is integer")
    private void deleteDevices(List<GUID> deviceIds) throws SQLException {
        try {
            AssetManager manager = AssetManager.getInstance();
            new SubListTaskExecutor().executeForEachSubList(deviceIds, 900, subList -> deviceIds.forEach(arg_0 -> ((AssetManager)manager).archiveAsset(arg_0)));
        }
        catch (Exception ex) {
            throw (SQLException)ex;
        }
    }

    public void work() {
        DeviceImportConfigInfoMap map = (DeviceImportConfigInfoMap)DEVICE_IMPORT_CONFIGS.get();
        DataImportConnector dataImportConnector = (DataImportConnector)ServerPluginManager.getInstance().getSingleInstance(DataImportConnector.class);
        HashMap<String, DataImportJob> jobs = new HashMap<String, DataImportJob>();
        for (Map.Entry entry : map.entrySet()) {
            String name = (String)entry.getKey();
            DeviceImportConfigInfo importConfig = (DeviceImportConfigInfo)entry.getValue();
            if (dataImportConnector.getJobs(importConfig.getUid()).stream().filter(DataImportJob::isRunning).count() > 0L || !dataImportConnector.isTimeForJob(importConfig.getUid(), importConfig.getSchedule(), Calendar.getInstance())) continue;
            jobs.put(name, dataImportConnector.createJob(importConfig.getUid()));
        }
        new Thread(() -> {
            Object object = MONITOR_OBJECT;
            synchronized (object) {
                ConnectionFactory factory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
                try {
                    for (Map.Entry entry : map.entrySet()) {
                        String name = (String)entry.getKey();
                        DeviceImportConfigInfo importConfig = (DeviceImportConfigInfo)entry.getValue();
                        if (!dataImportConnector.isTimeForJob(importConfig.getUid(), importConfig.getSchedule(), Calendar.getInstance())) continue;
                        try {
                            if (!killed) {
                                new GeraeteImporter(importConfig, name, (DataImportJob)jobs.get(name));
                            }
                            break;
                        }
                        catch (Exception e) {
                            LogManager.getLogger((String)"Data Import").error((Throwable)e);
                        }
                    }
                }
                catch (Exception e) {
                    this.logger.error((Throwable)e);
                }
            }
        }, "DeviceImport - Scheduled").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runNow(DeviceImportConfigInfo importConfig, String name, DataImportJob dataImportJob) {
        Object object = MONITOR_OBJECT;
        synchronized (object) {
            this.logger.info((Object)"Start manual Device Import");
            new GeraeteImporter(importConfig, name, dataImportJob);
        }
    }

    public void kill() {
        try {
            killed = true;
        }
        catch (Throwable e) {
            this.logger.error(e);
        }
    }

    private HashMap<String, Integer> getAllValidUsers() throws SQLException {
        HashMap<String, Integer> userHm = new HashMap<String, Integer>();
        UserManager users = UserManager.getInstance();
        Iterator it = users.getIteratorOverUserAccountIDs();
        while (it.hasNext()) {
            UserAccount userAccount = users.getUserAccount((GUID)it.next());
            if (!userAccount.isActive()) continue;
            for (LoginSettings l : userAccount.getLoginSettings()) {
                UserAccount usr;
                int index;
                String name;
                if (!"system".equals(l.getLoginSource()) || (name = l.getLoginID()) == null || name.length() <= 0) continue;
                String simpleName = GeraeteImporter.normalizeName(name);
                userHm.put(simpleName, HDUsersAndGroups.getUserID(userAccount));
                if (this.logger.isDebug()) {
                    this.logger.debug((Object)("Add possible user for devices '" + simpleName + "' - '" + name + "'"));
                }
                if ((index = simpleName.lastIndexOf(47)) <= -1 || (usr = users.findActiveUserAccount("system", simpleName = simpleName.substring(index + 1))) != null && usr.isActive()) continue;
                if (this.logger.isDebug()) {
                    this.logger.debug((Object)("Add possible user for devices '" + simpleName + "' - '" + name + "'"));
                }
                userHm.put(simpleName, HDUsersAndGroups.getUserID(userAccount));
            }
        }
        return userHm;
    }

    public static String normalizeName(String name) {
        if (name != null) {
            if (name.length() == 0) {
                return null;
            }
            name = name.replaceAll("\\\\", "/").toUpperCase();
        }
        return name;
    }

    private static interface Invoker {
        public void run(AbstractDeviceImporter var1, DataImportJob var2, HashMap<String, Integer> var3, DeviceImportConfigInfo var4, String var5, String var6, int var7, int var8, MappingHandler var9, String var10, boolean var11) throws Exception;

        public boolean isSample();
    }

    private static class ImportInvoker
    implements Invoker {
        private ImportInvoker() {
        }

        @Override
        public void run(AbstractDeviceImporter importer, DataImportJob dataImportJob, HashMap<String, Integer> userHm, DeviceImportConfigInfo importConfig, String name, String filter, int newVersID, int gerTyp, MappingHandler columnMapping, String selektionUserMain, boolean indirekt) throws Exception {
            String userRef = importConfig.getSelektionUserMain();
            if (importConfig.isIgnoreUser()) {
                userRef = null;
            }
            importer.doImport(dataImportJob, userHm, importConfig, name, filter, newVersID, gerTyp, columnMapping, userRef, indirekt, null);
        }

        @Override
        public boolean isSample() {
            return false;
        }
    }

    public static class SampleInvoker
    implements Invoker {
        private List<Map<String, String>> result;

        @Override
        public void run(AbstractDeviceImporter importer, DataImportJob dataImportJob, HashMap<String, Integer> userHm, DeviceImportConfigInfo importConfig, String name, String filter, int newVersID, int gerTyp, MappingHandler columnMapping, String selektionUserMain, boolean indirekt) throws Exception {
            String userRef = importConfig.getSelektionUserMain();
            if (importConfig.isIgnoreUser()) {
                userRef = null;
            }
            this.result = importer.doImport(dataImportJob, userHm, importConfig, name, filter, newVersID, gerTyp, columnMapping, userRef, indirekt, currentRow -> currentRow >= 20);
        }

        @Override
        public boolean isSample() {
            return true;
        }

        public List<Map<String, String>> getResult() {
            return this.result;
        }
    }
}

