/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.trigger;

import com.inet.config.ConfigValue;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.core.ticketmanager.fields.classification.ClassificationManager;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilManager;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationManager;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityManager;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserClassManager;
import com.inet.helpdesk.core.ticketmanager.model.BundleStepsFilter;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.ChangedTicketVO;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEvent;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEventListener;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import srv.automatic.trigger.Trigger;
import srv.automatic.trigger.TriggerHandler;

public class StatusAndItilChangeTrigger {
    private static final ConfigValue<Boolean> EXTENDED_STATE_EVENTS = new ConfigValue(HDConfigKeys.EXTENDED_STATE_EVENTS);
    private static int[] status_where_status_trigger_must_trigger = new int[0];

    private StatusAndItilChangeTrigger() {
    }

    public static void registerTriggerAsListener(ServerPluginManager spm) {
        spm.register(TicketEventListener.class, (Object)new TicketEventListener(){

            @Override
            public void handleEvent(TicketEvent event) {
                UserAccount executingUser = StatusAndItilChangeTrigger.getExecutingUser(event.getResponsibleUserAccountID());
                for (ChangedTicketVO changedTicket : event.getChangedTickets()) {
                    TicketVO oldData = changedTicket.getOldTicket();
                    TicketVO newData = changedTicket.getNewTicket();
                    if (newData == null || oldData != null && oldData.isSlaveInBundle() || newData.isSlaveInBundle() || newData.isInquiry()) continue;
                    if (oldData == null || oldData.getStatusID() != newData.getStatusID()) {
                        for (int triggerStatus : status_where_status_trigger_must_trigger) {
                            if (newData.getStatusID() != triggerStatus) continue;
                            StatusAndItilChangeTrigger.executeTrigger(newData, 3, executingUser);
                            break;
                        }
                    }
                    if (oldData == null || oldData.getItilID() == newData.getItilID()) continue;
                    StatusAndItilChangeTrigger.executeTrigger(newData, 5, executingUser);
                }
            }
        });
    }

    public static void executeStatusTriggerIfActionDidNotChangeStatus(@Nullable TicketVO oldData, @Nonnull TicketVO newData, int actionStatus) {
        if (!((Boolean)EXTENDED_STATE_EVENTS.get()).booleanValue()) {
            return;
        }
        if (oldData == null) {
            return;
        }
        if (oldData.isSlaveInBundle() || newData.isSlaveInBundle()) {
            return;
        }
        if (oldData.isInquiry()) {
            return;
        }
        if (actionStatus < 100) {
            return;
        }
        if (oldData.getStatusID() != newData.getStatusID()) {
            return;
        }
        for (int triggerStatus : status_where_status_trigger_must_trigger) {
            if (newData.getStatusID() != triggerStatus) continue;
            UserAccount executingUser = StatusAndItilChangeTrigger.getExecutingUser(UserManager.getInstance().getCurrentUserAccountID());
            StatusAndItilChangeTrigger.executeTrigger(newData, 3, executingUser);
            break;
        }
    }

    @Nullable
    private static UserAccount getExecutingUser(@Nullable GUID responsibleUserAccID) {
        if (responsibleUserAccID == null || UserManager.PRIVILEGED_ACCOUNT_ID.equals((Object)responsibleUserAccID)) {
            return null;
        }
        return UserManager.getInstance().getUserAccount(responsibleUserAccID);
    }

    private static void executeTrigger(TicketVO ticket, int triggerType, @Nullable UserAccount executingUser) {
        try {
            UserGroupInfo parentRes;
            GUID resID;
            Trigger tr = TriggerHandler.getTrigger(triggerType);
            if (tr == null) {
                return;
            }
            Hashtable<String, String> ht = new Hashtable<String, String>();
            ht.put("aufid", Integer.toString(ticket.getID()));
            ht.put("priid", String.valueOf(ticket.getPriorityID()));
            ht.put("pribezeichnung", StatusAndItilChangeTrigger.getDisplayValue(PriorityManager.getInstance().get(ticket.getPriorityID())));
            ht.put("status", String.valueOf(ticket.getStatusID()));
            try {
                String categoryPathOrThrow = CategoryManager.getInstance().findCategoryPathOrThrow(ticket.getCategoryID());
                ht.put("betreff", categoryPathOrThrow);
            }
            catch (Exception e) {
                HDLogger.warn("Invalid category: " + ticket.getCategoryID());
                HDLogger.warn(e);
            }
            if (triggerType == 3) {
                List<ReaStepVO> reaSteps = TicketManager.getReader().getReaStepsForTicket(ticket.getID(), BundleStepsFilter.WITHOUT_BUNDLE_STEPS);
                for (int i = reaSteps.size() - 1; i > 0; --i) {
                    ReaStepVO step = reaSteps.get(i);
                    ActionVO action = (ActionVO)ActionManager.getInstance().get(step.getActionID());
                    if (action.getStatusID() != ticket.getStatusID()) continue;
                    ht.put("step_action", action.getDisplayValue());
                    ReaStepTextVO stepTextVO = TicketManager.getReader().getReaStepText(step.getID());
                    ht.put("step_text", stepTextVO.isEmpty() ? "" : stepTextVO.getText());
                    ht.put("step_html", String.valueOf(stepTextVO.hasHtmlContent()));
                    break;
                }
            }
            UserGroupInfo res = (resID = ticket.getResourceID()) == null ? null : UserGroupManager.getInstance().getGroup(resID);
            ht.put("resbezeichnung", res == null ? "" : res.getDisplayName());
            if (res != null && res.getParentID() != null && (parentRes = UserGroupManager.getInstance().getGroup(res.getParentID())) != null) {
                ht.put("parent_resbezeichnung", parentRes.getDisplayName());
            }
            ht.put("klassifizierung", StatusAndItilChangeTrigger.getDisplayValue(ClassificationManager.getInstance().get(ticket.getClassificationID())));
            ht.put("itilbezeichnung", StatusAndItilChangeTrigger.getDisplayValue(ItilManager.getInstance().get(ticket.getItilID())));
            UserAccount userAccount = StatusAndItilChangeTrigger.getUserAccountForTicketOwner(ticket.getOwnerID());
            if (userAccount != null) {
                ht.put("gebbezeichnung", StatusAndItilChangeTrigger.getDisplayValue(LocationManager.getInstance().get((Integer)userAccount.getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID))));
                ht.put("benutzerklasse", StatusAndItilChangeTrigger.getDisplayValue(UserClassManager.getInstance().get((Integer)userAccount.getValue((UserField)HDUsersAndGroups.FIELD_CLASS_ID))));
                ht.put("benutzergruppe", (String)ht.get("benutzerklasse"));
                ht.put("username", userAccount.getDisplayName());
                ht.put("useremail", (String)userAccount.getValue((UserField)UsersAndGroups.FIELD_EMAIL));
                ht.put("sprid", (String)userAccount.getValue((UserField)HDUsersAndGroups.FIELD_LANGUAGE));
            } else {
                ht.put("gebbezeichnung", "");
                ht.put("benutzerklasse", "");
                ht.put("username", "");
                ht.put("useremail", "");
                ht.put("sprid", "");
            }
            ht.put("e-mail empfaenger", "");
            if (executingUser != null) {
                ht.put("stepproducer", executingUser.getDisplayName());
            }
            tr.checkData(ht, true);
        }
        catch (Throwable trErr) {
            HDLogger.error("Following error occurred during execution of trigger for ticket with ID=\"" + ticket.getID() + "\":");
            HDLogger.error(trErr);
        }
    }

    private static UserAccount getUserAccountForTicketOwner(@Nullable GUID ticketOwnerID) {
        if (ticketOwnerID == null) {
            return null;
        }
        return UserManager.getInstance().getUserAccount(ticketOwnerID);
    }

    private static String getDisplayValue(FieldVO fieldVo) {
        if (fieldVo != null) {
            return fieldVo.getDisplayValue();
        }
        return "";
    }

    public static void readStatusWhenStatusTriggerMustRun(String str) {
        int count = 1;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != ',') continue;
            ++count;
        }
        status_where_status_trigger_must_trigger = new int[count];
        count = 0;
        StringTokenizer stok = new StringTokenizer(str, ",");
        while (stok.hasMoreTokens()) {
            String value = stok.nextToken();
            StatusAndItilChangeTrigger.status_where_status_trigger_must_trigger[count++] = Integer.parseInt(value);
        }
        for (int i = 0; i < status_where_status_trigger_must_trigger.length; ++i) {
            if (status_where_status_trigger_must_trigger[i] >= 100 && status_where_status_trigger_must_trigger[i] < 400) continue;
            StatusAndItilChangeTrigger.status_where_status_trigger_must_trigger[i] = 0;
        }
    }
}

