/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.internal;

import com.inet.helpdesk.core.error.HDErrors;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketPermissionContext;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.shared.model.Status;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TicketPreconditionChecks {
    public static void throwIfTicketDoesNotExists(@Nullable TicketVO ticket, int ticketID) {
        if (ticket == null) {
            throw new IllegalArgumentException(Tickets.MSG.getMsg("error.ticketDoesNotExist", new Object[]{ticketID}));
        }
    }

    public static void throwIfReaStepDoesNotExists(@Nullable ReaStepVO reaStep, int reaStepID) {
        if (reaStep == null) {
            throw new IllegalArgumentException(String.format("ReaStep with ID \"%d\" does not exist.", reaStepID));
        }
    }

    public static void throwIfTicketIsInquiry(@Nonnull TicketVOSingle ticket) {
        if (ticket.isInquiry()) {
            throw HDErrors.createIllegalTicketStateException("Cannot modify ticket in status " + ticket.getStatusID());
        }
    }

    public static void throwIfTicketIsClosedOrDeleted(@Nonnull TicketVO ticket) {
        if (Status.isClosedOrDeletedStatus(ticket.getStatusID())) {
            throw HDErrors.createIllegalTicketStateException("Cannot modify ticket in status " + ticket.getStatusID());
        }
    }

    public static void throwIfTicketIsDeleted(@Nonnull TicketVO ticket) {
        if (Status.isDeletedStatus(ticket.getStatusID())) {
            throw HDErrors.createIllegalTicketStateException("Cannot modify ticket in status " + ticket.getStatusID());
        }
    }

    public static void throwIfSupporterTriesToCloseOrDeleteSlaveTicket(TicketPermissionContext context, TicketVO ticket, ActionVO action) {
        if (context.hasResourceAccessToTicket() && Status.isClosedOrDeletedStatus(action.getStatusID()) && ticket.isSlaveInBundle()) {
            String msg = String.format("sub-ticket can be closed only by enduser or by closing its master-ticket (ticketID=%d, actionID=%d)", ticket.getID(), action.getId());
            throw HDErrors.createIllegalTicketStateException(msg);
        }
    }
}

