/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.dupcontent;

import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketReaderForSystem;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtension;
import com.inet.helpdesk.core.ticketmanager.extension.TicketSubOperations;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.BundleStepsFilter;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepText;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.DuplicateRange;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedReaStep;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationNewReaStep;
import com.inet.helpdesk.plugins.attachments.server.AttachmentService;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentRow;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentFilePathBuilder;
import com.inet.helpdesk.plugins.attachments.shared.model.AttachmentKey;
import com.inet.helpdesk.ticketmanager.dupcontent.DuplicateContentFinder;
import com.inet.helpdesk.ticketmanager.dupcontent.IdContent;
import com.inet.lib.util.EncodingFunctions;
import com.inet.plugin.ServerPluginManager;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class DuplicatedContentTicketActionExtension
implements TicketActionExtension {
    public static Function<String, String> IMAGE_NORMALIZER;
    private ExtensionArguments.EditReastepTextActionExtensionData data;

    DuplicatedContentTicketActionExtension(ExtensionArguments.EditReastepTextActionExtensionData data) {
        this.data = data;
    }

    @Override
    public void extendTicketAction(ActionVO action, OperationChangedTicket ticket, OperationNewReaStep reaStep, TicketSubOperations operations) {
        MutableReaStepText stepText;
        String text;
        if (this.data != null) {
            OperationChangedReaStep changeReaStep = ticket.changeReaStep(this.data.getChangedReaStepID());
            int currentReaStepID = this.data.getChangedReaStepID();
            MutableReaStepText stepText2 = changeReaStep.getText();
            if (stepText2 == null) {
                return;
            }
            MutableReaStepData fields = changeReaStep.getChangedFields();
            this.findAndSaveDuplicates(currentReaStepID, ticket, stepText2, fields, operations);
        }
        if ((text = (stepText = reaStep.getText()).getText()).isEmpty()) {
            return;
        }
        MutableReaStepData fields = reaStep.getFields();
        int currentReaStepID = reaStep.getReaStepId();
        this.findAndSaveDuplicates(currentReaStepID, ticket, stepText, fields, operations);
    }

    private void findAndSaveDuplicates(int currentReaStepID, OperationChangedTicket ticket, @Nonnull MutableReaStepText stepText, MutableReaStepData fields, TicketSubOperations operations) {
        TicketReaderForSystem reader = TicketManager.getReaderForSystem();
        Stream<IdContent> stream1 = ticket.isNew() ? null : operations.getReaStepsForTicket(ticket.getTicketId(), BundleStepsFilter.WITH_BUNDLE_STEPS).stream().filter(step -> step.hasText() && step.getID() < currentReaStepID).map(step -> {
            int id = step.getID();
            ReaStepTextVO vo = reader.getReaStepText(id);
            return new IdContent(id, vo.getText(), vo.hasHtmlContent());
        });
        Stream<IdContent> stream2 = ticket.getAddedReaSteps().stream().filter(step -> step.getReaStepId() < currentReaStepID).map(step -> {
            int id = step.getReaStepId();
            MutableReaStepText text = step.getText();
            return new IdContent(id, text.getText(), text.hasHtmlContent());
        });
        Stream<IdContent> stream = stream1 == null ? stream2 : Stream.concat(stream1, stream2);
        Iterator<IdContent> it = stream.iterator();
        List<DuplicateRange> duplicateRanges = new DuplicateContentFinder().findDuplicatePositions(stepText.getText(), stepText.isHtml(), it, IMAGE_NORMALIZER);
        fields.put(ReaStepVO.FIELD_DUPLICATED_CONTENT, duplicateRanges);
    }

    static {
        if (ServerPluginManager.getInstance().isPluginLoaded("attachments")) {
            new Runnable(){

                @Override
                public void run() {
                    AttachmentService attachmentService = (AttachmentService)ServerPluginManager.getInstance().getSingleInstance(AttachmentService.class);
                    IMAGE_NORMALIZER = src -> {
                        try {
                            AttachmentKey key = AttachmentFilePathBuilder.convertRestfulPathToKey((String)EncodingFunctions.decodeUrlPath((String)src));
                            AttachmentRow attachment = attachmentService.getAttachment(key);
                            if (attachment == null) {
                                key = AttachmentFilePathBuilder.convertRestfulPathToKey((String)src);
                                attachment = attachmentService.getAttachment(key);
                            }
                            return "image" + attachment.getChecksum() + attachment.getFileLength();
                        }
                        catch (Exception exception) {
                            return src;
                        }
                    };
                }
            }.run();
        } else {
            IMAGE_NORMALIZER = src -> src;
        }
    }
}

