/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager;

import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.operation.TicketOperationRetryException;
import com.inet.thread.ServerLock;
import com.inet.thread.ThreadUtils;

public class TicketManipulatorSync {
    private static final ThreadUtils.Semaphore CREATE_NEW_TICKET = ThreadUtils.getSemaphore((Object)"TicketManager_createTicket");

    public static ServerLock getTicketLock(TicketVO ticket) {
        return TicketManipulatorSync.getTicketLock(ticket.getID());
    }

    public static ServerLock getTicketLock(int ticketID) {
        return ThreadUtils.getLock((Object)TicketManipulatorSync.getTicketSemaphore(ticketID));
    }

    public static ServerLock tryTicketLock(int ticketID) {
        long timeout = System.currentTimeMillis() + 5000L;
        while (System.currentTimeMillis() < timeout) {
            ServerLock serverLock = ThreadUtils.tryLock((Object)TicketManipulatorSync.getTicketSemaphore(ticketID));
            if (serverLock != null) {
                return serverLock;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
        throw new TicketOperationRetryException("Possible deadlock detected. The current opertion is terminated, because some other user or task is currently operating on the ticket. Please run the operation again. The locked ticket is #" + ticketID);
    }

    private static ThreadUtils.Semaphore getTicketSemaphore(int bunId) {
        return ThreadUtils.getSemaphore((Object)("TicketManipulation-" + bunId));
    }

    public static ServerLock getTicketCreationLock() {
        return ThreadUtils.getLock((Object)CREATE_NEW_TICKET);
    }

    public static void assertHasTicketLock(int ticketId) {
        if (!ThreadUtils.hasLock((Object)TicketManipulatorSync.getTicketSemaphore(ticketId))) {
            throw new IllegalMonitorStateException("Must own the monitor for the ticket ticketId=" + ticketId);
        }
    }
}

