/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugin;

import com.inet.classloader.I18nMessages;
import com.inet.config.ConfigurationManager;
import com.inet.config.LicenseInfo;
import com.inet.config.ModulePriority;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ImagesConnector;
import com.inet.helpdesk.core.data.ServerValuesConnector;
import com.inet.plugin.ApplicationDescription;
import com.inet.plugin.RemoteGuiInformation;
import com.inet.plugin.ServerPluginManager;
import com.inet.shared.utils.Version;
import java.net.URL;
import java.sql.Date;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HelpdeskApplicationDescription
implements ApplicationDescription {
    private static final I18nMessages I18N = new I18nMessages("com.inet.helpdesk.plugin.i18n.Application", HelpdeskApplicationDescription.class);
    public static final int DEFAULT_PORT = 8002;
    @Nonnull
    private final Version version = new Version("25.10.198 (2025-10-01)");
    private URL favicon;
    private URL authenticationIcon;

    @Nonnull
    public Version getVersion() {
        return this.version;
    }

    @Nonnull
    public String getApplicationName() {
        return "i-net HelpDesk";
    }

    @Nonnull
    public LicenseInfo validate(Map<String, String> licenseProperties) {
        String displayName;
        Supplier<String> error = (Supplier<String>)((Object)licenseProperties.get("error"));
        if (this.getApplicationName().equals(licenseProperties.get("app"))) {
            String expires = licenseProperties.get("expires");
            if (expires != null) {
                expires = DateFormat.getDateInstance().format(Date.valueOf(expires));
            }
            String usercount = licenseProperties.get("usercount");
            String namedusers = licenseProperties.get("namedusers");
            boolean rent = Boolean.parseBoolean(licenseProperties.get("rent"));
            String baseKey = expires != null ? (rent ? "License_Type_Rent_" : "License_Type_Expires_") : "License_Type_";
            displayName = usercount != null ? I18N.getMsg(baseKey + "X_Users", new Object[]{usercount, expires}) : (namedusers != null ? I18N.getMsg(baseKey + "Named_Users", new Object[]{namedusers, expires}) : I18N.getMsg(baseKey + "Unlimited", new Object[]{expires}));
        } else {
            String[] parts;
            String key;
            displayName = licenseProperties.get("displayname");
            if (displayName == null && error != null && (key = licenseProperties.get("key")) != null && (parts = key.split("-")).length == 3) {
                boolean oldLicense = true;
                for (String part : parts) {
                    try {
                        Integer.parseInt(part);
                    }
                    catch (Exception e) {
                        oldLicense = false;
                        break;
                    }
                }
                if (oldLicense) {
                    error = () -> I18N.getMsg("License_old_helpdesk", new Object[0]);
                }
            }
        }
        String licensee = licenseProperties.get("licensee");
        return new LicenseInfo(() -> displayName, licensee, (Supplier)error, licenseProperties);
    }

    public void appendTrialLicenseParameters(@Nonnull StringBuilder licenseURL, @Nonnull ConfigStructureSettings settings) {
    }

    public String getDefaultSupportAddress() {
        return "helpdesk@inetsoftware.de";
    }

    public int getDefaultPort() {
        return 8002;
    }

    public RemoteGuiInformation getRemoteGuiInformation() {
        ModulePriority modulepriority = new ModulePriority();
        ArrayList<String> priorityModules = new ArrayList<String>();
        ArrayList<String> otherModules = new ArrayList<String>();
        if (ConfigurationManager.isRecoveryMode()) {
            priorityModules.add("/usersandgroups");
            priorityModules.add("/configmanager");
            priorityModules.add("/store");
            priorityModules.add("/maintenance");
            priorityModules.add("/dataimport");
            otherModules.add("");
        } else {
            priorityModules.add("/ticketlist");
            priorityModules.add("/swingclient");
            priorityModules.add("/knowledgebase");
            priorityModules.add("/usersandgroups");
            priorityModules.add("/store");
            otherModules.add("/configmanager");
            otherModules.add("/dataimport");
            otherModules.add("/maintenance");
            otherModules.add("/taskplanner");
        }
        modulepriority.setPriorityModules(priorityModules);
        modulepriority.setOtherModules(otherModules);
        RemoteGuiInformation remoteGuiInformation = new RemoteGuiInformation(modulepriority);
        remoteGuiInformation.setLogoURL(this.getLogoURL(96));
        if (this.authenticationIcon == null) {
            this.authenticationIcon = this.getClass().getResource("/com/inet/helpdesk/images/user/helpdeskauthentication.png");
        }
        remoteGuiInformation.setAuthenticationIconURL(this.authenticationIcon);
        if (!ConfigurationManager.isHelpCenterMode()) {
            try {
                ServerValuesConnector serverValuesConnector = (ServerValuesConnector)ServerPluginManager.getInstance().getSingleInstance(ServerValuesConnector.class);
                remoteGuiInformation.setDefaultHtmlEditorFont(serverValuesConnector.getDefaultFont());
            }
            catch (Throwable t) {
                HDLogger.error(t);
            }
        }
        if (this.favicon == null) {
            ImagesConnector imagesConnector = (ImagesConnector)ServerPluginManager.getInstance().getSingleInstance(ImagesConnector.class);
            this.favicon = imagesConnector.resolveImageURL("favicon.ico", 16);
        }
        remoteGuiInformation.setFaviconURL(this.favicon);
        return remoteGuiInformation;
    }

    public URL getLogoURL(int size) {
        if (size <= 64) {
            return this.getClass().getResource("/com/inet/helpdesk/images/user/helpdesk_64.png");
        }
        if (size <= 96) {
            return this.getClass().getResource("/com/inet/helpdesk/images/user/helpdesk_96.png");
        }
        return this.getClass().getResource("/com/inet/helpdesk/images/user/helpdesk_128.png");
    }

    public int getDefaultNumberOfJobs() {
        int numOfJobs = Runtime.getRuntime().availableProcessors();
        return Math.min(4, numOfJobs);
    }

    @Nullable
    public URL getHelpPrintReport() {
        return HelpdeskApplicationDescription.class.getResource("print/help.rpt");
    }
}

