/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.logging;

import com.inet.classloader.I18nMessages;
import com.inet.logging.EventLog;
import com.inet.usersandgroups.api.user.UserAccount;
import java.util.Locale;

public enum TicketEventLog {
    Created,
    Finished,
    MarkedAsDeleted,
    Reactivated,
    FullyDeleted;

    private static final EventLog<TicketEventLog> EVENT_LOG;
    public static final I18nMessages MSG;

    public void log(UserAccount responsible, int ticketId) {
        String msg = MSG.getMsg(Locale.getDefault(), "eventlog." + this.name(), new Object[]{ticketId});
        EVENT_LOG.log((Enum)this, responsible, msg, null, new Object[]{ticketId});
    }

    static {
        EVENT_LOG = EventLog.register((String)"helpdeskticket");
        MSG = new I18nMessages("com.inet.helpdesk.logging.LanguageResources", TicketEventLog.class);
    }
}

