/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.data;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ActionCreationNotificator;
import java.util.concurrent.CopyOnWriteArrayList;

public class ActionCreationNotificatorImpl
implements ActionCreationNotificator {
    private final CopyOnWriteArrayList<ActionCreationNotificator.ActionCreationListener> listeners = new CopyOnWriteArrayList();

    @Override
    public void notifyAboutNewlyCreatedAction(int actionID) {
        for (ActionCreationNotificator.ActionCreationListener l : this.listeners) {
            try {
                l.actionCreated(actionID);
            }
            catch (Throwable t) {
                HDLogger.error(t);
            }
        }
    }

    @Override
    public void registerListener(ActionCreationNotificator.ActionCreationListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void unregisterListener(ActionCreationNotificator.ActionCreationListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }
}

