/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model.tickets.additionalaccess;

import com.inet.annotations.JsonData;
import com.inet.usersandgroups.api.Hash;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;

@JsonData
public class TicketAdditionalAccessValue {
    private Set<Hash> readAccess = new HashSet<Hash>();
    private Set<Hash> writeAccess = new HashSet<Hash>();

    public TicketAdditionalAccessValue() {
    }

    public TicketAdditionalAccessValue(@Nonnull Set<Hash> readAccess, @Nonnull Set<Hash> writeAccess) {
        this.readAccess = new HashSet<Hash>(readAccess);
        this.writeAccess = new HashSet<Hash>(writeAccess);
    }

    public void setReadAccessFor(Hash responsible) {
        this.writeAccess.remove(responsible);
        this.readAccess.add(responsible);
    }

    public void setWriteAccessFor(Hash responsible) {
        this.readAccess.remove(responsible);
        this.writeAccess.add(responsible);
    }

    public void removeAccessFor(Hash responsible) {
        this.readAccess.remove(responsible);
        this.writeAccess.remove(responsible);
    }

    public Set<Hash> getReadAccess() {
        return this.readAccess;
    }

    public Set<Hash> getWriteAccess() {
        return this.writeAccess;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.readAccess == null ? 0 : this.readAccess.hashCode());
        result = 31 * result + (this.writeAccess == null ? 0 : this.writeAccess.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TicketAdditionalAccessValue other = (TicketAdditionalAccessValue)obj;
        if (this.readAccess == null ? other.readAccess != null : !this.readAccess.equals(other.readAccess)) {
            return false;
        }
        return !(this.writeAccess == null ? other.writeAccess != null : !this.writeAccess.equals(other.writeAccess));
    }
}

