/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model.tickets;

import com.inet.field.SelectOption;
import com.inet.field.fieldtypes.FieldOperator;
import com.inet.field.fieldtypes.FieldType;
import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.field.fieldtypes.FieldTypeSelect_Int;
import com.inet.field.fieldtypes.HasSelectOptions;
import com.inet.helpdesk.core.ticketmanager.fields.MandatoryFieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.BasicFieldValidation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class TicketFieldCategoryId
extends TicketField<Integer>
implements HasSelectOptions {
    public static final String KEY = "categoryid";

    public TicketFieldCategoryId() {
        super(KEY, null, FieldTypeFactory.custom());
        this.setEnduserEditability(MandatoryFieldVO.MandatoryType.VISIBLE);
    }

    @Nonnull
    public FieldType<Integer> createFieldType() {
        return new FieldTypeSelect_Int(KEY, () -> this.getLabel(), this){

            public Set<FieldOperator> getSupportedOperators() {
                HashSet<FieldOperator> supportedOperators = new HashSet<FieldOperator>(super.getSupportedOperators());
                supportedOperators.add(FieldOperator.IS_OR_IS_BELOW);
                return supportedOperators;
            }
        };
    }

    public Integer getValidOrDefaultValue(Integer value, GUID entryID) {
        if (value != null && value == 0) {
            value = null;
        }
        return (Integer)super.getValidOrDefaultValue((Object)value, entryID);
    }

    public void validate(Integer value) {
        super.validate((Object)value);
        if (value != null) {
            BasicFieldValidation.throwIfZero((int)value);
            BasicFieldValidation.throwIfNegative((int)value);
        }
    }

    @Override
    public void validateIsValidValue(Integer value) {
        super.validateIsValidValue(value);
        if (value != null) {
            BasicFieldValidation.throwIfFieldValueDoesNotExist(CategoryManager.getInstance().get(value), (Object)value, (String)this.getLabel());
        }
    }

    @Override
    public TicketVOSingle getValueSourceForSlaveTicketForEnduser(TicketVOSingle master, TicketVOSingle slave) {
        return master;
    }

    @Override
    public String valueToString(Integer fieldValue) {
        CategoryVO oldCategoryVO = (CategoryVO)CategoryManager.getInstance().get(fieldValue);
        if (oldCategoryVO != null) {
            return oldCategoryVO.getDisplayValue();
        }
        return null;
    }

    @Override
    public int getFieldChangeReaStepActionId() {
        return -26;
    }

    public List<SelectOption> getSelectOptions(boolean includeDeleted) {
        Map<Integer, String> pathNames = CategoryManager.getInstance().getAllPathNames(!includeDeleted);
        ArrayList<SelectOption> list = new ArrayList<SelectOption>(pathNames.size());
        pathNames.forEach((key, path) -> list.add(new SelectOption(key.toString(), path)));
        return list;
    }
}

