/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model.tickets;

import com.inet.field.SelectOption;
import com.inet.field.fieldtypes.FieldOperator;
import com.inet.field.fieldtypes.FieldType;
import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.field.fieldtypes.FieldTypeSelect_Int;
import com.inet.helpdesk.core.ticketmanager.fields.status.StatusManager;
import com.inet.helpdesk.core.ticketmanager.fields.status.StatusVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.shared.model.Status;
import com.inet.usersandgroups.api.BasicFieldValidation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public class TicketAttributeStatusId
extends TicketAttribute<Integer> {
    public static final String KEY = "statusid";

    public TicketAttributeStatusId() {
        super(KEY, null, FieldTypeFactory.custom());
    }

    @Nonnull
    public FieldType<Integer> createFieldType() {
        return new FieldTypeSelect_Int(KEY, () -> this.getLabel(), includeDeleted -> {
            List<StatusVO> all = StatusManager.getInstance().getAll(!includeDeleted);
            ArrayList list = new ArrayList(all.size());
            all.forEach(item -> list.add(new SelectOption(String.valueOf(item.getId()), item.getDisplayValue())));
            return list;
        }){

            public Set<FieldOperator> getSupportedOperators() {
                HashSet<FieldOperator> supportedOperators = super.getSupportedOperators();
                supportedOperators = new HashSet<FieldOperator>(supportedOperators);
                supportedOperators.add(FieldOperator.GREATER_OR_EQUAL);
                supportedOperators.add(FieldOperator.GREATER_THAN);
                supportedOperators.add(FieldOperator.LESS_OR_EQUAL);
                supportedOperators.add(FieldOperator.LESS_THAN);
                return supportedOperators;
            }
        };
    }

    public void validate(Integer value) {
        super.validate((Object)value);
        BasicFieldValidation.throwIfNull((Object)value);
    }

    @Override
    public TicketVOSingle getValueSourceForSlaveTicketForEnduser(TicketVOSingle master, TicketVOSingle slave) {
        int slaveStatus = slave.getAttribute(this);
        if (Status.isClosedOrDeletedStatus(slaveStatus)) {
            return slave;
        }
        return master;
    }

    public boolean renderDisplayValueInReporting() {
        return true;
    }
}

