/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager;

import com.inet.id.GUID;
import java.io.Closeable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WithTicketGUID
implements Closeable {
    private static final ThreadLocal<WithTicketGUID> SCOPE = new ThreadLocal();
    @Nonnull
    private GUID ticketGUID;

    @Nonnull
    public static WithTicketGUID create(@Nonnull GUID ticketGUID) {
        if (SCOPE.get() != null) {
            throw new UnsupportedOperationException("have already a TicketGUID: " + String.valueOf(WithTicketGUID.SCOPE.get().ticketGUID) + " nesting is not supported yet.");
        }
        WithTicketGUID value = new WithTicketGUID(ticketGUID);
        SCOPE.set(value);
        return value;
    }

    private WithTicketGUID(@Nonnull GUID ticketGUID) {
        this.ticketGUID = ticketGUID;
    }

    @Override
    public void close() {
        SCOPE.remove();
    }

    @Nullable
    public static GUID getCurrentTicketGUID() {
        WithTicketGUID value = SCOPE.get();
        if (value != null) {
            return value.ticketGUID;
        }
        return null;
    }
}

