/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.reporting.server.datasource;

import com.inet.field.Field;
import com.inet.field.fieldtypes.FieldType;
import com.inet.field.fieldtypes.FieldTypeBoolean;
import com.inet.field.fieldtypes.FieldTypeCurrency;
import com.inet.field.fieldtypes.FieldTypeDate;
import com.inet.field.fieldtypes.FieldTypeDouble;
import com.inet.field.fieldtypes.FieldTypeGUID;
import com.inet.field.fieldtypes.FieldTypeInteger;
import com.inet.field.fieldtypes.FieldTypeSelect_Int;
import com.inet.field.fieldtypes.FieldTypeSelect_String;
import com.inet.field.fieldtypes.FieldTypeString;
import com.inet.field.fieldtypes.FieldTypeTime;
import com.inet.helpdesk.core.reporting.TicketDataSourceConfigurationExtension;
import com.inet.helpdesk.core.reporting.server.datasource.TicketDataSourceConfiguration;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.adhoc.server.api.datasource.DataSourceUtils;
import com.inet.report.database.SimpleResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class TicketDataResultSet
extends SimpleResultSet {
    private final Iterator<Integer> ids;
    protected TicketVO ticket;
    protected final List<Map.Entry<String, DataSourceUtils.ColumnInfoWithLabel>> cols;
    private final List<@Nonnull TicketDataSourceConfigurationExtension> extensions;
    private final TicketDataSourceConfiguration datasource;
    private final String tableName;

    public TicketDataResultSet(Set<Integer> tickets, TicketDataSourceConfiguration datasource, String tableName, List<Map.Entry<String, DataSourceUtils.ColumnInfoWithLabel>> cols) {
        super(TicketDataResultSet.toColumNames(cols));
        this.cols = cols;
        this.ids = tickets.iterator();
        this.datasource = datasource;
        this.tableName = tableName;
        this.extensions = ServerPluginManager.getInstance().get(TicketDataSourceConfigurationExtension.class);
    }

    private static String[] toColumNames(List<Map.Entry<String, DataSourceUtils.ColumnInfoWithLabel>> cols) {
        ArrayList columns = new ArrayList();
        cols.stream().filter(c -> ((DataSourceUtils.ColumnInfoWithLabel)c.getValue()).getColumnType() == 3).forEach(c -> columns.add(((DataSourceUtils.ColumnInfoWithLabel)c.getValue()).getName()));
        return columns.toArray(new String[columns.size()]);
    }

    private boolean isKnownType(FieldType<?> fieldType) {
        return fieldType instanceof FieldTypeDate || fieldType instanceof FieldTypeTime || fieldType instanceof FieldTypeGUID || fieldType instanceof FieldTypeCurrency || fieldType instanceof FieldTypeDouble || fieldType instanceof FieldTypeString || fieldType instanceof FieldTypeBoolean || fieldType instanceof FieldTypeSelect_String || fieldType instanceof FieldTypeSelect_Int || fieldType instanceof FieldTypeInteger;
    }

    public boolean next() throws SQLException {
        while (this.ids.hasNext()) {
            Integer id = this.ids.next();
            this.ticket = TicketManager.getReader().getTicket(id);
            if (this.ticket == null) continue;
            this.getAllRows().add(new Object[0]);
            return super.next();
        }
        return false;
    }

    public Object getObject(int columnIndex) throws SQLException {
        Object value;
        Map.Entry<String, DataSourceUtils.ColumnInfoWithLabel> col = this.cols.get(columnIndex - 1);
        String key = col.getKey();
        switch (key) {
            case "ticketownerid": {
                return StringFunctions.stringValueOf((Object)this.ticket.getOwnerID());
            }
            case "ticketText": {
                ReaStepTextVO reaStepText = TicketManager.getReader().getReaStepText(this.ticket.getInitialReaStepID());
                return reaStepText.getText();
            }
            case "ticketTextIsHtml": {
                return TicketManager.getReader().getReaStepText(this.ticket.getInitialReaStepID()).hasHtmlContent();
            }
            case "priorityidValue": {
                return this.ticket.getPriorityID();
            }
        }
        for (TicketDataSourceConfigurationExtension ext : this.extensions) {
            if (!ext.canHandle(key)) continue;
            return ext.getColumnData(this.ticket, key);
        }
        TicketFieldDefinition def = Tickets.getFieldDefinitionByKey(key);
        Field<?> field = this.datasource.getFieldOrAttributeFromKey(key);
        if (field != null) {
            value = this.ticket.getFieldOrAttributeValue(field);
            if (this.tableName.equals("TicketAdhoc") && !DataSourceUtils.showDisplayValueForField(field) || !this.tableName.equals("TicketAdhoc") && this.isKnownType(field.getFieldType())) {
                if (value != null) {
                    value = DataSourceUtils.convertFieldValueToReportingValue(value, field);
                }
            } else {
                value = def.getDisplayValue(this.ticket);
            }
        } else {
            value = def.getDisplayValue(this.ticket);
        }
        return value;
    }
}

