/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.model.ticket;

import com.inet.annotations.JsonData;
import java.io.Serializable;
import java.util.ArrayList;

@JsonData
public class TicketPermissionsInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ArrayList<TicketPermission> permissions;

    private TicketPermissionsInfo() {
    }

    public TicketPermissionsInfo(boolean editable, boolean finishable, boolean answerable, boolean escalatable, boolean readable) {
        this.permissions = new ArrayList();
        if (editable) {
            this.permissions.add(TicketPermission.EDITABLE);
        }
        if (finishable) {
            this.permissions.add(TicketPermission.FINISHABLE);
        }
        if (answerable) {
            this.permissions.add(TicketPermission.ANSWERABLE);
        }
        if (escalatable) {
            this.permissions.add(TicketPermission.ESCALATABLE);
        }
        if (readable) {
            this.permissions.add(TicketPermission.READABLE);
        }
    }

    public TicketPermissionsInfo(ArrayList<TicketPermission> permissions) {
        this.permissions = permissions;
    }

    public void addPermission(TicketPermission permission) {
        this.permissions.add(permission);
    }

    public boolean isAnswerable() {
        return this.permissions.contains((Object)TicketPermission.ANSWERABLE);
    }

    public boolean isEditable() {
        return this.permissions.contains((Object)TicketPermission.EDITABLE);
    }

    public boolean isFinishable() {
        return this.permissions.contains((Object)TicketPermission.FINISHABLE);
    }

    public boolean isEscalatable() {
        return this.permissions.contains((Object)TicketPermission.ESCALATABLE);
    }

    public boolean isReadable() {
        return this.permissions.contains((Object)TicketPermission.READABLE);
    }

    public boolean isDeletable() {
        return this.permissions.contains((Object)TicketPermission.DELETABLE);
    }

    public boolean isCommentable() {
        return this.permissions.contains((Object)TicketPermission.COMMENTABLE);
    }

    public boolean isBundable() {
        return this.permissions.contains((Object)TicketPermission.BUNDABLE);
    }

    public ArrayList<TicketPermission> getPermissions() {
        return this.permissions;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TicketPermissionsInfo) {
            TicketPermissionsInfo tpi = (TicketPermissionsInfo)obj;
            if (tpi.permissions == null) {
                return this.permissions == null;
            }
            if (this.permissions == null) {
                return false;
            }
            if (tpi.permissions.size() != this.permissions.size()) {
                return false;
            }
            for (TicketPermission tp : tpi.permissions) {
                if (this.permissions.contains((Object)tp)) continue;
                return false;
            }
            return true;
        }
        return super.equals(obj);
    }

    public static enum TicketPermission {
        EDITABLE,
        FINISHABLE,
        ANSWERABLE,
        ESCALATABLE,
        READABLE,
        DELETABLE,
        COMMENTABLE,
        BUNDABLE;

    }
}

