/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config;

import com.inet.annotations.JsonData;
import com.inet.config.ConfigValue;
import com.inet.config.structure.model.ConfigAction;
import com.inet.config.structure.model.ConfigCondition;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigRowAction;
import com.inet.config.structure.model.ItemListConfigProperty;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.config.Translator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

@JsonData
public class MailSenderOrderListConfigProperty
extends ItemListConfigProperty {
    public static final String PROPERTY_KEY = "MailSenderOrderList";
    private static final ConfigValue<String> MAIL_SENDER_ORDER = new ConfigValue(HDConfigKeys.MAIL_SENDER_ORDER);

    public MailSenderOrderListConfigProperty(ConfigStructureSettings settings, Translator translator) {
        super(196, PROPERTY_KEY, "MAILSENDER", MailSenderOrderListConfigProperty.getObjectListValue(settings, translator), translator.translate("mail.sender.order.add"), MailSenderOrderListConfigProperty.getRowActions(settings, translator, settings.getLocale().getLanguage()));
        this.setReloadAfterRowDeletion(true);
        this.setManuallySortable(true);
    }

    static ArrayList<HashMap<String, String>> getObjectListValue(ConfigStructureSettings settings, Translator translator) {
        ArrayList changedValueRaw = (ArrayList)settings.getChangedValue(PROPERTY_KEY, ArrayList.class);
        if (changedValueRaw != null) {
            return changedValueRaw;
        }
        String mailSenderOrder = (String)MAIL_SENDER_ORDER.get();
        ArrayList<HashMap<String, String>> result = MailSenderOrderListConfigProperty.getListFromMailSenderOrderKey(mailSenderOrder, translator);
        return result;
    }

    static ArrayList<HashMap<String, String>> getListFromMailSenderOrderKey(String mailSenderOrder, Translator translator) {
        String choice;
        ArrayList<HashMap<String, String>> result = new ArrayList<HashMap<String, String>>();
        String origChoiceString = mailSenderOrder + "4444";
        final Map<String, String> keyToLabel = MailSenderOrderListConfigProperty.getMailSenderKeyToLabelMap(translator);
        for (int i = 0; i < 4 && !(choice = origChoiceString.substring(i, i + 1)).equals("4"); ++i) {
            result.add(new HashMap<String, String>(){
                {
                    this.put("name", (String)keyToLabel.get(choice));
                    this.put("key", choice);
                }
            });
        }
        return result;
    }

    static Map<String, String> getMailSenderKeyToLabelMap(final Translator translator) {
        HashMap<String, String> keyToLabel = new HashMap<String, String>(){
            {
                this.put("0", translator.translate("mail.sender.order.supporterAddress"));
                this.put("1", translator.translate("mail.sender.order.postfach"));
                this.put("2", translator.translate("mail.sender.order.category"));
                this.put("3", translator.translate("mail.sender.order.resource"));
            }
        };
        return keyToLabel;
    }

    private static ConfigRowAction[] getRowActions(ConfigStructureSettings settings, Translator translator, String language) {
        ArrayList result = new ArrayList();
        ArrayList<HashMap<String, String>> values = MailSenderOrderListConfigProperty.getObjectListValue(settings, translator);
        Map<String, String> map = MailSenderOrderListConfigProperty.getMailSenderKeyToLabelMap(translator);
        return map.keySet().stream().sorted().map(k -> {
            ConfigAction action = new ConfigAction("mail.sender.order.add." + k, (String)map.get(k));
            ConfigCondition condition = new ConfigCondition(ConfigCondition.Operation.Equals, new Object[]{"key", k});
            ConfigRowAction configRowAction = new ConfigRowAction(action, condition, null, null, null, null);
            configRowAction.setAddMultipleEntriesAllowed(false);
            return configRowAction;
        }).collect(Collectors.toList()).toArray(new ConfigRowAction[0]);
    }

    private static ConfigProperty propWith(String type, String label, String keyName, String value) {
        return new ConfigProperty(0, keyName, type, label, (Object)value, null, null);
    }
}

