/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.model.LocalizedKeyWithIcon;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.data.ServerValuesConnector;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.groups.GroupType;
import com.inet.usersandgroups.api.groups.GroupTypeDef;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class LocalizedKeyListFactory {
    public static final int TYPE_DELETABLE_RESOURCE = 47123;

    public static List<LocalizedKey> getResources() {
        return LocalizedKeyListFactory.getResources(true);
    }

    public static List<LocalizedKey> getResources(boolean includeDeleted) {
        Set resources = includeDeleted ? UserGroupManager.getRecoveryEnabledInstance().getGroupsIncludingDeactivated(HDUsersAndGroups.RESOURCE) : UserGroupManager.getRecoveryEnabledInstance().getGroups(HDUsersAndGroups.RESOURCE);
        HashMap idToResource = new HashMap();
        resources.forEach(ugi -> idToResource.put(ugi.getID(), ugi));
        return resources.stream().map(ugi -> {
            String displayName = LocalizedKeyListFactory.getGroupDisplayName(ugi, idToResource);
            boolean isDeleted = !ugi.isActive();
            int resourceId = HDUsersAndGroups.getResourceId(ugi.getID());
            String iconPath = "images/data/47123/" + resourceId;
            if (isDeleted) {
                iconPath = iconPath + "/deleted";
            }
            return new LocalizedKeyWithIcon("" + resourceId, displayName, iconPath);
        }).sorted((o1, o2) -> o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName())).collect(Collectors.toList());
    }

    public static List<LocalizedKey> getUserGroups(boolean includeDeleted, @Nullable GroupType onlyGroupsOfThisType) {
        Set resources = includeDeleted ? (onlyGroupsOfThisType == null ? UserGroupManager.getRecoveryEnabledInstance().getAllGroupsIncludingDeactivated() : UserGroupManager.getRecoveryEnabledInstance().getGroupsIncludingDeactivated(onlyGroupsOfThisType)) : (onlyGroupsOfThisType == null ? UserGroupManager.getRecoveryEnabledInstance().getAllGroups() : UserGroupManager.getRecoveryEnabledInstance().getGroups(onlyGroupsOfThisType));
        Map<GroupType, GroupTypeDef> groupTypes = ServerPluginManager.getInstance().get(GroupTypeDef.class).stream().collect(Collectors.toMap(g -> g.getGroupType(), g -> g));
        HashMap idToResource = new HashMap();
        resources.forEach(ugi -> idToResource.put(ugi.getID(), ugi));
        return resources.stream().sorted((g1, g2) -> {
            int compareTo = Integer.compare(((GroupTypeDef)groupTypes.get(g1.getType())).getPriority(), ((GroupTypeDef)groupTypes.get(g2.getType())).getPriority());
            if (compareTo != 0) {
                return compareTo;
            }
            String d1 = LocalizedKeyListFactory.getGroupDisplayName(g1, idToResource);
            String d2 = LocalizedKeyListFactory.getGroupDisplayName(g2, idToResource);
            return d1.compareToIgnoreCase(d2);
        }).map(ugi -> {
            String displayName = LocalizedKeyListFactory.getGroupDisplayName(ugi, idToResource);
            boolean isDeleted = !ugi.isActive();
            String iconPath = null;
            if (ugi.getType() == HDUsersAndGroups.RESOURCE) {
                int resourceId = HDUsersAndGroups.getResourceId(ugi.getID());
                iconPath = "images/data/47123/" + resourceId;
                if (isDeleted) {
                    iconPath = iconPath + "/deleted";
                }
            }
            return new LocalizedKeyWithIcon(ugi.getID().toString(), displayName, iconPath);
        }).collect(Collectors.toList());
    }

    private static String getGroupDisplayName(UserGroupInfo ugi, Map<GUID, UserGroupInfo> idToResource) {
        Object displayName = ugi.getDisplayName();
        GUID parent = ugi.getParentID();
        while (parent != null) {
            UserGroupInfo parentRes = idToResource.get(parent);
            displayName = parentRes.getDisplayName() + "/" + (String)displayName;
            parent = parentRes.getParentID();
        }
        return displayName;
    }

    public static List<LocalizedKey> getPriorities(ConnectionFactory connectionFactory) {
        ArrayList<LocalizedKey> priorities = new ArrayList<LocalizedKey>();
        try (Connection con = connectionFactory.getConnection();
             PreparedStatement st = con.prepareStatement("select PriID, PriBezeichnung from tblPrioritaeten WHERE geloescht = 0 ORDER BY PriID DESC");
             ResultSet rs = st.executeQuery();){
            while (rs.next()) {
                int priID = rs.getInt(1);
                String bez = rs.getString(2);
                priorities.add(new LocalizedKey("" + priID, bez));
            }
        }
        catch (SQLException e) {
            HDLogger.error(e);
        }
        return priorities;
    }

    public static List<LocalizedKey> getCategories(ServerValuesConnector svc) {
        ArrayList<LocalizedKey> result = new ArrayList<LocalizedKey>();
        if (UserManager.getRecoveryEnabledInstance().getCurrentUserAccount() == null) {
            return result;
        }
        List cats = CategoryManager.getInstance().getAll(true);
        return cats.stream().sorted().map(c -> new LocalizedKey(c.getPath(), c.getPath())).collect(Collectors.toList());
    }
}

