/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.attachmentdisplay;

import com.inet.helpdesk.attachmentdisplay.AttachmentDisplay;
import com.inet.helpdesk.config.AppDataLocation;
import com.inet.helpdesk.core.TicketTextFunctions;
import com.inet.helpdesk.core.attachmentdisplay.AttachmentDisplayProvider;
import com.inet.helpdesk.core.data.TempDirectory;
import com.inet.helpdesk.plugins.attachments.server.AttachmentService;
import com.inet.helpdesk.plugins.attachments.server.AttachmentsServerPlugin;
import com.inet.helpdesk.plugins.attachments.server.MessageMim;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentFileRow;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentRow;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentDescription;
import com.inet.helpdesk.plugins.attachments.shared.MimeMessageContent;
import com.inet.http.servlet.ClientLocale;
import com.inet.http.servlet.SessionStore;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.mail.api.BaseEmail;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.ServerPluginManager;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionListener;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public class MailAttachmentDisplayProvider
implements AttachmentDisplayProvider,
HttpSessionListener {
    private static final List<String> MIME_TYPES = Arrays.asList("message/rfc822");

    @Override
    public String getType() {
        return "htmltext";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getSourceOrContent(String mimeType, AttachmentRow attachment) {
        try {
            PersistenceEntry file;
            Thread.currentThread().setContextClassLoader(BaseEmail.class.getClassLoader());
            StringBuilder sb = new StringBuilder();
            AttachmentService attService = (AttachmentService)ServerPluginManager.getInstance().getSingleInstance(AttachmentService.class);
            MimeMessageContent mimeMessageData = null;
            AttachmentFileRow attachmentFile = attService.getAttachmentFile(attachment.getChecksum(), attachment.getFileLength());
            if (attachmentFile != null && (file = AppDataLocation.getAttachmentFile(attachmentFile.getFilePath())).exists()) {
                try (InputStream input = file.getInputStream();){
                    MimeMessage mimeMessage = new MimeMessage(null, input);
                    String fileName = AttachmentFileRow.getFileName((String)attachment.getChecksum(), (long)attachment.getFileLength());
                    MessageMim mim = new MessageMim(mimeMessage, SessionStore.getHttpSession().getId() + "/" + fileName, AttachmentsServerPlugin.LOGGER);
                    mimeMessageData = mim.getResult();
                    if (mimeMessageData != null && mimeMessageData.getAttachmentList() != null) {
                        for (String[] internalAttachment : mimeMessageData.getAttachmentList()) {
                            internalAttachment.setOwnerId(attachment.getOwnerId());
                            internalAttachment.setStepId(attachment.getStepId());
                        }
                    }
                }
            }
            if (mimeMessageData != null) {
                List attachments;
                String subject;
                String cc;
                String to;
                Object sender;
                sb.append("<html>");
                sb.append("<head>");
                sb.append("<style>");
                sb.append("table.messageheader {width: 100%; border-bottom: 1px solid black; margin-bottom: 30px;}");
                sb.append("table.messageheader td {width: 100%;}");
                sb.append("table.messageheader tr td:first-child {padding-right: 15px; font-weight: bold; width: 0%;}");
                sb.append("</style>");
                sb.append("</head>");
                sb.append("<body>");
                sb.append("<table class=\"messageheader\">");
                long sendTime = mimeMessageData.getSendTime();
                if (sendTime > 0L) {
                    sb.append("<tr><td>").append(AttachmentDisplay.MSG.getMsg("mailtextattachmentdisplayprovider.sent", new Object[0])).append("</td><td>").append(DateFormat.getDateTimeInstance(2, 2, ClientLocale.getThreadLocale()).format(new Date(sendTime))).append("</td></tr>");
                }
                if (!StringFunctions.isEmpty((String)(sender = mimeMessageData.getSender()))) {
                    InternetAddress senderAdress = new InternetAddress((String)sender);
                    sender = senderAdress.getAddress();
                    if (!StringFunctions.isEmpty((String)senderAdress.getPersonal())) {
                        if (!StringFunctions.isEmpty((String)sender)) {
                            sender = " <" + (String)sender + ">";
                        }
                        sender = senderAdress.getPersonal() + (String)sender;
                    }
                    sb.append("<tr><td>").append(AttachmentDisplay.MSG.getMsg("mailtextattachmentdisplayprovider.sender", new Object[0])).append("</td><td>").append(StringFunctions.encodeHTML((String)sender)).append("</td></tr>");
                }
                if (!StringFunctions.isEmpty((String)(to = mimeMessageData.getReceiver()))) {
                    String[] mails;
                    StringBuilder mailBuilder = new StringBuilder();
                    for (String string : mails = to.split(";")) {
                        void var16_23;
                        InternetAddress internetAddress = new InternetAddress(string);
                        String string2 = internetAddress.getAddress();
                        if (!StringFunctions.isEmpty((String)internetAddress.getPersonal())) {
                            void var16_27;
                            if (!StringFunctions.isEmpty((String)string2)) {
                                String string3 = " <" + string2 + ">";
                            }
                            String string4 = internetAddress.getPersonal() + (String)var16_27;
                        }
                        if (StringFunctions.isEmpty((String)var16_23)) continue;
                        if (mailBuilder.length() > 0) {
                            mailBuilder.append(", ");
                        }
                        mailBuilder.append((String)var16_23);
                    }
                    to = mailBuilder.toString();
                    sb.append("<tr><td>").append(AttachmentDisplay.MSG.getMsg("mailtextattachmentdisplayprovider.to", new Object[0])).append("</td><td>").append(StringFunctions.encodeHTML((String)to)).append("</td></tr>");
                }
                if (!StringFunctions.isEmpty((String)(cc = mimeMessageData.getCc()))) {
                    void var16_30;
                    String[] mails;
                    StringBuilder mailBuilder = new StringBuilder();
                    String[] stringArray = mails = cc.split(";");
                    int n = stringArray.length;
                    boolean bl = false;
                    while (var16_30 < n) {
                        void var17_39;
                        String string = stringArray[var16_30];
                        InternetAddress mailAdress = new InternetAddress(string);
                        String string5 = mailAdress.getAddress();
                        if (!StringFunctions.isEmpty((String)mailAdress.getPersonal())) {
                            void var17_37;
                            if (!StringFunctions.isEmpty((String)string5)) {
                                String string6 = " <" + string5 + ">";
                            }
                            String string7 = mailAdress.getPersonal() + (String)var17_37;
                        }
                        if (!StringFunctions.isEmpty((String)var17_39)) {
                            if (mailBuilder.length() > 0) {
                                mailBuilder.append(", ");
                            }
                            mailBuilder.append((String)var17_39);
                        }
                        ++var16_30;
                    }
                    cc = mailBuilder.toString();
                    sb.append("<tr><td>").append(AttachmentDisplay.MSG.getMsg("mailtextattachmentdisplayprovider.cc", new Object[0])).append("</td><td>").append(StringFunctions.encodeHTML((String)cc)).append("</td></tr>");
                }
                if (!StringFunctions.isEmpty((String)(subject = mimeMessageData.getSubject()))) {
                    sb.append("<tr><td>").append(AttachmentDisplay.MSG.getMsg("mailtextattachmentdisplayprovider.subject", new Object[0])).append("</td><td>").append(StringFunctions.encodeHTML((String)subject)).append("</td></tr>");
                }
                if ((attachments = mimeMessageData.getAttachmentList()) != null && !attachments.isEmpty()) {
                    sb.append("<tr><td>").append(AttachmentDisplay.MSG.getMsg("mailtextattachmentdisplayprovider.attachments", new Object[0])).append("</td><td>");
                    int counter = 0;
                    for (AttachmentDescription attachmentDescription : attachments) {
                        if (counter > 0) {
                            sb.append(", ");
                        }
                        long l = attachmentDescription.getFilesize();
                        String fsUnit = "Bytes";
                        if (l > 1000L) {
                            l /= 1024L;
                            fsUnit = "KB";
                        }
                        if (l > 1000L) {
                            l /= 1024L;
                            fsUnit = "MB";
                        }
                        if (l > 1000L) {
                            l /= 1024L;
                            fsUnit = "GB";
                        }
                        sb.append("<a href=\"..").append(attachmentDescription.getFilePath()).append("\" target=\"_blank\">");
                        sb.append(attachmentDescription.getFileName());
                        sb.append("</a>");
                        sb.append(" (").append(l).append(" ").append(fsUnit).append(")");
                        ++counter;
                    }
                    sb.append("</td></tr>");
                }
                sb.append("</table>");
                String text = mimeMessageData.getText();
                if (!StringFunctions.isEmpty((String)text)) {
                    if (mimeMessageData.isHtml()) {
                        text = text.replace("src=\"/Attachment", "src=\"Attachment");
                        text = text.replace("href=\"/Attachment", "href=\"Attachment");
                        sb.append(TicketTextFunctions.getInlinedHtml(text, false));
                    } else {
                        sb.append(TicketTextFunctions.getLightHtmlFromPlainText(text));
                    }
                }
                sb.append("</body>");
            }
            return TicketTextFunctions.getInlinedHtml(sb.toString(), true);
        }
        catch (Throwable t) {
            LogManager.getApplicationLogger().warn((Object)t);
            return null;
        }
    }

    @Override
    public boolean isResponsible(String mimeType, AttachmentRow attachment) {
        String fileNameLowerCase;
        Optional<String> hasMime;
        if (attachment.getFileLength() > 0x1400000L) {
            return false;
        }
        if (mimeType != null && (hasMime = MIME_TYPES.stream().filter(m -> mimeType.equals(m) || mimeType.startsWith(m + ";")).findAny()).isPresent()) {
            return true;
        }
        String fileName = attachment.getFileName();
        return fileName != null && ((fileNameLowerCase = fileName.toLowerCase()).endsWith(".eml") || fileNameLowerCase.endsWith(".emlx") || fileNameLowerCase.endsWith(".mim") || fileNameLowerCase.endsWith(".mime"));
    }

    public void sessionCreated(HttpSessionEvent se) {
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        Path tempAttFolder = TempDirectory.ATTACHMENTS_TEMP.resolve(se.getSession().getId());
        try {
            IOFunctions.deleteDir((Path)tempAttFolder);
        }
        catch (IOException e) {
            LogManager.getApplicationLogger().error((Throwable)e);
        }
    }
}

