/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases.commands;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.IDatabaseInfos;
import com.inet.dbupdater.databases.commands.DefaultAddReferenceCommand;
import com.inet.dbupdater.databases.commands.DefaultAlterDropCommand;
import com.inet.dbupdater.databases.commands.DefaultCommandSyntax;
import com.inet.dbupdater.databases.commands.ICommandFactory;
import com.inet.dbupdater.databases.commands.IComposedCommand;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class MySQLAlterDropCommand
extends DefaultAlterDropCommand {
    private DatabaseInfos dbInfo;
    private final DefaultCommandSyntax syntax;
    private boolean skip = false;

    protected MySQLAlterDropCommand(DatabaseInfos dbInfo, DefaultCommandSyntax syntax, Node tableName) {
        super(dbInfo, syntax, tableName);
        this.syntax = syntax;
        this.dbInfo = dbInfo;
    }

    @Override
    public List<IComposedCommand> addDataset(Node element, ICommandFactory.COMMAND_TYPE action) throws SQLException {
        if (this.getSqlStatement() != null) {
            return null;
        }
        super.addDataset(element, action);
        if (element.getName() == NodeFactory.TAG.index && element.getDiffSource() != null) {
            Node dependentReference = this.getReferenceBind(element);
            if (dependentReference == null) {
                return null;
            }
            if (element.getParameter(IDatabaseInfos.INDEX_PARAM.index_name.name()).equals(dependentReference.getParameter(IDatabaseInfos.REFERENCE_PARAM.fk_name.name()))) {
                this.skip = true;
                return null;
            }
            for (Node node : element.getParent().getChildren(NodeFactory.TAG.index)) {
                if (node == element) break;
                if (dependentReference != this.getReferenceBind(node)) continue;
                return null;
            }
            ArrayList<IComposedCommand> commands = new ArrayList<IComposedCommand>();
            DefaultAlterDropCommand defaultAlterDropCommand = new DefaultAlterDropCommand(this.dbInfo, this.syntax, dependentReference.getParent());
            DefaultAddReferenceCommand command3 = new DefaultAddReferenceCommand(this.dbInfo, this.syntax, dependentReference.getParent());
            commands.add(defaultAlterDropCommand);
            IComposedCommand.addToList(commands, defaultAlterDropCommand.addDataset(dependentReference, ICommandFactory.COMMAND_TYPE.remove));
            commands.add(this);
            commands.add(command3);
            IComposedCommand.addToList(commands, command3.addDataset(dependentReference, ICommandFactory.COMMAND_TYPE.create));
            return commands;
        }
        return null;
    }

    @Override
    public int execute() throws SQLException {
        if (this.skip) {
            return 1;
        }
        return super.execute();
    }

    @Override
    public boolean isFutile() {
        return this.skip;
    }

    private Node getReferenceBind(Node element) {
        String refColumn = element.getParameter(IDatabaseInfos.INDEX_PARAM.column_name.name());
        Node source = element.getDiffSource();
        if (source == null) {
            return null;
        }
        List<? extends Node> refs = source.getParent().getChildren(NodeFactory.TAG.reference);
        if (refs == null || refs.size() == 0) {
            return null;
        }
        Node dependentReference = null;
        for (Node node : refs) {
            if (!refColumn.equalsIgnoreCase(node.getParameter(IDatabaseInfos.REFERENCE_PARAM.fkcolumn_name.name()))) continue;
            dependentReference = node;
            break;
        }
        if (dependentReference == null) {
            return null;
        }
        refs = element.getParent().getChildren(NodeFactory.TAG.reference);
        if (refs != null && refs.size() > 0) {
            for (Node node : refs) {
                if (node.getDiffSource() != dependentReference) continue;
                if (node.getDiffTarget() != null && refColumn.equalsIgnoreCase(node.getDiffTarget().getParameter(IDatabaseInfos.REFERENCE_PARAM.fkcolumn_name.name()))) break;
                return null;
            }
        }
        if ((refs = source.getParent().getChildren(NodeFactory.TAG.index)) == null || refs.size() == 0) {
            return null;
        }
        for (Node node : refs) {
            List<? extends Node> changes;
            if (node == source || !refColumn.equalsIgnoreCase(node.getParameter(IDatabaseInfos.INDEX_PARAM.column_name.name())) || (changes = element.getParent().getChildren(NodeFactory.TAG.index)) == null || changes.size() <= 1) continue;
            for (Node node2 : changes) {
                if (node2.getDiffSource() != node || node2.getDiffTarget() == null || node2.getParameter(IDatabaseInfos.INDEX_PARAM.column_name.name()) != null) continue;
                return null;
            }
        }
        return dependentReference;
    }
}

