/*
 * Decompiled with CFR 0.152.
 */
package srv.mail;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.config.EmailAccount;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.i18n.LocalizationImpl;
import com.inet.id.GUID;
import com.inet.notification.Notification;
import com.inet.notification.NotificationManager;
import com.inet.notification.PermissionNotificationGenerator;
import com.inet.permissions.Permission;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

@JsonData
public class MailConnectionErrorNotification
extends PermissionNotificationGenerator {
    private static Set<GUID> PREVIOUS_ERROR_IDS = new HashSet<GUID>();
    private static Set<GUID> USED_ERROR_IDS = new HashSet<GUID>();
    private static final Object ERROR_IDS_LOCK = new Object();
    private GUID id;
    private String emailAccountDisplayString;
    private String emailAccountHostString;
    private String errorMessage;
    private long creationTimeStamp;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MailConnectionErrorNotification(EmailAccount postfach, String errorMessage) {
        super(new Permission[]{Permission.CONFIGURATION, HdPermissions.TICKET_RESOURCES_READ_WRITE});
        this.errorMessage = errorMessage;
        this.id = MailConnectionErrorNotification.getNotificationIdFor(postfach);
        this.emailAccountDisplayString = postfach.getDisplayString();
        this.emailAccountHostString = postfach.getHost();
        Object object = ERROR_IDS_LOCK;
        synchronized (object) {
            USED_ERROR_IDS.add(this.id);
        }
        this.creationTimeStamp = System.currentTimeMillis();
    }

    public String getPeriodKey() {
        if (this.errorMessage == null || this.errorMessage.isBlank()) {
            return "";
        }
        return this.emailAccountDisplayString + this.emailAccountHostString;
    }

    public GUID getId() {
        return this.id;
    }

    public Notification createNotification() {
        if ("".equals(this.errorMessage)) {
            String title = LocalizationImpl.getStaticInstance().getTranslation("MAIL_CONNECT_RESTORED", this.emailAccountDisplayString);
            Notification notification = new Notification(title, "");
            notification.setCritical(false);
            return notification;
        }
        String title = LocalizationImpl.getStaticInstance().getTranslation("MAIL_CONNECT_FAIL", this.emailAccountDisplayString);
        Notification notification = new Notification(title, this.errorMessage);
        notification.setCritical(true);
        return notification;
    }

    public static GUID getNotificationIdFor(EmailAccount postfach) {
        int hashCode = postfach.getAccount() == null ? 23684 : postfach.getAccount().hashCode();
        int hashCode2 = postfach.getHost() == null ? 3564567 : postfach.getHost().hashCode();
        return GUID.generateFor((int)(723 + 31 * hashCode + 11 * postfach.getPort() + 13 * hashCode2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearUnusedErrors() {
        Object object = ERROR_IDS_LOCK;
        synchronized (object) {
            ArrayList<GUID> toRemove = new ArrayList<GUID>(PREVIOUS_ERROR_IDS);
            toRemove.removeAll(USED_ERROR_IDS);
            for (GUID guid : toRemove) {
                if (guid == null) continue;
                NotificationManager.getInstance().unregisterGenerator(guid);
            }
            PREVIOUS_ERROR_IDS = USED_ERROR_IDS;
            USED_ERROR_IDS = new HashSet<GUID>();
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public long getCreationTimeStamp() {
        return this.creationTimeStamp;
    }

    public String getGroupingKey() {
        return "helpdesk.notification.email.errors";
    }
}

