/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.search;

import com.inet.error.ErrorCode;
import com.inet.globalbanner.GlobalBanner;
import com.inet.globalbanner.GlobalBannerManager;
import com.inet.helpdesk.core.ticketmanager.SlaveInfo;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.search.SearchTagItilLinks;
import com.inet.helpdesk.ticketmanager.search.SearchTagReaStepIds;
import com.inet.helpdesk.ticketmanager.search.SearchTagReaStepText;
import com.inet.helpdesk.ticketmanager.search.TicketIdMatcher;
import com.inet.helpdesk.ticketmanager.search.TicketSearchDataCache;
import com.inet.helpdesk.ticketmanager.search.TicketTagsMatcher;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.HelpDeskReindexKeyGenerator;
import com.inet.id.GUID;
import com.inet.plugin.Executable;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.SearchDataCache;
import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import com.inet.search.command.JoinTokenMatcher;
import com.inet.search.command.TokenMatcher;
import com.inet.search.index.IdType;
import com.inet.search.index.IndexSearchEngine;
import com.inet.search.index.SearchResultListener;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TicketSearchEngine {
    public static final String SLAVE_INFO_KEY = "aufid";
    private IndexSearchEngine<Integer> searchEngine;
    private TicketSearchDataCache searchDataCache;
    private IndexSearchEngine<Integer> stepEngine;
    private IndexSearchEngine<SlaveInfo> slaveInfoSearchEngine;
    private AtomicBoolean wasReindexRunning = new AtomicBoolean();

    private String createReindexKey() {
        return HelpDeskReindexKeyGenerator.createReindexKey(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(TicketSearchDataCache cache) throws IOException {
        if (cache == null) {
            throw new IllegalArgumentException("search data cache must not be null");
        }
        if (this.searchDataCache != null) {
            throw new IllegalStateException("search data cache is already set");
        }
        String reindexKey = this.createReindexKey();
        IndexSearchEngine searchEngine = new IndexSearchEngine("ticketsearch", reindexKey, false, Integer.class, false);
        IndexSearchEngine bunIdSearchEngine = new IndexSearchEngine("ticketids", reindexKey, false, SlaveInfo.class, false);
        IndexSearchEngine stepEngine = new IndexSearchEngine("ticketsteps", reindexKey, false, new IdType(Integer.class, 'S'), false);
        try {
            this.searchDataCache = cache;
            for (SearchTag tag2 : cache.getInitialSearchTags()) {
                searchEngine.addTag(tag2);
            }
            searchEngine.setPrimaryTag(searchEngine.getTag("statusid"));
            searchEngine.addTag((SearchTag)new TicketIdMatcher((IndexSearchEngine<Integer>)searchEngine));
            searchEngine.addTag((SearchTag)new SearchTagItilLinks((IndexSearchEngine<Integer>)searchEngine));
            searchEngine.addTokenMatcher((TokenMatcher)new TicketTagsMatcher((IndexSearchEngine<Integer>)searchEngine));
            Set userFields = UserManager.getInstance().getSearchEngine().getTags().stream().filter(tag -> tag.isSuggestedTag()).map(tag -> tag.getTag()).collect(Collectors.toSet());
            userFields.remove("allowedactions");
            JoinTokenMatcher.addToIndex((IndexSearchEngine)searchEngine, (String)"ownerid", (IndexSearchEngine)UserManager.getInstance().getSearchEngine(), userFields, (boolean)true);
            JoinTokenMatcher.addToIndex((IndexSearchEngine)searchEngine, (String)"lasteditorid", (IndexSearchEngine)UserManager.getInstance().getSearchEngine(), userFields, (boolean)false);
            bunIdSearchEngine.addTag(new SearchTag(SLAVE_INFO_KEY, SearchDataType.Integer, false, 0));
            bunIdSearchEngine.setData((SearchDataCache)this.searchDataCache.getSlaveInfoSearchDataCache(), 1);
            SearchTagReaStepIds parentSearchTag = new SearchTagReaStepIds();
            searchEngine.addTag((SearchTag)parentSearchTag);
            SearchTagReaStepText searchTag = new SearchTagReaStepText();
            searchEngine.addTokenMatcher((TokenMatcher)new JoinTokenMatcher<Integer>(searchEngine, (SearchTag)parentSearchTag, stepEngine, (SearchTag)searchTag, true){

                @Nonnull
                public String getTag() {
                    return "reasteptext";
                }

                @Nonnull
                public String getDisplayName() {
                    return this.getChildSuggestedTag().getDisplayName();
                }

                public boolean useTwoStage() {
                    return false;
                }
            });
            stepEngine.addTag((SearchTag)searchTag);
            SearchTag searchTagActionId = new SearchTag("reastepactionid", SearchDataType.Integer, false, 0);
            stepEngine.addTag(searchTagActionId);
            stepEngine.setPrimaryTag(searchTagActionId);
            stepEngine.setData((SearchDataCache)this.searchDataCache.getStepSearchDataCache(), 4);
            searchEngine.addSearchResultListener((SearchResultListener)new SearchResultListener<Integer>(){

                protected void onBeforeReindex() {
                    TicketSearchEngine.this.notifyClientsAboutIndexing(true);
                }

                protected void onAfterReindex() {
                    TicketSearchEngine.this.notifyClientsAboutIndexing(false);
                }
            });
            searchEngine.setData((SearchDataCache)cache, 4);
        }
        finally {
            TicketSearchEngine ticketSearchEngine = this;
            synchronized (ticketSearchEngine) {
                this.slaveInfoSearchEngine = bunIdSearchEngine;
                this.stepEngine = stepEngine;
                this.searchEngine = searchEngine;
                this.notifyAll();
            }
        }
    }

    private void notifyClientsAboutIndexing(final boolean reindexRunning) {
        if (!this.wasReindexRunning.compareAndSet(!reindexRunning, reindexRunning)) {
            return;
        }
        ServerPluginManager.getInstance().runIfPluginLoaded("remotegui", () -> new Executable(){

            public void execute() {
                if (!reindexRunning) {
                    GlobalBannerManager.getInstance().unregisterGlobalBanner("ticket.reIndexActive");
                } else {
                    GlobalBannerManager.getInstance().registerGlobalBanner(new GlobalBanner(){

                        @Nonnull
                        public String getExtensionName() {
                            return "ticket.reIndexActive";
                        }

                        public boolean isVisibleInApp(@Nonnull String appPath) {
                            return "/ticketlist".equals(appPath);
                        }

                        public boolean isAvailableForUser(@Nullable GUID userId) {
                            if (userId == null) {
                                return false;
                            }
                            UserAccount userAccount = UserManager.getInstance().getUserAccount(userId);
                            if (userAccount == null) {
                                return false;
                            }
                            return HDUsersAndGroups.isSupporter(userAccount);
                        }

                        @Nonnull
                        public String getText() {
                            return Tickets.MSG.getMsg("ticket.reIndexActive", new Object[0]);
                        }

                        @Nonnull
                        public GlobalBanner.BannerType getBannerType() {
                            return GlobalBanner.BannerType.warning;
                        }

                        @Nullable
                        public GlobalBanner.BannerLink getLink() {
                            return null;
                        }
                    });
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitOnInit() {
        TicketSearchEngine ticketSearchEngine = this;
        synchronized (ticketSearchEngine) {
            while (this.searchEngine == null) {
                try {
                    this.wait(5000L);
                }
                catch (InterruptedException ex) {
                    ErrorCode.throwAny((Throwable)ex);
                }
            }
        }
    }

    @Nonnull
    public IndexSearchEngine<Integer> getSearchEngine() {
        if (this.searchEngine == null) {
            this.waitOnInit();
        }
        return this.searchEngine;
    }

    @Nonnull
    public IndexSearchEngine<SlaveInfo> getSlaveInfoEngine() {
        if (this.slaveInfoSearchEngine == null) {
            this.waitOnInit();
        }
        return this.slaveInfoSearchEngine;
    }

    @Nonnull
    public IndexSearchEngine<Integer> getReaStepSearchEngine() {
        if (this.stepEngine == null) {
            this.waitOnInit();
        }
        return this.stepEngine;
    }

    public boolean hasTag(String key) {
        return this.getSearchEngine().getTag(key) != null;
    }
}

