/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.search;

import com.inet.editor.HtmlConverter;
import com.inet.field.Field;
import com.inet.helpdesk.core.ticketmanager.PluggableTicketSearchTag;
import com.inet.helpdesk.core.ticketmanager.SlaveInfo;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketManagerVetoPower;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.tickets.SearchTagTicketTags;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeHasAttachments;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.search.SearchTagBundleSlave;
import com.inet.helpdesk.ticketmanager.dao.TicketReadDAO;
import com.inet.helpdesk.ticketmanager.dao.TicketReadDAOWithCache;
import com.inet.helpdesk.ticketmanager.internal.TicketChangeCollector;
import com.inet.helpdesk.ticketmanager.search.ReaStepIndexData;
import com.inet.helpdesk.ticketmanager.search.TicketDataForIndexingVO;
import com.inet.helpdesk.ticketmanager.search.TicketMap;
import com.inet.id.GUID;
import com.inet.plugin.DynamicExtension;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.veto.VetoManager;
import com.inet.plugin.veto.VetoType;
import com.inet.search.AbstractSearchDataCache;
import com.inet.search.SearchDataCacheChangeListener;
import com.inet.search.SearchTag;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TicketSearchDataCache
extends AbstractSearchDataCache<Integer> {
    private TicketReadDAO readDAO;
    private TicketReadDAO readDAOWithoutCache;
    private boolean useCachedDAO = true;
    private List<SearchTag> allSearchTags;
    private List<PluggableTicketSearchTag> pluggableSearchTags;
    private List<SearchTagTicketTags.TicketTag> ticketTags;
    private SlaveInfoSearchDataCache slaveInfoSearchDataCache;
    private StepSearchDataCache stepSearchDataCache;
    private static Map<String, TicketField> TICKET_FIELD_MAP;
    private static final DynamicExtension<TicketField> TICKET_FIELDS;
    private static Map<String, TicketAttribute> TICKET_ATTRIBUTE_MAP;
    private static final DynamicExtension<TicketAttribute> TICKET_ATTRIBUTES;

    public void init(TicketReadDAO readDAO, List<PluggableTicketSearchTag<Object>> pluggableSearchTags, List<SearchTagTicketTags.TicketTag> ticketTags) {
        if (readDAO == null) {
            throw new IllegalArgumentException("DAO must not be null");
        }
        if (pluggableSearchTags == null) {
            throw new IllegalArgumentException("list of pluggable ticket search tags must not be null");
        }
        if (ticketTags == null) {
            throw new IllegalArgumentException("list of ticket tags must not be null");
        }
        if (this.readDAO != null) {
            throw new IllegalStateException("already initialized");
        }
        this.readDAO = readDAO;
        this.readDAOWithoutCache = readDAO instanceof TicketReadDAOWithCache ? ((TicketReadDAOWithCache)readDAO).getInstanceWithoutCache() : readDAO;
        this.pluggableSearchTags = Collections.unmodifiableList(new ArrayList<PluggableTicketSearchTag<Object>>(pluggableSearchTags));
        this.ticketTags = Collections.unmodifiableList(new ArrayList<SearchTagTicketTags.TicketTag>(ticketTags));
        TICKET_FIELDS.valuesChanged(DynamicExtensionManager.getInstance().get(TicketField.class));
        TICKET_ATTRIBUTES.valuesChanged(DynamicExtensionManager.getInstance().get(TicketAttribute.class));
        List indexedAttributes = DynamicExtensionManager.getInstance().get(TicketAttribute.class).stream().filter(f -> f.getSearchTag() != null).map(f -> f).collect(Collectors.toList());
        List indexedFields = DynamicExtensionManager.getInstance().get(TicketField.class).stream().filter(f -> f.getSearchTag() != null).map(f -> f).collect(Collectors.toList());
        List tags = indexedFields.stream().map(Field::getSearchTag).collect(Collectors.toList());
        tags.addAll(indexedAttributes.stream().map(Field::getSearchTag).collect(Collectors.toList()));
        tags.add(new SearchTagBundleSlave());
        tags.add(new SearchTagTicketTags());
        for (PluggableTicketSearchTag<Object> pst : pluggableSearchTags) {
            tags.add(pst.getSearchTag());
            pst.addValueChangeListener((ticketID, oldValue, newValue) -> {
                String searchTagKey = pst.getSearchTag().getTag();
                Map<String, Object> oldData = Collections.singletonMap(searchTagKey, oldValue);
                Map<String, Object> newData = Collections.singletonMap(searchTagKey, newValue);
                for (SearchDataCacheChangeListener listener : this.getListeners()) {
                    listener.entryChanged((Object)ticketID, oldData, newData);
                }
            });
        }
        this.allSearchTags = Collections.unmodifiableList(tags);
        this.slaveInfoSearchDataCache = new SlaveInfoSearchDataCache();
        this.stepSearchDataCache = new StepSearchDataCache();
    }

    List<SearchTag> getInitialSearchTags() {
        return this.allSearchTags;
    }

    public Map<String, Object> getCacheEntry(@Nonnull Integer ticketID) {
        TicketReadDAO dao = this.useCachedDAO ? this.readDAO : this.readDAOWithoutCache;
        TicketVO ticket = TicketChangeCollector.loadTicketData(dao, ticketID);
        if (ticket == null) {
            return null;
        }
        return this.toMap(ticket, dao.getReaStepIDsForTicket(ticket.getID()));
    }

    @Nonnull
    public Iterator<Integer> iterator() {
        this.useCachedDAO = false;
        return new Iterator<Integer>(){
            private final Iterator<Integer> it;
            {
                this.it = TicketSearchDataCache.this.readDAOWithoutCache.getTicketIdIterator();
            }

            @Override
            public boolean hasNext() {
                boolean hasNext = this.it.hasNext();
                if (!hasNext) {
                    TicketSearchDataCache.this.useCachedDAO = true;
                }
                return hasNext;
            }

            @Override
            public Integer next() {
                return this.it.next();
            }
        };
    }

    public void ticketCreated(@Nonnull TicketDataForIndexingVO ticketData) {
        TicketVO ticket = ticketData.getTicket();
        Map<String, Object> data = this.toMap(ticketData);
        for (SearchDataCacheChangeListener listener : this.getListeners()) {
            listener.entryAdded((Object)ticket.getID(), data);
        }
        for (Map.Entry entry : ticketData.getReaStepData().entrySet()) {
            Integer reaStepID = (Integer)entry.getKey();
            data = this.toMap((ReaStepIndexData)entry.getValue());
            for (SearchDataCacheChangeListener<Integer> listener : this.stepSearchDataCache.getListeners()) {
                listener.entryAdded((Object)reaStepID, data);
            }
        }
    }

    public void ticketDeleted(@Nonnull TicketDataForIndexingVO ticketData) {
        TicketVO ticket = ticketData.getTicket();
        Map<String, Object> data = this.toMap(ticketData);
        Integer ticketID = ticket.getID();
        for (SearchDataCacheChangeListener listener : this.getListeners()) {
            listener.entryRemoved((Object)ticketID, data);
        }
        SlaveInfo slave = TicketSearchDataCache.getOldSlaveInfo(ticketID);
        if (slave != null) {
            data = this.toSlaveInfoMap(ticketID);
            for (SearchDataCacheChangeListener<SlaveInfo> listener : this.slaveInfoSearchDataCache.getListeners()) {
                listener.entryRemoved((Object)slave, data);
            }
        }
        for (Map.Entry<Integer, ReaStepIndexData> entry : ticketData.getReaStepData().entrySet()) {
            Integer reaStepID = entry.getKey();
            data = this.toMap(entry.getValue());
            for (SearchDataCacheChangeListener<Integer> listener : this.stepSearchDataCache.getListeners()) {
                listener.entryRemoved((Object)reaStepID, data);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void ticketUpdated(@Nonnull TicketDataForIndexingVO oldTicketData, @Nonnull TicketDataForIndexingVO newTicketData) {
        Integer ticketID = oldTicketData.getTicket().getID();
        Map<String, Object> oldData = this.toMap(oldTicketData);
        Map<String, Object> newData = this.toMap(newTicketData);
        boolean newAttachmentFlagValue = newTicketData.getTicket().hasAttachments();
        for (SearchDataCacheChangeListener listener : this.getListeners()) {
            this.removeValueOppositeToNewAttachmentFlag((SearchDataCacheChangeListener<Integer>)listener, ticketID, newAttachmentFlagValue);
            listener.entryChanged((Object)ticketID, oldData, newData);
        }
        if (oldTicketData.getTicket().isSlaveInBundle() || newTicketData.getTicket().isSlaveInBundle()) {
            void var8_11;
            TicketVO ticket = newTicketData.getTicket();
            if (ticket.isSlaveInBundle()) {
                TicketVO master = TicketManager.getReaderForSystem().getTicket(ticket.getBundleID());
                GUID ownerID = master.getOwnerID();
                SlaveInfo slaveInfo = new SlaveInfo(ticket.getID(), ticket.getBundleID(), ownerID, ticket.getResourceID());
            } else {
                Object var8_10 = null;
            }
            SlaveInfo oldSlave = TicketSearchDataCache.getOldSlaveInfo(ticketID);
            if (!Objects.equals(var8_11, oldSlave)) {
                Map<String, Object> data = this.toSlaveInfoMap(ticketID);
                SearchDataCacheChangeListener<SlaveInfo>[] searchDataCacheChangeListenerArray = this.slaveInfoSearchDataCache.getListeners();
                int n = searchDataCacheChangeListenerArray.length;
                for (int i = 0; i < n; ++i) {
                    SearchDataCacheChangeListener<SlaveInfo> listener = searchDataCacheChangeListenerArray[i];
                    if (oldSlave != null) {
                        listener.entryRemoved((Object)oldSlave, data);
                    }
                    if (var8_11 == null) continue;
                    listener.entryAdded((Object)var8_11, data);
                }
            }
        }
        for (Map.Entry entry : newTicketData.getReaStepData().entrySet()) {
            Integer reaStepID = (Integer)entry.getKey();
            oldData = this.toMap(oldTicketData.getReaStepData().get(reaStepID));
            newData = this.toMap((ReaStepIndexData)entry.getValue());
            for (SearchDataCacheChangeListener<Integer> listener : this.stepSearchDataCache.getListeners()) {
                listener.entryChanged((Object)reaStepID, oldData, newData);
            }
        }
    }

    public void indexTicketTagDeadlineFailed(int ticketID) {
        HashMap oldData = new HashMap();
        HashMap<String, Integer> newData = new HashMap<String, Integer>();
        newData.put("tickettags", 2);
        for (SearchDataCacheChangeListener listener : this.getListeners()) {
            listener.entryChanged((Object)ticketID, oldData, newData);
        }
    }

    @Nullable
    private static SlaveInfo getOldSlaveInfo(Integer ticketID) {
        VetoType currentType = VetoManager.getInstance().getCurrentType();
        if (currentType != null && currentType.compareTo(TicketManagerVetoPower.TYPE) < 0) {
            TicketManagerVetoPower.requestReIndexing();
            return null;
        }
        SearchCommand command = new SearchCommand("aufid", SearchCondition.SearchTermOperator.Equals, (Object)ticketID);
        Set search = TicketManager.getReader().getSlaveInfoEngine().simpleSearch(command);
        return search.isEmpty() ? null : (SlaveInfo)search.iterator().next();
    }

    private void removeValueOppositeToNewAttachmentFlag(SearchDataCacheChangeListener<Integer> listener, Integer ticketID, boolean newAttachmentFlagValue) {
        HashMap<String, Integer> oldData = new HashMap<String, Integer>();
        oldData.put("attachments", TicketAttributeHasAttachments.valueAsInt(!newAttachmentFlagValue));
        listener.entryChanged((Object)ticketID, oldData, new HashMap());
    }

    private Map<String, Object> toMap(TicketDataForIndexingVO ticketData) {
        return this.toMap(ticketData.getTicket(), ticketData.getReaStepData() != null ? ticketData.getReaStepData().keySet() : Set.of());
    }

    @Nonnull
    private Map<String, Object> toMap(TicketVO ticket, Collection<Integer> reaStepIDs) {
        return new TicketMap(ticket, reaStepIDs, TICKET_FIELD_MAP, TICKET_ATTRIBUTE_MAP, this.pluggableSearchTags, this.ticketTags);
    }

    private Map<String, Object> toSlaveInfoMap(Integer ticketID) {
        return Collections.singletonMap("aufid", ticketID);
    }

    @Nonnull
    private Map<String, Object> toMap(ReaStepIndexData reaStepData) {
        if (reaStepData == null) {
            return Map.of();
        }
        ReaStepTextVO reaStepText = reaStepData.text();
        if (reaStepText == null) {
            return Map.of();
        }
        String textContent = reaStepText.getTextWithoutDuplicate(reaStepData.duplicateContentRanges());
        if (textContent.isBlank()) {
            return Map.of();
        }
        if (reaStepText.hasHtmlContent()) {
            textContent = HtmlConverter.html2text((String)textContent);
        }
        return Map.of("reasteptext", textContent, "reastepactionid", reaStepData.actionID());
    }

    SlaveInfoSearchDataCache getSlaveInfoSearchDataCache() {
        return this.slaveInfoSearchDataCache;
    }

    StepSearchDataCache getStepSearchDataCache() {
        return this.stepSearchDataCache;
    }

    static {
        TICKET_FIELDS = new DynamicExtension<TicketField>(TicketField.class){

            public void valuesChanged(List<TicketField> values) {
                HashMap<String, TicketField> fieldMap = new HashMap<String, TicketField>();
                values.forEach(field -> fieldMap.put(field.getKey(), (TicketField)((Object)field)));
                TICKET_FIELD_MAP = fieldMap;
            }
        };
        TICKET_ATTRIBUTES = new DynamicExtension<TicketAttribute>(TicketAttribute.class){

            public void valuesChanged(List<TicketAttribute> values) {
                HashMap<String, TicketAttribute> fieldMap = new HashMap<String, TicketAttribute>();
                values.forEach(field -> fieldMap.put(field.getKey(), (TicketAttribute)((Object)field)));
                TICKET_ATTRIBUTE_MAP = fieldMap;
            }
        };
    }

    class SlaveInfoSearchDataCache
    extends AbstractSearchDataCache<SlaveInfo> {
        SlaveInfoSearchDataCache() {
        }

        public Map<String, Object> getCacheEntry(@Nonnull SlaveInfo slave) {
            return Collections.singletonMap("aufid", slave.getAufID());
        }

        @Nonnull
        public Iterator<SlaveInfo> iterator() {
            return TicketSearchDataCache.this.readDAOWithoutCache.getSlaveInfoIterator();
        }

        protected SearchDataCacheChangeListener<SlaveInfo>[] getListeners() {
            return super.getListeners();
        }
    }

    class StepSearchDataCache
    extends AbstractSearchDataCache<Integer> {
        StepSearchDataCache() {
        }

        @Nullable
        public Map<String, Object> getCacheEntry(@Nonnull Integer reaStepID) {
            ReaStepVO reaStep = TicketSearchDataCache.this.readDAOWithoutCache.getReaStep(reaStepID);
            if (reaStep == null) {
                return null;
            }
            ReaStepTextVO reaStepText = TicketSearchDataCache.this.readDAOWithoutCache.getReaStepText(reaStepID);
            if (reaStepText == null) {
                return null;
            }
            String textContent = reaStepText.getTextWithoutDuplicate(reaStep);
            if (textContent.isBlank()) {
                return null;
            }
            if (reaStepText.hasHtmlContent()) {
                textContent = HtmlConverter.html2text((String)textContent);
            }
            return Map.of("reasteptext", textContent, "reastepactionid", reaStep.getActionID());
        }

        @Nonnull
        public Iterator<Integer> iterator() {
            return TicketSearchDataCache.this.readDAOWithoutCache.getReaStepIdIterator();
        }

        protected SearchDataCacheChangeListener<Integer>[] getListeners() {
            return super.getListeners();
        }
    }
}

