/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.shared.model.user;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.shared.model.DataField;
import com.inet.helpdesk.shared.model.Field;
import com.inet.helpdesk.shared.model.user.UserReadOnly;
import java.io.Serializable;
import java.util.ArrayList;
import javax.annotation.Nonnull;

@JsonData
public class User
implements UserReadOnly,
Serializable {
    private static final long serialVersionUID = 1L;
    private ArrayList<DataField> data = new ArrayList();

    public void addData(Field field, Object value) {
        for (DataField dataField : this.data) {
            if (dataField.getField() != field) continue;
            this.data.remove(dataField);
            break;
        }
        this.data.add(new DataField(field, value));
    }

    public void setData(Field field, Object value) {
        for (DataField dataField : this.data) {
            if (dataField.getField() != field) continue;
            this.data.remove(dataField);
            break;
        }
        this.data.add(new DataField(field, value));
    }

    public void removeData(DataField dataField) {
        this.data.remove(dataField);
    }

    public void removeField(Field field) {
        for (int i = 0; i < this.data.size(); ++i) {
            DataField dataField = this.data.get(i);
            if (dataField.getField() != field) continue;
            this.data.remove(dataField);
        }
    }

    public void addData(DataField dataField) {
        for (DataField existingField : this.data) {
            if (existingField.getField() != dataField.getField()) continue;
            this.data.remove(existingField);
            break;
        }
        this.data.add(dataField);
    }

    @Override
    @Nonnull
    public String getDisplayName() {
        String value = this.getValue(Field.USERDATA_DISPLAYNAME, String.class);
        if (value != null) {
            return value.toString();
        }
        throw new NullPointerException("DisplayName is null");
    }

    @Override
    @Nonnull
    public String getUserName() {
        String value = this.getValue(Field.USERDATA_USERNAME, String.class);
        if (value != null) {
            return value.toString();
        }
        throw new NullPointerException("UserName is null");
    }

    @Override
    public int getUserID() {
        Integer value = this.getValue(Field.USERDATA_USERID, Integer.class);
        if (value != null) {
            return value;
        }
        throw new NullPointerException("UserID is null");
    }

    public ArrayList<DataField> getData() {
        return this.data;
    }

    @Override
    public <T> T getValue(Field field, Class<T> dataClass) {
        for (DataField dField : this.data) {
            if (!field.equals((Object)dField.getField())) continue;
            return dField.getValue(dataClass);
        }
        return null;
    }
}

