/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.ui.model;

import com.inet.annotations.InternalApi;
import com.inet.field.ConfigurableField;
import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketfieldsettings.fields.CustomTicketFieldDefinition;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldSortedIteratorDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroupInformation;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public abstract class TicketFieldDefinition
implements ConfigurableField {
    private FIELD_GROUPING grouping;
    private String key;
    private String description;
    private boolean supportsText;
    private boolean supportsIcon;
    private int prio;
    @Nonnull
    private FIELD_VISIBILITY visibility = FIELD_VISIBILITY.SUPPORTER;

    protected TicketFieldDefinition(TicketField<?> field, boolean supportsText, boolean supportsIcon, int prio) {
        this(FIELD_GROUPING.TICKET, field.getKey(), supportsText, supportsIcon, prio);
    }

    protected TicketFieldDefinition(TicketAttribute<?> attribute, boolean supportsText, boolean supportsIcon, int prio) {
        this(FIELD_GROUPING.TICKET, attribute.getKey(), supportsText, supportsIcon, prio);
    }

    protected TicketFieldDefinition(FIELD_GROUPING grouping, TicketField<?> field, boolean supportsText, boolean supportsIcon, int prio) {
        this(grouping, field.getKey(), supportsText, supportsIcon, prio);
    }

    protected TicketFieldDefinition(FIELD_GROUPING grouping, TicketAttribute<?> attribute, boolean supportsText, boolean supportsIcon, int prio) {
        this(grouping, attribute.getKey(), supportsText, supportsIcon, prio);
    }

    protected TicketFieldDefinition(FIELD_GROUPING grouping, String key, boolean supportsText, boolean supportsIcon, int prio) {
        this.grouping = grouping;
        this.key = key;
        this.supportsText = supportsText;
        this.supportsIcon = supportsIcon;
        this.prio = prio;
    }

    public FIELD_GROUPING getGrouping() {
        return this.grouping;
    }

    public String getKey() {
        return this.key;
    }

    public boolean supportsText() {
        return this.supportsText;
    }

    public boolean supportsIcon() {
        return this.supportsIcon;
    }

    public final String getDisplayName() {
        return this.getLabel();
    }

    public URL getColumnIcon(Integer iconSize) {
        return null;
    }

    public URL getIconForValue(String valueAsString, int size) {
        return null;
    }

    public String getValueAsStringForIcon(@Nonnull TicketVO ticket) {
        return null;
    }

    public abstract String getDisplayValue(@Nonnull TicketVO var1);

    public Object getPlainValue(@Nonnull TicketVO ticket) {
        return null;
    }

    public SortGroupInformation getSortGroupInformation() {
        return SortGroupInformation.noSortGroups;
    }

    @Nullable
    public FieldEditDefinition getEditDefinition() {
        return null;
    }

    @Nonnull
    public Comparator<TicketVO> getComparator() {
        boolean isTextField;
        boolean bl = isTextField = this.getDisplayType() == FieldSettingsType.TYPE_TEXT;
        if (this.getDisplayType() == FieldSettingsType.TYPE_SELECT && this instanceof CustomTicketFieldDefinition) {
            isTextField = true;
        }
        if (isTextField) {
            Comparator comp = String.CASE_INSENSITIVE_ORDER;
            Comparator nullsFirst = Comparator.nullsFirst(comp);
            return (a, b) -> {
                try {
                    return nullsFirst.compare(a.getForKey(this.getKey()), b.getForKey(this.getKey()));
                }
                catch (ClassCastException ex) {
                    HDLogger.debug(ex);
                    Object valA = a.getForKey(this.getKey());
                    Object valB = b.getForKey(this.getKey());
                    String strA = valA == null ? null : valA.toString();
                    String strB = valB == null ? null : valB.toString();
                    return nullsFirst.compare(strA, strB);
                }
            };
        }
        Comparator comp = Comparator.naturalOrder();
        Comparator nullsFirst = Comparator.nullsFirst(comp);
        return (a, b) -> {
            try {
                return nullsFirst.compare(a.getForKey(this.key), b.getForKey(this.key));
            }
            catch (Exception ex) {
                throw new IllegalStateException("key=" + this.key + " \na=" + a.toString() + " \nb=" + b.toString(), ex);
            }
        };
    }

    @Nullable
    public FieldSortedIteratorDefinition getSortedDefinition() {
        return null;
    }

    public String getFieldKey() {
        return this.getKey();
    }

    public void setSortPrio(int prio) {
        this.prio = prio;
    }

    public final int getPriority() {
        return this.prio;
    }

    public boolean isAvailable() {
        switch (this.visibility) {
            case ENDUSER: {
                return true;
            }
            case HIDDEN: {
                return false;
            }
            case SUPPORTER: {
                return HDUsersAndGroups.isSupporter();
            }
        }
        throw new UnsupportedOperationException(this.visibility.toString());
    }

    public String getDescription(TicketVO ticket) {
        return this.getDescription();
    }

    @Nullable
    public FieldSettingsType getDisplayType() {
        return null;
    }

    @Nonnull
    public final FIELD_VISIBILITY getVisibility() {
        return this.visibility;
    }

    public final void setVisibility(@Nonnull FIELD_VISIBILITY visibility) {
        Objects.requireNonNull(visibility);
        this.visibility = visibility;
    }

    @Nonnull
    public Map<String, String> getProperties() {
        return Collections.emptyMap();
    }

    public static enum FIELD_GROUPING {
        TICKET,
        TICKET_OWNER;


        public String getDisplayName() {
            return Tickets.MSG.getMsg("ticketlist.columns.grouping." + this.name(), new Object[0]);
        }
    }

    public static enum FIELD_VISIBILITY {
        ENDUSER,
        SUPPORTER,
        HIDDEN;

    }
}

