/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model.tickets;

import com.inet.fieldsettings.api.model.GenericFieldSetting;
import com.inet.helpdesk.core.ticketfieldsettings.fields.CustomTicketField;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationNewReaStep;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.BasicFieldValidation;
import javax.annotation.Nullable;

public class TicketFieldOpenField<T>
extends CustomTicketField<T> {
    public static final String KEY_ONE = "custom1";
    public static final String KEY_TWO = "custom2";
    public static final String KEY_THREE = "custom3";
    public static final String KEY_FOUR = "custom4";
    public static final String KEY_FIVE = "custom5";
    public static final String KEY_SIX = "custom6";
    public static final String KEY_SEVEN = "custom7";
    public static final String KEY_IDENTIFIER = "identifier";
    private final int maxLength;

    public TicketFieldOpenField(String key, GenericFieldSetting setting) {
        super(key, setting, TicketFieldOpenField.defaultSearchPrio(key));
        switch (key) {
            case "custom1": 
            case "custom2": 
            case "custom3": 
            case "custom4": {
                this.maxLength = 255;
                break;
            }
            case "custom5": {
                this.maxLength = Integer.MAX_VALUE;
                break;
            }
            case "custom6": 
            case "custom7": {
                this.maxLength = 100;
                break;
            }
            case "identifier": {
                this.maxLength = 255;
                break;
            }
            default: {
                throw new UnsupportedOperationException(key);
            }
        }
    }

    @Nullable
    private static Integer defaultSearchPrio(String key) {
        switch (key) {
            case "custom1": {
                return 500;
            }
            case "custom2": {
                return 490;
            }
            case "custom3": {
                return 480;
            }
            case "custom4": {
                return 470;
            }
            case "custom5": {
                return 460;
            }
            case "custom6": {
                return 450;
            }
            case "custom7": {
                return 440;
            }
        }
        return null;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public T getValidOrDefaultValue(T value, GUID entryID) {
        return (T)super.getValidOrDefaultValue(value, entryID);
    }

    public void validate(T value) {
        super.validate(value);
        if (value != null && value instanceof String) {
            BasicFieldValidation.throwIfLengthExceedsLimit((String)((String)value), (int)(this.maxLength - 10));
        }
    }

    @Override
    public TicketVOSingle getValueSourceForSlaveTicketForEnduser(TicketVOSingle master, TicketVOSingle slave) {
        return slave;
    }

    @Override
    public OperationNewReaStep createStringFieldChangeReaStep(T oldFieldValue, T newFieldValue, MutableReaStepData additionalReaStepData, OperationChangedTicket ticket) {
        if ((oldFieldValue == null || oldFieldValue instanceof String && ((String)oldFieldValue).isBlank()) && (newFieldValue == null || newFieldValue instanceof String && ((String)newFieldValue).isBlank())) {
            return null;
        }
        return super.createStringFieldChangeReaStep(oldFieldValue, newFieldValue, additionalReaStepData, ticket);
    }
}

