/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model.tickets;

import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.tickets.GeneratedTicketAttribute;
import com.inet.helpdesk.core.ticketmanager.timeline.TimelineDataHandler;
import com.inet.helpdesk.shared.model.ticket.TicketTimelineInformations;
import com.inet.plugin.ServerPluginManager;

public class TicketAttributeDeadlineLight
extends GeneratedTicketAttribute<Value> {
    public static final String KEY = "deadlinelight";
    private static TimelineDataHandler dataHandler = null;

    public TicketAttributeDeadlineLight() {
        super(KEY);
    }

    @Override
    public Value getValueFor(int ticketId) {
        TicketTimelineInformations deadlineData = TicketAttributeDeadlineLight.getHandler().getDeadlineData(ticketId);
        if (deadlineData == null) {
            return null;
        }
        long targetTime = deadlineData.getTargetTime();
        long firstTreshold = deadlineData.getFirstThreshold();
        long secondTreshold = deadlineData.getSecondThreshold();
        long now = System.currentTimeMillis();
        if (now > targetTime) {
            return Value.attention;
        }
        if (now < firstTreshold) {
            return Value.green;
        }
        if (now >= firstTreshold && now <= secondTreshold) {
            return Value.yellow;
        }
        if (now > secondTreshold) {
            return Value.red;
        }
        return null;
    }

    @Override
    public TicketVOSingle getValueSourceForSlaveTicketForEnduser(TicketVOSingle master, TicketVOSingle slave) {
        return master;
    }

    public Value copyValue(Value value) {
        return value;
    }

    public static TimelineDataHandler getHandler() {
        if (dataHandler == null) {
            ServerPluginManager spm = ServerPluginManager.getInstance();
            dataHandler = (TimelineDataHandler)spm.getSingleInstance(TimelineDataHandler.class);
        }
        return dataHandler;
    }

    public static enum Value {
        attention,
        green,
        yellow,
        red;

    }
}

