/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fielddefinitions;

import com.inet.http.servlet.ClientLocale;
import com.inet.http.servlet.ClientTimezone;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;

public class DateTimeUtils {
    public static String dateTimeToShortFormat(long timestamp) {
        return DateTimeUtils.dateTimeToShortFormat(timestamp, System.currentTimeMillis());
    }

    static String dateTimeToShortFormat(long timestamp, long now) {
        ZoneId zoneId = ClientTimezone.getTimeZone().toZoneId();
        LocalDateTime date = LocalDateTime.ofInstant(Instant.ofEpochMilli(now), ZoneId.systemDefault()).withNano(0).withSecond(0).withMinute(0).withHour(0);
        if (timestamp >= date.atZone(zoneId).toInstant().toEpochMilli()) {
            if (timestamp >= (date = date.plusDays(1L)).atZone(zoneId).toInstant().toEpochMilli()) {
                DateFormat dateInstance = DateFormat.getDateInstance(2, ClientLocale.getThreadLocale());
                dateInstance.setTimeZone(ClientTimezone.getTimeZone());
                return dateInstance.format(new Date(timestamp));
            }
            DateFormat timeInstance = DateFormat.getTimeInstance(3, ClientLocale.getThreadLocale());
            timeInstance.setTimeZone(ClientTimezone.getTimeZone());
            return timeInstance.format(new Date(timestamp));
        }
        if (timestamp >= (date = date.minusDays(6L)).atZone(zoneId).toInstant().toEpochMilli()) {
            String timePattern = ((SimpleDateFormat)DateFormat.getTimeInstance(3, ClientLocale.getThreadLocale())).toPattern();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EE, " + timePattern, ClientLocale.getThreadLocale());
            simpleDateFormat.setTimeZone(ClientTimezone.getTimeZone());
            return simpleDateFormat.format(new Date(timestamp));
        }
        DateFormat dateInstance = DateFormat.getDateInstance(2, ClientLocale.getThreadLocale());
        dateInstance.setTimeZone(ClientTimezone.getTimeZone());
        return dateInstance.format(new Date(timestamp));
    }

    public static String dateTimeToLongFormat(long timestamp) {
        DateFormat dateTimeInstance = DateFormat.getDateTimeInstance(2, 3, ClientLocale.getThreadLocale());
        dateTimeInstance.setTimeZone(ClientTimezone.getTimeZone());
        return dateTimeInstance.format(new Date(timestamp));
    }
}

