/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.permissions;

import com.inet.annotations.InternalApi;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

@InternalApi
public class HdPermissions {
    private static final String CATEGORY_TICKET = "ticket";
    private static final Object namedUserPermissionsMonitor;
    public static final Comparator<Permission> PERMISSION_COMPARATOR;
    private static ArrayList<Permission> freePermissions;
    public static final Permission ITIL_DEFINITION;
    public static final Permission TEMPLATE_DEFINITION;
    public static final Permission DISPATCHER;
    public static final Permission TICKET_RESOURCES_READ;
    public static final Permission TICKET_RESOURCES_READ_WRITE;
    private static Permission[] namedUserPermissions;

    private static Permission add(String key, int sortId, String subCategory, boolean free) {
        return HdPermissions.add(key, sortId, subCategory, null, free);
    }

    private static Permission add(String key, int sortId, String subCategory, String parentKey, boolean free) {
        Permission perm = SystemPermissionManager.add((String)key, (String)subCategory, (String)parentKey, (int)sortId, (boolean)false, HdPermissions.class);
        if (free) {
            HdPermissions.addFreePermission(perm);
        }
        return perm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFreePermission(Permission permission) {
        freePermissions.add(permission);
        Object object = namedUserPermissionsMonitor;
        synchronized (object) {
            namedUserPermissions = new Permission[0];
        }
    }

    public static List<Permission> getFreePermissions() {
        return freePermissions;
    }

    public static Permission[] getNamedUserLicensePermissions() {
        if (namedUserPermissions.length > 0) {
            return namedUserPermissions;
        }
        ArrayList<Permission> licensePermissions = new ArrayList<Permission>(Arrays.asList(Permission.values()));
        List<Permission> freePermissions = HdPermissions.getFreePermissions();
        licensePermissions.removeAll(freePermissions);
        namedUserPermissions = licensePermissions.toArray(new Permission[licensePermissions.size()]);
        return namedUserPermissions;
    }

    public static Permission[] getSortedPermissions() {
        Permission[] permissions = Permission.values();
        Arrays.sort(permissions, PERMISSION_COMPARATOR);
        return permissions;
    }

    static {
        Permission.createCategory((String)CATEGORY_TICKET, (int)1000, HdPermissions.class);
        namedUserPermissionsMonitor = new Object();
        PERMISSION_COMPARATOR = new Comparator<Permission>(){

            @Override
            public int compare(Permission o1, Permission o2) {
                int val = o1.getCategoryDisplayName().compareToIgnoreCase(o2.getCategoryDisplayName());
                if (val != 0) {
                    return val;
                }
                return o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName());
            }
        };
        freePermissions = new ArrayList();
        ITIL_DEFINITION = HdPermissions.add("itilDefinition", 3200, "administration", false);
        TEMPLATE_DEFINITION = HdPermissions.add("templateDefinition", 6300, "administration", false);
        DISPATCHER = HdPermissions.add("dispatcher", 1100, CATEGORY_TICKET, false);
        TICKET_RESOURCES_READ = HdPermissions.add("ticketResourcesRead", 1200, CATEGORY_TICKET, false);
        TICKET_RESOURCES_READ_WRITE = HdPermissions.add("ticketResourcesReadWrite", 1250, CATEGORY_TICKET, TICKET_RESOURCES_READ.getKey(), false);
        namedUserPermissions = new Permission[0];
    }
}

