/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config;

import com.inet.helpdesk.config.ScaledTicketValueIconRequestData;
import com.inet.helpdesk.config.ScaledTicketValueIconResponseData;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ImagesConnector;
import com.inet.helpdesk.core.ticketmanager.fields.classification.ClassificationManager;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilManager;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityManager;
import com.inet.helpdesk.core.ticketmanager.fields.status.StatusManager;
import com.inet.http.utils.MimeTypes;
import com.inet.lib.io.FastByteArrayInputStream;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.image.ImageScaler;
import com.inet.remote.gui.angular.ServiceMethod;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Base64;
import javax.annotation.SuppressFBWarnings;

public class ScaledTicketValueIcon
extends ServiceMethod<ScaledTicketValueIconRequestData, ScaledTicketValueIconResponseData> {
    public String getMethodName() {
        return "getScaledTicketValueIcon";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Only hard coded URLs are opened.")
    public ScaledTicketValueIconResponseData invoke(HttpServletRequest req, HttpServletResponse res, ScaledTicketValueIconRequestData input) {
        try {
            String base64Image = input.getBase64Image();
            if (StringFunctions.isEmpty((String)base64Image)) {
                int typeId = Integer.parseInt(input.getAdditionalValues().get("typeId"));
                int id = Integer.parseInt(input.getAdditionalValues().get("id"));
                URL icon = null;
                if (typeId == 2) {
                    icon = PriorityManager.getInstance().getIcon(id, input.getSize(), false);
                }
                if (typeId == 3) {
                    icon = ClassificationManager.getInstance().getIcon(id, input.getSize());
                }
                if (typeId == 0) {
                    icon = StatusManager.getInstance().getIcon(id, input.getSize());
                }
                if (typeId == 7) {
                    icon = ItilManager.getInstance().getIcon(id, input.getSize());
                }
                if (icon == null) {
                    ImagesConnector imagesConnector = (ImagesConnector)ServerPluginManager.getInstance().getSingleInstance(ImagesConnector.class);
                    icon = imagesConnector.getDataImage(typeId, String.valueOf(id), input.getSize());
                }
                if (icon == null) return new ScaledTicketValueIconResponseData(null, false);
                URLConnection connection = icon.openConnection();
                try (InputStream in = icon.openStream();){
                    byte[] bytes = IOFunctions.readBytes((InputStream)in);
                    String contentType = connection.getContentType();
                    if (contentType == null && icon.getFile() != null) {
                        contentType = MimeTypes.getMimeType((String)icon.getFile());
                    }
                    if (contentType == null) {
                        contentType = "image/unknown";
                    }
                    String base64string = "data:" + contentType + ";base64," + Base64.getEncoder().encodeToString(bytes);
                    ScaledTicketValueIconResponseData scaledTicketValueIconResponseData = new ScaledTicketValueIconResponseData(base64string, "scaled".equals(icon.getRef()));
                    return scaledTicketValueIconResponseData;
                }
            }
            URL imgUrl = new URL(input.getBase64Image());
            try (InputStream in = imgUrl.openStream();){
                ImageScaler.ImageScalerResult result = ImageScaler.scale((InputStream)new FastByteArrayInputStream(IOFunctions.readBytes((InputStream)in)), (int)input.getSize());
                String base64string = "data:image/png;base64," + Base64.getEncoder().encodeToString(result.getImageData());
                ScaledTicketValueIconResponseData scaledTicketValueIconResponseData = new ScaledTicketValueIconResponseData(base64string, result.isScaled());
                return scaledTicketValueIconResponseData;
            }
        }
        catch (Throwable t) {
            HDLogger.error(t);
        }
        return new ScaledTicketValueIconResponseData(null, false);
    }

    public short getMethodType() {
        return 1;
    }
}

