/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.attachmentdisplay;

import com.inet.helpdesk.config.AppDataLocation;
import com.inet.helpdesk.core.attachmentdisplay.AttachmentDisplayProvider;
import com.inet.helpdesk.plugins.attachments.server.AttachmentService;
import com.inet.helpdesk.plugins.attachments.server.calendar.CalendarParser;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentFileRow;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentRow;
import com.inet.helpdesk.plugins.attachments.shared.CalendarDateContent;
import com.inet.lib.json.Json;
import com.inet.logging.LogManager;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.ServerPluginManager;

public class CalendarAttachmentDisplayProvider
implements AttachmentDisplayProvider {
    @Override
    public String getType() {
        return "calendar";
    }

    @Override
    public String getSourceOrContent(String mimeType, AttachmentRow attachment) {
        try {
            AttachmentService attService = (AttachmentService)ServerPluginManager.getInstance().getSingleInstance(AttachmentService.class);
            AttachmentFileRow attachmentFile = attService.getAttachmentFile(attachment.getChecksum(), attachment.getFileLength());
            if (attachmentFile != null) {
                PersistenceEntry file = AppDataLocation.getAttachmentFile(attachmentFile.getFilePath());
                CalendarDateContent calendarDateContent = CalendarParser.parse((PersistenceEntry)file);
                return new Json().toJson((Object)calendarDateContent);
            }
        }
        catch (Throwable t) {
            LogManager.getApplicationLogger().error(t);
        }
        return null;
    }

    @Override
    public boolean isResponsible(String mimeType, AttachmentRow attachment) {
        String fileNameLowerCase;
        if (mimeType != null && (mimeType.equals("text/calendar") || mimeType.startsWith("text/calendar;"))) {
            return true;
        }
        String fileName = attachment.getFileName();
        return fileName != null && ((fileNameLowerCase = fileName.toLowerCase()).endsWith(".calendar") || fileNameLowerCase.endsWith(".ics"));
    }

    @Override
    public boolean isJsonSerializedSource() {
        return true;
    }
}

